/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import javax.persistence.EntityManager;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.task.service.persistence.TaskTransactionManager;

class TaskJTATransactionManager
implements TaskTransactionManager {
    private TransactionManager tm = new JtaTransactionManager(null, null, null);

    TaskJTATransactionManager() {
    }

    @Override
    public void attachPersistenceContext(EntityManager em) {
        em.joinTransaction();
    }

    @Override
    public boolean begin(EntityManager em) {
        int status = this.getStatus(em);
        boolean begun = false;
        if (status == 3 || status == 0 || status == 1) {
            begun = this.tm.begin();
        }
        return begun;
    }

    @Override
    public void commit(EntityManager em, boolean txOwner) {
        this.tm.commit(txOwner);
    }

    @Override
    public void rollback(EntityManager em, boolean txOwner) {
        switch (this.tm.getStatus()) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                this.tm.rollback(txOwner);
            }
        }
    }

    @Override
    public int getStatus(EntityManager em) {
        return this.tm.getStatus();
    }

    @Override
    public void dispose() {
        this.tm = null;
    }
}

