/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.task.admin.TasksAdmin;
import org.jbpm.task.admin.TasksAdminImpl;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.persistence.TaskJTATransactionManager;
import org.jbpm.task.service.persistence.TaskPersistenceManager;
import org.jbpm.task.service.persistence.TaskSessionFactory;

public class TaskSessionFactoryImpl
implements TaskSessionFactory {
    private final EntityManagerFactory emf;
    private final TaskService taskService;
    private final boolean useJTA;

    public TaskSessionFactoryImpl(TaskService taskService, EntityManagerFactory emf) {
        this.emf = emf;
        this.taskService = taskService;
        this.useJTA = TaskSessionFactoryImpl.useJTATransactions(emf);
    }

    static boolean useJTATransactions(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        boolean useJTA = false;
        try {
            em.getTransaction();
        }
        catch (Exception e) {
            boolean illegalStateExceptionThrown = false;
            for (Throwable cause = e; cause != null && !illegalStateExceptionThrown; cause = cause.getCause()) {
                illegalStateExceptionThrown = cause instanceof IllegalStateException;
            }
            if (illegalStateExceptionThrown) {
                useJTA = true;
            }
            throw new RuntimeException("Unable to determine persistence-unit type (JTA/Local)", e);
        }
        return useJTA;
    }

    @Override
    public TaskServiceSession createTaskServiceSession() {
        TaskPersistenceManager tpm = this.useJTA ? new TaskPersistenceManager(this.emf.createEntityManager(), new TaskJTATransactionManager()) : new TaskPersistenceManager(this.emf.createEntityManager());
        return new TaskServiceSession(this.taskService, tpm);
    }

    @Override
    public TasksAdmin createTaskAdmin() {
        TaskPersistenceManager tpm = this.useJTA ? new TaskPersistenceManager(this.emf.createEntityManager(), new TaskJTATransactionManager()) : new TaskPersistenceManager(this.emf.createEntityManager());
        return new TasksAdminImpl(tpm);
    }
}

