/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.CollectionHandle;
import org.eclipse.webdav.client.DAVClient;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.client.PropertyStatus;
import org.eclipse.webdav.client.ResourceHandle;
import org.eclipse.webdav.client.ResponseInputStream;
import org.eclipse.webdav.client.URLTable;
import org.eclipse.webdav.client.URLTool;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.HrefSet;
import org.eclipse.webdav.dom.LockDiscovery;
import org.eclipse.webdav.dom.LockInfo;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.MultiStatus;
import org.eclipse.webdav.dom.Owner;
import org.eclipse.webdav.dom.Prop;
import org.eclipse.webdav.dom.PropFind;
import org.eclipse.webdav.dom.PropStat;
import org.eclipse.webdav.dom.PropertyBehavior;
import org.eclipse.webdav.dom.PropertyUpdate;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.dom.ResponseBody;
import org.eclipse.webdav.dom.Status;
import org.eclipse.webdav.dom.Update;
import org.eclipse.webdav.internal.kernel.ClientException;
import org.eclipse.webdav.internal.kernel.DAVException;
import org.eclipse.webdav.internal.kernel.LockToken;
import org.eclipse.webdav.internal.kernel.RedirectionException;
import org.eclipse.webdav.internal.kernel.ServerException;
import org.eclipse.webdav.internal.kernel.SystemException;
import org.eclipse.webdav.internal.kernel.WebDAVException;
import org.eclipse.webdav.internal.kernel.WebDAVPropertyNames;
import org.eclipse.webdav.internal.kernel.WebDAVPropertyValues;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.eclipse.webdav.internal.kernel.utils.EmptyEnumeration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractResourceHandle
implements WebDAVPropertyNames,
WebDAVPropertyValues {
    protected DAVClient davClient;
    protected ILocator locator;

    public AbstractResourceHandle(DAVClient davClient, ILocator locator) {
        Assert.isNotNull(davClient);
        Assert.isNotNull(locator);
        this.davClient = davClient;
        this.locator = locator;
    }

    public CollectionHandle asCollectionHandle() {
        return new CollectionHandle(this.davClient, this.locator);
    }

    public ResourceHandle asResourceHandle() {
        return new ResourceHandle(this.davClient, this.locator);
    }

    public boolean canTalkDAV() throws DAVException {
        boolean bl;
        IResponse response = null;
        try {
            response = this.davClient.options(this.locator, this.newContext());
            this.examineResponse(response);
            String davHeader = response.getContext().getDAV();
            bl = davHeader != null && davHeader.indexOf("1") != -1;
            Object var3_5 = null;
        }
        catch (IOException exception) {
            try {
                throw new SystemException(exception);
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.closeResponse(response);
                throw throwable;
            }
        }
        this.closeResponse(response);
        return bl;
    }

    public ResourceHandle checkIn() throws DAVException {
        ILocator versionLocator = this.protectedCheckIn();
        return new ResourceHandle(this.davClient, versionLocator);
    }

    public abstract AbstractResourceHandle checkOut() throws DAVException;

    protected void closeResponse(IResponse response) throws SystemException {
        if (response == null) {
            return;
        }
        try {
            response.close();
        }
        catch (IOException e) {
            throw new SystemException(e);
        }
    }

    public void copy(ILocator destination) throws DAVException {
        this.copy(destination, "infinity", false, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(ILocator destination, String depth, boolean overwrite, Collection propertyNames) throws DAVException {
        Object var10_11;
        IContext context = this.newContext();
        context.setDepth(depth);
        context.setOverwrite(overwrite);
        Document document = this.newDocument();
        PropertyBehavior propertyBehavior = PropertyBehavior.create(document);
        if (propertyNames == null) {
            propertyBehavior.setIsKeepAllAlive(true);
        } else {
            Iterator namesItr = propertyNames.iterator();
            while (namesItr.hasNext()) {
                QualifiedName name = (QualifiedName)namesItr.next();
                String nameURI = String.valueOf(name.getQualifier()) + "/" + name.getLocalName();
                propertyBehavior.addProperty(nameURI);
            }
        }
        IResponse response = null;
        try {
            try {
                response = this.davClient.copy(this.locator, destination, context, document);
                this.examineResponse(response);
                this.examineMultiStatusResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            var10_11 = null;
            this.closeResponse(response);
            throw throwable;
        }
        {
            var10_11 = null;
        }
        this.closeResponse(response);
    }

    public abstract void create() throws DAVException;

    public void delete() throws DAVException {
        this.delete(false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractResourceHandle)) {
            return false;
        }
        AbstractResourceHandle otherHandle = (AbstractResourceHandle)obj;
        return this.locator.equals(otherHandle.locator);
    }

    public int hashCode() {
        return this.locator.hashCode();
    }

    protected void examineMultiStatusResponse(IResponse response) throws DAVException {
        Element documentElement;
        if (response.getStatusCode() != 207) {
            return;
        }
        if (!response.hasDocumentBody()) {
            throw new DAVException(Policy.bind("exception.responseMustHaveDocBody"));
        }
        try {
            documentElement = response.getDocumentBody().getDocumentElement();
            if (documentElement == null) {
                throw new DAVException(Policy.bind("exception.invalidDoc"));
            }
        }
        catch (IOException exception) {
            throw new SystemException(exception);
        }
        try {
            MultiStatus multistatus = new MultiStatus(documentElement);
            Enumeration responseEnum = multistatus.getResponses();
            while (responseEnum.hasMoreElements()) {
                ResponseBody responseBody = (ResponseBody)responseEnum.nextElement();
                Enumeration propstatEnum = responseBody.getPropStats();
                while (propstatEnum.hasMoreElements()) {
                    PropStat propstat = (PropStat)propstatEnum.nextElement();
                    this.examineStatusCode(propstat.getStatusCode(), propstat.getResponseDescription());
                }
            }
        }
        catch (MalformedElementException e) {
            throw new SystemException(e);
        }
    }

    protected void examineResponse(IResponse response) throws WebDAVException {
        this.examineStatusCode(response.getStatusCode(), response.getStatusMessage());
    }

    protected URLTable extractPropStats(MultiStatus multiStatus) throws IOException, MalformedElementException {
        URLTable reply = new URLTable();
        Enumeration responses = multiStatus.getResponses();
        while (responses.hasMoreElements()) {
            ResponseBody responseBody = (ResponseBody)responses.nextElement();
            String href = responseBody.getHref();
            URL resourceURL = new URL(new URL(this.locator.getResourceURL()), href);
            Hashtable<QualifiedName, PropertyStatus> properties = new Hashtable<QualifiedName, PropertyStatus>();
            reply.put(resourceURL, properties);
            Enumeration propstats = responseBody.getPropStats();
            while (propstats.hasMoreElements()) {
                PropStat propstat = (PropStat)propstats.nextElement();
                Status status = new Status(propstat.getStatus());
                Enumeration elements = propstat.getProp().getProperties();
                while (elements.hasMoreElements()) {
                    Element element = (Element)elements.nextElement();
                    QualifiedName name = ElementEditor.getQualifiedName(element);
                    PropertyStatus propertyStatus = new PropertyStatus(element, status.getStatusCode(), status.getStatusMessage());
                    properties.put(name, propertyStatus);
                }
            }
        }
        return reply;
    }

    public ResponseInputStream getContent() throws DAVException {
        IResponse response = null;
        try {
            response = this.davClient.get(this.locator, this.newContext());
            this.examineResponse(response);
        }
        catch (IOException e) {
            this.closeResponse(response);
            throw new SystemException(e);
        }
        return new ResponseInputStream(response);
    }

    public DAVClient getDAVClient() {
        return this.davClient;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public Enumeration getLocks() throws DAVException {
        LockDiscovery lockdiscovery = null;
        try {
            Element element = this.getProperty(WebDAVPropertyNames.DAV_LOCK_DISCOVERY).getProperty();
            lockdiscovery = new LockDiscovery(element);
            return lockdiscovery.getActiveLocks();
        }
        catch (WebDAVException exception) {
            if (exception.getStatusCode() == 404) {
                return new EmptyEnumeration();
            }
            throw exception;
        }
        catch (MalformedElementException elemException) {
            throw new SystemException(elemException);
        }
    }

    public CollectionHandle getParent() throws DAVException {
        URL url;
        block3: {
            Assert.isTrue(this.locator.getLabel() == null);
            Assert.isTrue(!this.locator.isStable());
            try {
                url = URLTool.getParent(this.locator.getResourceURL());
                if (url != null) break block3;
                return null;
            }
            catch (MalformedURLException e) {
                throw new SystemException(e);
            }
        }
        String parentName = url.toString();
        ILocator parentLocator = this.davClient.getDAVFactory().newLocator(parentName);
        return new CollectionHandle(this.davClient, parentLocator);
    }

    public URLTable getProperties(String depth) throws DAVException {
        return this.getProperties(null, depth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLTable getProperties(Collection propertyNames, String depth) throws DAVException {
        URLTable uRLTable;
        IContext context = this.newContext();
        context.setDepth(depth);
        Document document = this.newDocument();
        PropFind propfind = PropFind.create(document);
        if (propertyNames == null) {
            propfind.setIsAllProp(true);
        } else {
            Prop prop = propfind.setProp();
            Iterator namesItr = propertyNames.iterator();
            while (namesItr.hasNext()) {
                prop.addPropertyName((QualifiedName)namesItr.next());
            }
        }
        IResponse response = null;
        try {
            try {
                response = this.davClient.propfind(this.locator, context, document);
                this.examineResponse(response);
                if (!response.hasDocumentBody()) {
                    throw new DAVException(Policy.bind("exception.respMustShareXMLDoc"));
                }
                Element documentElement = response.getDocumentBody().getDocumentElement();
                if (documentElement == null) {
                    throw new DAVException(Policy.bind("exception.respHasInvalidDoc"));
                }
                MultiStatus multiStatus = new MultiStatus(documentElement);
                uRLTable = this.extractPropStats(multiStatus);
                Object var9_12 = null;
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
            catch (MalformedElementException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.closeResponse(response);
            throw throwable;
        }
        this.closeResponse(response);
        return uRLTable;
    }

    public PropertyStatus getProperty(QualifiedName propertyName) throws DAVException {
        HashSet<QualifiedName> names = new HashSet<QualifiedName>();
        names.add(propertyName);
        URLTable result = this.getProperties(names, "0");
        URL url = null;
        try {
            url = new URL(this.locator.getResourceURL());
        }
        catch (MalformedURLException e) {
            throw new SystemException(e);
        }
        Hashtable propTable = (Hashtable)result.get(url);
        if (propTable == null) {
            throw new DAVException(Policy.bind("exception.lookup", url.toExternalForm()));
        }
        return (PropertyStatus)propTable.get(propertyName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLTable getPropertyNames(String depth) throws DAVException {
        IContext context = this.newContext();
        context.setDepth(depth);
        IResponse response = null;
        try {
            try {
                Document document = this.newDocument();
                PropFind propfind = PropFind.create(document);
                propfind.setIsPropName(true);
                response = this.davClient.propfind(this.locator, context, document);
                this.examineResponse(response);
                if (!response.hasDocumentBody()) {
                    throw new DAVException(Policy.bind("exception.respMustHaveElmtBody"));
                }
                Element documentElement = response.getDocumentBody().getDocumentElement();
                if (documentElement == null) {
                    throw new DAVException(Policy.bind("exception.bodyMustHaveElmt"));
                }
                MultiStatus multistatus = new MultiStatus(documentElement);
                URLTable reply = new URLTable(10);
                Enumeration responses = multistatus.getResponses();
                while (responses.hasMoreElements()) {
                    ResponseBody responseBody = (ResponseBody)responses.nextElement();
                    String href = responseBody.getHref();
                    URL resourceUrl = new URL(new URL(this.locator.getResourceURL()), href);
                    Enumeration propstats = responseBody.getPropStats();
                    Vector<QualifiedName> vector = new Vector<QualifiedName>();
                    while (propstats.hasMoreElements()) {
                        PropStat propstat = (PropStat)propstats.nextElement();
                        Prop prop = propstat.getProp();
                        Enumeration names = prop.getPropertyNames();
                        while (names.hasMoreElements()) {
                            QualifiedName dname = (QualifiedName)names.nextElement();
                            vector.addElement(dname);
                        }
                    }
                    reply.put(resourceUrl, vector.elements());
                }
                URLTable uRLTable = reply;
                Object var19_22 = null;
                this.closeResponse(response);
                return uRLTable;
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
            catch (MalformedElementException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            this.closeResponse(response);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLTable getVersionTree() throws DAVException {
        Document document = this.newDocument();
        Element root = ElementEditor.create(document, "version-tree");
        Element propElement = ElementEditor.appendChild(root, "prop");
        ElementEditor.appendChild(propElement, "predecessor-set");
        IResponse response = null;
        try {
            try {
                response = this.davClient.report(this.locator, this.newContext(), document);
                this.examineResponse(response);
                if (!response.hasDocumentBody()) {
                    throw new DAVException(Policy.bind("exception.respMustHaveElmtBody"));
                }
                Element documentElement = response.getDocumentBody().getDocumentElement();
                if (documentElement == null) {
                    throw new DAVException(Policy.bind("exception.bodyMustHaveElmt"));
                }
                MultiStatus multistatus = new MultiStatus(documentElement);
                URLTable predecessorTable = new URLTable();
                Enumeration responses = multistatus.getResponses();
                while (responses.hasMoreElements()) {
                    ResponseBody responseBody = (ResponseBody)responses.nextElement();
                    String href = responseBody.getHref();
                    URL resourceURL = new URL(new URL(this.locator.getResourceURL()), href);
                    Vector<URL> predecessors = new Vector<URL>();
                    predecessorTable.put(resourceURL, predecessors);
                    Enumeration propstats = responseBody.getPropStats();
                    while (propstats.hasMoreElements()) {
                        PropStat propstat = (PropStat)propstats.nextElement();
                        if (propstat.getStatusCode() != 200) {
                            throw new DAVException(Policy.bind("exception.errorRetrievingProp"));
                        }
                        Prop prop = propstat.getProp();
                        Enumeration elements = prop.getProperties();
                        while (elements.hasMoreElements()) {
                            Element element = (Element)elements.nextElement();
                            QualifiedName name = ElementEditor.getQualifiedName(element);
                            if (!name.equals(WebDAVPropertyNames.DAV_PREDECESSOR_SET)) continue;
                            Enumeration e = new HrefSet(element, WebDAVPropertyNames.DAV_PREDECESSOR_SET).getHrefs();
                            while (e.hasMoreElements()) {
                                URL predURL = new URL((String)e.nextElement());
                                predecessors.add(predURL);
                            }
                        }
                    }
                }
                URLTable uRLTable = predecessorTable;
                Object var21_24 = null;
                this.closeResponse(response);
                return uRLTable;
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
            catch (MalformedElementException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            this.closeResponse(response);
            throw throwable;
        }
    }

    public CollectionHandle[] getWorkspaceCollections() throws DAVException {
        PropertyStatus propertyStatus = this.getProperty(WebDAVPropertyNames.DAV_WORKSPACE_COLLECTION_SET);
        Vector<CollectionHandle> v = new Vector<CollectionHandle>(5);
        Element element = propertyStatus.getProperty();
        if (!ElementEditor.isDAVElement(element, "workspace-collection-set")) {
            throw new DAVException(Policy.bind("exception.malformedElement"));
        }
        Element child = ElementEditor.getFirstChild(element, "href");
        while (child != null) {
            String href = ElementEditor.getFirstText(child);
            ILocator locator = this.davClient.getDAVFactory().newLocator(href);
            v.addElement(new CollectionHandle(this.davClient, locator));
            child = ElementEditor.getNextSibling(child);
        }
        Object[] result = new CollectionHandle[v.size()];
        v.copyInto(result);
        return result;
    }

    public IContext head() throws DAVException {
        IContext iContext;
        IResponse response = null;
        try {
            response = this.davClient.head(this.locator, this.newContext());
            this.examineResponse(response);
            iContext = response.getContext();
            Object var3_3 = null;
        }
        catch (IOException exception) {
            try {
                throw new SystemException(exception);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.closeResponse(response);
                throw throwable;
            }
        }
        this.closeResponse(response);
        return iContext;
    }

    public boolean isCollection() throws DAVException {
        return this.propertyHasChild(WebDAVPropertyNames.DAV_RESOURCE_TYPE, WebDAVPropertyValues.DAV_COLLECTION_RESOURCE_TYPE);
    }

    public boolean isLocked() throws DAVException {
        return this.getLocks().hasMoreElements();
    }

    public LockToken lock() throws DAVException {
        return this.lock(false, "0", -1, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LockToken lock(boolean isShared, String depth, int timeout, String owner) throws DAVException {
        IContext context = this.newContext();
        context.setDepth(depth);
        context.setTimeout(timeout);
        Document document = this.newDocument();
        LockInfo lockinfo = LockInfo.create(document);
        lockinfo.setIsShared(isShared);
        if (owner != null) {
            Owner ownerEditor = lockinfo.setOwner();
            ownerEditor.getElement().appendChild(document.createTextNode(owner));
        }
        IResponse response = null;
        try {
            try {
                response = this.davClient.lock(this.locator, context, document);
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.closeResponse(response);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        this.closeResponse(response);
        return new LockToken(response.getContext().getLockToken());
    }

    public void move(ILocator destination) throws DAVException {
        this.move(destination, false, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(ILocator destination, boolean overwrite, Enumeration names) throws DAVException {
        IContext context = this.newContext();
        context.setOverwrite(overwrite);
        Document document = this.newDocument();
        PropertyBehavior propertyBehavior = PropertyBehavior.create(document);
        if (names == null) {
            propertyBehavior.setIsKeepAllAlive(true);
        } else {
            while (names.hasMoreElements()) {
                Object obj = names.nextElement();
                Assert.isTrue(obj instanceof QualifiedName, Policy.bind("assert.propNameMustBeEnumOverQual"));
                propertyBehavior.addProperty(((QualifiedName)obj).getLocalName());
            }
        }
        IResponse response = null;
        try {
            try {
                response = this.davClient.move(this.locator, destination, context, document);
                this.examineResponse(response);
                this.examineMultiStatusResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeResponse(response);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        this.closeResponse(response);
    }

    protected IContext newContext() {
        return this.davClient.getDAVFactory().newContext();
    }

    protected Document newDocument() {
        return this.davClient.getDAVFactory().newDocument();
    }

    protected ILocator protectedCheckIn() throws DAVException {
        ILocator iLocator;
        IResponse response = null;
        try {
            response = this.davClient.checkin(this.locator, this.newContext(), null);
            this.examineResponse(response);
            String versionUrl = response.getContext().getLocation();
            iLocator = this.davClient.getDAVFactory().newStableLocator(versionUrl);
            Object var3_5 = null;
        }
        catch (IOException e) {
            try {
                throw new SystemException(e);
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.closeResponse(response);
                throw throwable;
            }
        }
        this.closeResponse(response);
        return iLocator;
    }

    protected ILocator protectedCheckOut() throws DAVException {
        ILocator iLocator;
        IResponse response = null;
        try {
            response = this.davClient.checkout(this.locator, this.newContext(), null);
            this.examineResponse(response);
            String resourceUrl = response.getContext().getLocation();
            iLocator = this.davClient.getDAVFactory().newStableLocator(resourceUrl);
            Object var3_5 = null;
        }
        catch (IOException e) {
            try {
                throw new SystemException(e);
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.closeResponse(response);
                throw throwable;
            }
        }
        this.closeResponse(response);
        return iLocator;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshLock(LockToken lockToken, int timeout) throws DAVException {
        IContext context = this.newContext();
        context.setTimeout(timeout);
        context.setLockToken(lockToken.getToken());
        IResponse response = null;
        try {
            try {
                response = this.davClient.lock(this.locator, context, null);
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeResponse(response);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.closeResponse(response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeProperties(Collection propertyNames) throws DAVException {
        Assert.isNotNull(propertyNames);
        if (propertyNames.isEmpty()) {
            return;
        }
        Document document = this.newDocument();
        PropertyUpdate propertyUpdate = PropertyUpdate.create(document);
        Prop prop = propertyUpdate.addRemove();
        Iterator namesItr = propertyNames.iterator();
        while (namesItr.hasNext()) {
            prop.addPropertyName((QualifiedName)namesItr.next());
        }
        IResponse response = null;
        try {
            try {
                response = this.davClient.proppatch(this.locator, this.newContext(), document);
                this.examineResponse(response);
                this.examineMultiStatusResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.closeResponse(response);
            throw throwable;
        }
        this.closeResponse(response);
    }

    public void removeProperty(QualifiedName propertyName) throws DAVException {
        Vector<QualifiedName> propertyNames = new Vector<QualifiedName>(1);
        propertyNames.add(propertyName);
        this.removeProperties(propertyNames);
    }

    public void setContent(InputStream input) throws DAVException {
        this.setContent("application/octet-stream", input);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setContent(String contentType, InputStream input) throws DAVException {
        IResponse response = null;
        try {
            try {
                IContext context = this.newContext();
                context.setContentType(contentType);
                response = this.davClient.put(this.locator, context, input);
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeResponse(response);
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.closeResponse(response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setProperties(Collection properties) throws DAVException {
        Assert.isNotNull(properties);
        if (properties.isEmpty()) {
            return;
        }
        Document document = this.newDocument();
        PropertyUpdate propertyUpdate = PropertyUpdate.create(document);
        Prop prop = propertyUpdate.addSet();
        Iterator propertiesItr = properties.iterator();
        while (propertiesItr.hasNext()) {
            Element element = (Element)propertiesItr.next();
            try {
                prop.addProperty(element);
            }
            catch (MalformedElementException exception) {
                throw new SystemException(exception);
            }
        }
        IResponse response = null;
        try {
            try {
                response = this.davClient.proppatch(this.locator, this.newContext(), document);
                this.examineResponse(response);
                this.examineMultiStatusResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeResponse(response);
            throw throwable;
        }
        this.closeResponse(response);
    }

    public void setProperty(Element property) throws DAVException {
        Vector<Element> properties = new Vector<Element>(1);
        properties.add(property);
        this.setProperties(properties);
    }

    public String toString() {
        return this.locator.getResourceURL();
    }

    public ResponseInputStream trace() throws DAVException {
        IResponse response = null;
        try {
            response = this.davClient.trace(this.locator, this.newContext());
            this.examineResponse(response);
        }
        catch (IOException e) {
            throw new SystemException(e);
        }
        catch (DAVException e) {
            this.closeResponse(response);
            throw e;
        }
        return new ResponseInputStream(response);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unlock(LockToken token) throws DAVException {
        IContext context = this.newContext();
        context.setLockToken("<" + token.getToken() + ">");
        IResponse response = null;
        try {
            try {
                response = this.davClient.unlock(this.locator, context);
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeResponse(response);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.closeResponse(response);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(ILocator version) throws DAVException {
        Document document = this.newDocument();
        Update.createVersion(document, version.getResourceURL());
        IResponse response = null;
        try {
            try {
                response = this.davClient.update(this.locator, this.newContext(), document);
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeResponse(response);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.closeResponse(response);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void versionControl() throws DAVException {
        IResponse response = null;
        try {
            try {
                response = this.davClient.versionControl(this.locator, this.newContext(), null);
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeResponse(response);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.closeResponse(response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(boolean mustExist) throws DAVException {
        IResponse response;
        block7: {
            block6: {
                response = null;
                try {
                    try {
                        response = this.davClient.delete(this.locator, this.newContext());
                        if (!mustExist && response.getStatusCode() == 404) {
                            Object var4_3 = null;
                            break block6;
                        }
                        this.examineResponse(response);
                        this.examineMultiStatusResponse(response);
                        break block7;
                    }
                    catch (IOException exception) {
                        throw new SystemException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.closeResponse(response);
                    throw throwable;
                }
            }
            this.closeResponse(response);
            return;
        }
        Object var4_5 = null;
        this.closeResponse(response);
    }

    protected void examineStatusCode(int code, String message) throws WebDAVException {
        if (code >= 300 && code <= 399) {
            throw new RedirectionException(code, message);
        }
        if (code >= 400 && code <= 499) {
            throw new ClientException(code, message);
        }
        if (code >= 500 && code <= 599) {
            throw new ServerException(code, message);
        }
    }

    public boolean exists() throws DAVException {
        IResponse response;
        block5: {
            response = null;
            response = this.davClient.head(this.locator, this.newContext());
            if (response.getStatusCode() != 404) break block5;
            Object var3_2 = null;
            this.closeResponse(response);
            return false;
        }
        try {
            this.examineResponse(response);
            Object var3_3 = null;
        }
        catch (IOException exception) {
            try {
                throw new SystemException(exception);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.closeResponse(response);
                throw throwable;
            }
        }
        this.closeResponse(response);
        return true;
    }

    public boolean isCheckedIn() throws DAVException {
        return this.supportsLiveProperty(WebDAVPropertyNames.DAV_CHECKED_IN);
    }

    public boolean isCheckedOut() throws DAVException {
        return this.supportsLiveProperty(WebDAVPropertyNames.DAV_CHECKED_OUT);
    }

    public boolean isVersion() throws DAVException {
        return this.supportsLiveProperty(WebDAVPropertyNames.DAV_VERSION_NAME);
    }

    public boolean isVersionControlled() throws DAVException {
        return this.supportsLiveProperty(WebDAVPropertyNames.DAV_AUTO_CHECKOUT);
    }

    public boolean isWorkingResource() throws DAVException {
        PropertyStatus propertyStat = this.getProperty(WebDAVPropertyNames.DAV_SUPPORTED_LIVE_PROPERTY_SET);
        if (propertyStat.getStatusCode() == 404) {
            return false;
        }
        this.examineStatusCode(propertyStat.getStatusCode(), propertyStat.getStatusMessage());
        try {
            Element propertySet = propertyStat.getProperty();
            return ElementEditor.hasChild(propertySet, WebDAVPropertyNames.DAV_CHECKED_OUT) && !ElementEditor.hasChild(propertySet, WebDAVPropertyNames.DAV_AUTO_CHECKOUT);
        }
        catch (MalformedElementException exception) {
            throw new SystemException(exception);
        }
    }

    protected boolean propertyHasChild(QualifiedName propertyName, QualifiedName childName) throws DAVException {
        PropertyStatus propertyStat = this.getProperty(propertyName);
        if (propertyStat.getStatusCode() == 404) {
            return false;
        }
        this.examineStatusCode(propertyStat.getStatusCode(), propertyStat.getStatusMessage());
        try {
            return ElementEditor.hasChild(propertyStat.getProperty(), childName);
        }
        catch (MalformedElementException exception) {
            throw new SystemException(exception);
        }
    }

    public boolean supportsLiveProperty(QualifiedName propertyName) throws DAVException {
        return this.propertyHasChild(WebDAVPropertyNames.DAV_SUPPORTED_LIVE_PROPERTY_SET, propertyName);
    }
}

