/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Owner;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ActiveLock
extends ElementEditor {
    protected static final String[] childNames = new String[]{"lockscope", "locktype", "depth", "owner", "timeout", "locktoken"};

    public ActiveLock(Element root) throws MalformedElementException {
        super(root, "activelock");
    }

    public void addLockTokenHref(String href) {
        Assert.isNotNull(href);
        Element locktoken = ElementEditor.getLastChild(this.root, "locktoken");
        if (locktoken == null) {
            locktoken = ElementEditor.setChild(this.root, "locktoken", childNames, false);
        }
        ElementEditor.appendChild(locktoken, "href", ElementEditor.encodeHref(href));
    }

    public String getDepth() throws MalformedElementException {
        String depth = ElementEditor.getChildText(this.root, "depth", false);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingDepthElmt"), depth);
        ElementEditor.ensure(depth.equals("0") || depth.equals("1") || depth.equals("infinity"), Policy.bind("ensure.invalidDepth", depth));
        return depth;
    }

    public Enumeration getLockTokenHrefs() throws MalformedElementException {
        Element locktoken = ElementEditor.getLastChild(this.root, "locktoken");
        Element firstHref = null;
        if (locktoken != null) {
            firstHref = ElementEditor.getFirstChild(locktoken, "href");
            ElementEditor.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), firstHref);
        }
        Element node = firstHref;
        Enumeration e = new Enumeration(node){
            Node currentHref;
            {
                this.currentHref = node;
            }

            public boolean hasMoreElements() {
                return this.currentHref != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String href = ElementEditor.getFirstText((Element)this.currentHref);
                this.currentHref = ElementEditor.getTwin((Element)this.currentHref, true);
                return ElementEditor.decodeHref(href);
            }
        };
        return e;
    }

    public Owner getOwner() throws MalformedElementException {
        Element owner = ElementEditor.getLastChild(this.root, "owner");
        if (owner == null) {
            return null;
        }
        return new Owner(owner);
    }

    public String getTimeout() throws MalformedElementException {
        return ElementEditor.getChildText(this.root, "timeout", false);
    }

    public boolean isShared() throws MalformedElementException {
        Element lockscope = ElementEditor.getFirstChild(this.root, "lockscope");
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingLockscopeElmt "), lockscope);
        String[] names = new String[]{"shared", "exclusive"};
        Element sharedOrExclusive = ElementEditor.getFirstChild(lockscope, names);
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingSharedOrExclusiveElmt"), sharedOrExclusive);
        boolean isShared = ElementEditor.isDAVElement(sharedOrExclusive, "shared");
        ElementEditor.ensure(ElementEditor.getNextSibling(sharedOrExclusive, names) == null, Policy.bind("ensure.conflictingSharedOrExclusiveElmt"));
        return isShared;
    }

    public void setDepth(String depth) {
        Assert.isNotNull(depth);
        Assert.isTrue(depth.equals("0") || depth.equals("1") || depth.equals("infinity"));
        ElementEditor.setChild(this.root, "depth", depth, childNames, false);
    }

    public void setIsShared(boolean isShared) {
        Element lockscope = ElementEditor.setChild(this.root, "lockscope", childNames, true);
        if (isShared) {
            ElementEditor.appendChild(lockscope, "shared");
        } else {
            ElementEditor.appendChild(lockscope, "exclusive");
        }
    }

    public Owner setOwner() {
        Element owner = ElementEditor.setChild(this.root, "owner", childNames, false);
        Owner result = null;
        try {
            result = new Owner(owner);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }

    public void setTimeout(String timeout) {
        if (timeout == null) {
            Element child = ElementEditor.getLastChild(this.root, "timeout");
            if (child != null) {
                this.root.removeChild(child);
            }
        } else {
            ElementEditor.setChild(this.root, "timeout", timeout, childNames, false);
        }
    }
}

