/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.common.WorkingMemoryAction;
import org.drools.core.util.KeyStoreHelper;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.ProcessMarshaller;
import org.drools.marshalling.impl.ProtobufInputMarshaller;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.PropagationQueuingNode;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.SlidingTimeWindow;

public class PersisterHelper {
    public static WorkingMemoryAction readWorkingMemoryAction(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        short type = context.readShort();
        switch (type) {
            case 1: {
                return new ReteooWorkingMemory.WorkingMemoryReteAssertAction(context);
            }
            case 2: {
                return new RuleFlowGroupImpl.DeactivateCallback(context);
            }
            case 3: {
                return new PropagationQueuingNode.PropagateAction(context);
            }
            case 4: {
                return new TruthMaintenanceSystem.LogicalRetractCallback(context);
            }
            case 5: {
                return new ReteooWorkingMemory.WorkingMemoryReteExpireAction(context);
            }
            case 8: {
                return new SlidingTimeWindow.BehaviorExpireWMAction(context);
            }
        }
        return null;
    }

    public static WorkingMemoryAction deserializeWorkingMemoryAction(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) throws IOException, ClassNotFoundException {
        switch (_action.getType()) {
            case ASSERT: {
                return new ReteooWorkingMemory.WorkingMemoryReteAssertAction(context, _action);
            }
            case DEACTIVATE_CALLBACK: {
                return new RuleFlowGroupImpl.DeactivateCallback(context, _action);
            }
            case PROPAGATE: {
                return new PropagationQueuingNode.PropagateAction(context, _action);
            }
            case LOGICAL_RETRACT: {
                return new TruthMaintenanceSystem.LogicalRetractCallback(context, _action);
            }
            case EXPIRE: {
                return new ReteooWorkingMemory.WorkingMemoryReteExpireAction(context, _action);
            }
            case BEHAVIOR_EXPIRE: {
                return new SlidingTimeWindow.BehaviorExpireWMAction(context, _action);
            }
        }
        return null;
    }

    public void write(MarshallerWriteContext context) throws IOException {
    }

    public static ProtobufInputMarshaller.ActivationKey createActivationKey(String pkgName, String ruleName, ProtobufMessages.Tuple _tuple) {
        int[] tuple = PersisterHelper.createTupleArray(_tuple);
        return new ProtobufInputMarshaller.ActivationKey(pkgName, ruleName, tuple);
    }

    public static ProtobufInputMarshaller.ActivationKey createActivationKey(String pkgName, String ruleName, LeftTuple leftTuple) {
        int[] tuple = PersisterHelper.createTupleArray(leftTuple);
        return new ProtobufInputMarshaller.ActivationKey(pkgName, ruleName, tuple);
    }

    public static ProtobufMessages.Tuple createTuple(LeftTuple leftTuple) {
        ProtobufMessages.Tuple.Builder _tuple = ProtobufMessages.Tuple.newBuilder();
        for (LeftTuple entry = leftTuple; entry != null; entry = entry.getParent()) {
            _tuple.addHandleId(entry.getLastHandle().getId());
        }
        return _tuple.build();
    }

    public static int[] createTupleArray(ProtobufMessages.Tuple _tuple) {
        int[] tuple = new int[_tuple.getHandleIdCount()];
        for (int i = 0; i < tuple.length; ++i) {
            tuple[i] = _tuple.getHandleId(tuple.length - i - 1);
        }
        return tuple;
    }

    public static int[] createTupleArray(LeftTuple leftTuple) {
        int[] tuple = new int[leftTuple.size()];
        int i = tuple.length;
        for (LeftTuple entry = leftTuple; entry != null && i > 0; entry = entry.getParent()) {
            tuple[--i] = entry.getLastHandle().getId();
        }
        return tuple;
    }

    public static ProtobufInputMarshaller.TupleKey createTupleKey(ProtobufMessages.Tuple _tuple) {
        return new ProtobufInputMarshaller.TupleKey(PersisterHelper.createTupleArray(_tuple));
    }

    public static ProtobufInputMarshaller.TupleKey createTupleKey(LeftTuple leftTuple) {
        return new ProtobufInputMarshaller.TupleKey(PersisterHelper.createTupleArray(leftTuple));
    }

    public static ProtobufMessages.Activation createActivation(String packageName, String ruleName, LeftTuple tuple) {
        return ProtobufMessages.Activation.newBuilder().setPackageName(packageName).setRuleName(ruleName).setTuple(PersisterHelper.createTuple(tuple)).build();
    }

    public static void writeToStreamWithHeader(MarshallerWriteContext context, Message payload) throws IOException {
        ProtobufMessages.Header.Builder _header = ProtobufMessages.Header.newBuilder();
        _header.setVersion(ProtobufMessages.Version.newBuilder().setVersionMajor(5).setVersionMinor(4).setVersionRevision(0).build());
        PersisterHelper.writeStrategiesIndex(context, _header);
        byte[] buff = payload.toByteArray();
        PersisterHelper.sign(_header, buff);
        _header.setPayload(ByteString.copyFrom((byte[])buff));
        context.stream.write(_header.build().toByteArray());
    }

    private static void writeStrategiesIndex(MarshallerWriteContext context, ProtobufMessages.Header.Builder _header) throws IOException {
        for (Map.Entry<ObjectMarshallingStrategy, Integer> entry : context.usedStrategies.entrySet()) {
            ProtobufMessages.Header.StrategyIndex.Builder _strat = ProtobufMessages.Header.StrategyIndex.newBuilder().setId(entry.getValue()).setName(entry.getKey().getClass().getName());
            ObjectMarshallingStrategy.Context ctx = context.strategyContext.get(entry.getKey());
            if (ctx != null) {
                ByteString.Output os = ByteString.newOutput();
                ctx.write((ObjectOutputStream)new DroolsObjectOutputStream((OutputStream)os));
                _strat.setData(os.toByteString());
                os.close();
            }
            _header.addStrategy(_strat.build());
        }
    }

    private static void sign(ProtobufMessages.Header.Builder _header, byte[] buff) {
        KeyStoreHelper helper = new KeyStoreHelper();
        if (helper.isSigned()) {
            try {
                _header.setSignature(ProtobufMessages.Signature.newBuilder().setKeyAlias(helper.getPvtKeyAlias()).setSignature(ByteString.copyFrom((byte[])helper.signDataWithPrivateKey(buff))).build());
            }
            catch (Exception e) {
                throw new RuntimeDroolsException("Error signing session: " + e.getMessage(), e);
            }
        }
    }

    public static ProtobufMessages.Header readFromStreamWithHeader(MarshallerReaderContext context, ExtensionRegistry registry) throws IOException, ClassNotFoundException {
        ProtobufMessages.Header _header = ProtobufMessages.Header.parseFrom(context.stream, (ExtensionRegistryLite)registry);
        PersisterHelper.loadStrategiesIndex(context, _header);
        byte[] sessionbuff = _header.getPayload().toByteArray();
        PersisterHelper.checkSignature(_header, sessionbuff);
        return _header;
    }

    private static void loadStrategiesIndex(MarshallerReaderContext context, ProtobufMessages.Header _header) throws IOException, ClassNotFoundException {
        for (ProtobufMessages.Header.StrategyIndex _entry : _header.getStrategyList()) {
            ObjectMarshallingStrategy strategyObject = context.resolverStrategyFactory.getStrategyObject(_entry.getName());
            if (strategyObject == null) {
                throw new IllegalStateException("No strategy of type " + _entry.getName() + " available.");
            }
            context.usedStrategies.put(_entry.getId(), strategyObject);
            ObjectMarshallingStrategy.Context ctx = strategyObject.createContext();
            context.strategyContexts.put(strategyObject, ctx);
            if (!_entry.hasData() || ctx == null) continue;
            ctx.read((ObjectInputStream)new DroolsObjectInputStream(_entry.getData().newInput(), (ClassLoader)context.ruleBase.getRootClassLoader()));
        }
    }

    private static void checkSignature(ProtobufMessages.Header _header, byte[] sessionbuff) {
        KeyStoreHelper helper = new KeyStoreHelper();
        boolean signed = _header.hasSignature();
        if (helper.isSigned() != signed) {
            throw new RuntimeDroolsException("This environment is configured to work with " + (helper.isSigned() ? "signed" : "unsigned") + " serialized objects, but the given object is " + (signed ? "signed" : "unsigned") + ". Deserialization aborted.");
        }
        if (signed) {
            if (helper.getPubKeyStore() == null) {
                throw new RuntimeDroolsException("The session was serialized with a signature. Please configure a public keystore with the public key to check the signature. Deserialization aborted.");
            }
            try {
                if (!helper.checkDataWithPublicKey(_header.getSignature().getKeyAlias(), sessionbuff, _header.getSignature().getSignature().toByteArray())) {
                    throw new RuntimeDroolsException("Signature does not match serialized package. This is a security violation. Deserialisation aborted.");
                }
            }
            catch (InvalidKeyException e) {
                throw new RuntimeDroolsException("Invalid key checking signature: " + e.getMessage(), e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeDroolsException("Error accessing Key Store: " + e.getMessage(), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeDroolsException("No algorithm available: " + e.getMessage(), e);
            }
            catch (SignatureException e) {
                throw new RuntimeDroolsException("Signature Exception: " + e.getMessage(), e);
            }
        }
    }

    public static ExtensionRegistry buildRegistry(MarshallerReaderContext context, ProcessMarshaller processMarshaller) {
        ExtensionRegistry registry = ExtensionRegistry.newInstance();
        if (processMarshaller != null) {
            context.parameterObject = registry;
            processMarshaller.init(context);
        }
        return registry;
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static final int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    public static final byte[] longToByteArray(long value) {
        return new byte[]{(byte)(value >>> 56 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value & 0xFFL)};
    }

    public static final long byteArrayToLong(byte[] b) {
        return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + ((long)b[7] & 0xFFL);
    }
}

