/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

public class PropInfo {
    private final Name name;
    private final int type;
    private final TextValue[] values;
    private MultipleStatus multipleStatus;

    public PropInfo(Name name, int type, TextValue[] values) {
        this.name = name;
        this.type = type;
        this.values = values;
        this.multipleStatus = values.length == 1 ? MultipleStatus.UNKNOWN : MultipleStatus.MULTIPLE;
    }

    public PropInfo(Name name, int type, TextValue[] values, MultipleStatus multipleStatus) {
        this.name = name;
        this.type = type;
        this.values = values;
        this.multipleStatus = multipleStatus;
    }

    public void dispose() {
        for (TextValue value : this.values) {
            value.dispose();
        }
    }

    public int getTargetType(QPropertyDefinition def) {
        int target = def.getRequiredType();
        if (target != 0) {
            return target;
        }
        if (this.type != 0) {
            return this.type;
        }
        return 1;
    }

    public QPropertyDefinition getApplicablePropertyDef(EffectiveNodeType ent) throws ConstraintViolationException {
        if (this.multipleStatus == MultipleStatus.MULTIPLE) {
            return ent.getApplicablePropertyDef(this.name, this.type, true);
        }
        if (this.multipleStatus == MultipleStatus.SINGLE) {
            return ent.getApplicablePropertyDef(this.name, this.type, false);
        }
        if (this.values.length == 1) {
            return ent.getApplicablePropertyDef(this.name, this.type);
        }
        return ent.getApplicablePropertyDef(this.name, this.type, true);
    }

    public Name getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public TextValue[] getTextValues() {
        return this.values;
    }

    public Value[] getValues(int targetType, NamePathResolver resolver) throws RepositoryException {
        Value[] va = new Value[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            va[i] = this.values[i].getValue(targetType, resolver);
        }
        return va;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MultipleStatus {
        UNKNOWN,
        SINGLE,
        MULTIPLE;

    }
}

