/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import org.drools.runtime.Environment;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAProcessInstanceDbLog {
    private static Logger logger = LoggerFactory.getLogger(JPAProcessInstanceDbLog.class);
    private static volatile Environment env;
    private static EntityManagerFactory emf;

    @Deprecated
    public JPAProcessInstanceDbLog() {
    }

    @Deprecated
    public JPAProcessInstanceDbLog(Environment env) {
        JPAProcessInstanceDbLog.env = env;
    }

    public static void setEnvironment(Environment newEnv) {
        env = newEnv;
    }

    public static List<ProcessInstanceLog> findProcessInstances() {
        EntityManager em = JPAProcessInstanceDbLog.getEntityManager();
        UserTransaction ut = JPAProcessInstanceDbLog.joinTransaction(em);
        List result = em.createQuery("FROM ProcessInstanceLog").getResultList();
        JPAProcessInstanceDbLog.closeEntityManager(em, ut);
        return result;
    }

    public static List<ProcessInstanceLog> findProcessInstances(String processId) {
        EntityManager em = JPAProcessInstanceDbLog.getEntityManager();
        UserTransaction ut = JPAProcessInstanceDbLog.joinTransaction(em);
        List result = em.createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId").setParameter("processId", (Object)processId).getResultList();
        JPAProcessInstanceDbLog.closeEntityManager(em, ut);
        return result;
    }

    public static List<ProcessInstanceLog> findActiveProcessInstances(String processId) {
        EntityManager em = JPAProcessInstanceDbLog.getEntityManager();
        UserTransaction ut = JPAProcessInstanceDbLog.joinTransaction(em);
        List result = JPAProcessInstanceDbLog.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId AND p.end is null").setParameter("processId", (Object)processId).getResultList();
        JPAProcessInstanceDbLog.closeEntityManager(em, ut);
        return result;
    }

    public static ProcessInstanceLog findProcessInstance(long processInstanceId) {
        EntityManager em = JPAProcessInstanceDbLog.getEntityManager();
        UserTransaction ut = JPAProcessInstanceDbLog.joinTransaction(em);
        ProcessInstanceLog result = (ProcessInstanceLog)JPAProcessInstanceDbLog.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.processInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId).getSingleResult();
        JPAProcessInstanceDbLog.closeEntityManager(em, ut);
        return result;
    }

    public static List<NodeInstanceLog> findNodeInstances(long processInstanceId) {
        EntityManager em = JPAProcessInstanceDbLog.getEntityManager();
        UserTransaction ut = JPAProcessInstanceDbLog.joinTransaction(em);
        List result = JPAProcessInstanceDbLog.getEntityManager().createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        JPAProcessInstanceDbLog.closeEntityManager(em, ut);
        return result;
    }

    public static List<NodeInstanceLog> findNodeInstances(long processInstanceId, String nodeId) {
        EntityManager em = JPAProcessInstanceDbLog.getEntityManager();
        UserTransaction ut = JPAProcessInstanceDbLog.joinTransaction(em);
        List result = JPAProcessInstanceDbLog.getEntityManager().createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId AND n.nodeId = :nodeId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).setParameter("nodeId", (Object)nodeId).getResultList();
        JPAProcessInstanceDbLog.closeEntityManager(em, ut);
        return result;
    }

    public static List<VariableInstanceLog> findVariableInstances(long processInstanceId) {
        EntityManager em = JPAProcessInstanceDbLog.getEntityManager();
        UserTransaction ut = JPAProcessInstanceDbLog.joinTransaction(em);
        List result = JPAProcessInstanceDbLog.getEntityManager().createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        JPAProcessInstanceDbLog.closeEntityManager(em, ut);
        return result;
    }

    public static List<VariableInstanceLog> findVariableInstances(long processInstanceId, String variableId) {
        EntityManager em = JPAProcessInstanceDbLog.getEntityManager();
        UserTransaction ut = JPAProcessInstanceDbLog.joinTransaction(em);
        List result = em.createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId AND v.variableId = :variableId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).setParameter("variableId", (Object)variableId).getResultList();
        JPAProcessInstanceDbLog.closeEntityManager(em, ut);
        return result;
    }

    public static void clear() {
        EntityManager em = JPAProcessInstanceDbLog.getEntityManager();
        UserTransaction ut = JPAProcessInstanceDbLog.joinTransaction(em);
        List processInstances = em.createQuery("FROM ProcessInstanceLog").getResultList();
        for (ProcessInstanceLog processInstance : processInstances) {
            em.remove((Object)processInstance);
        }
        List nodeInstances = em.createQuery("FROM NodeInstanceLog").getResultList();
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            em.remove((Object)nodeInstance);
        }
        List variableInstances = em.createQuery("FROM VariableInstanceLog").getResultList();
        for (VariableInstanceLog variableInstance : variableInstances) {
            em.remove((Object)variableInstance);
        }
        JPAProcessInstanceDbLog.closeEntityManager(em, ut);
    }

    @Deprecated
    public static void dispose() {
        if (emf != null) {
            emf.close();
        }
    }

    protected void finalize() throws Throwable {
        if (emf != null) {
            emf.close();
        }
    }

    private static UserTransaction joinTransaction(EntityManager em) {
        boolean newTx = false;
        UserTransaction ut = null;
        try {
            ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
            if (ut.getStatus() == 6) {
                ut.begin();
                newTx = true;
            }
        }
        catch (Exception e) {
            logger.error("Unable to find or open a transaction: " + e.getMessage());
            e.printStackTrace();
        }
        em.joinTransaction();
        if (newTx) {
            return ut;
        }
        return null;
    }

    private static void closeEntityManager(EntityManager em, UserTransaction ut) {
        em.flush();
        em.clear();
        em.close();
        try {
            if (ut != null) {
                ut.commit();
            }
        }
        catch (Exception e) {
            logger.error("Unable to commit transaction: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static EntityManager getEntityManager() {
        EntityManager em = null;
        if (env == null) {
            em = emf.createEntityManager();
        } else {
            EntityManagerFactory emf = (EntityManagerFactory)env.get("drools.persistence.jpa.EntityManagerFactory");
            em = emf.createEntityManager();
        }
        return em;
    }

    static {
        try {
            emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        }
        catch (Exception e) {
            logger.debug("Unable to instantiate emf for 'org.jbpm.persistence.jpa' persistence unit: " + e.getMessage());
        }
    }
}

