/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testframework;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.TypeResolver;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.testframework.DateObjectFactory;
import org.drools.testframework.FieldTypeResolver;
import org.drools.testframework.ResultVerifier;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactFieldValueVerifier {
    private final Map<String, Object> populatedData;
    private final String factName;
    private final Object factObject;
    private VerifyField currentField;
    final TypeResolver resolver;

    public FactFieldValueVerifier(Map<String, Object> populatedData, String factName, Object factObject, TypeResolver resolver) {
        this.populatedData = populatedData;
        this.factName = factName;
        this.factObject = factObject;
        this.resolver = resolver;
    }

    public void checkFields(List<VerifyField> fieldValues) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        for (VerifyField this.currentField : fieldValues) {
            if (this.currentField.getExpected() == null) continue;
            ResultVerifier resultVerifier = new ResultVerifier(this.factObject);
            resultVerifier.setExpected(this.getExpectedResult());
            this.currentField.setSuccessResult(resultVerifier.isSuccess(this.currentField));
            if (!this.currentField.getSuccessResult().booleanValue()) {
                this.currentField.setActualResult(resultVerifier.getActual(this.currentField));
                this.currentField.setExplanation(this.getFailingExplanation());
                continue;
            }
            this.currentField.setExplanation(this.getSuccesfulExplanation());
        }
    }

    private Object getExpectedResult() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        Object expectedResult = this.currentField.getExpected().trim();
        if (this.currentField.getExpected().startsWith("=")) {
            expectedResult = MVEL.eval((String)this.currentField.getExpected().substring(1), this.populatedData);
        } else if (this.currentField.getNature() == 4L) {
            try {
                String classNameOfEnum = this.currentField.getExpected().substring(0, this.currentField.getExpected().indexOf("."));
                String valueOfEnum = this.currentField.getExpected().substring(this.currentField.getExpected().indexOf(".") + 1);
                String fullName = this.resolver.getFullTypeName(classNameOfEnum);
                expectedResult = MVEL.eval((String)(fullName + "." + valueOfEnum));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else if (this.isFieldDate()) {
            return DateObjectFactory.getObject(FieldTypeResolver.getFieldType(this.currentField.getFieldName(), this.factObject), this.currentField.getExpected());
        }
        return expectedResult;
    }

    private boolean isFieldDate() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("__fact__", this.factObject);
        Object o = MVEL.eval((String)("__fact__." + this.currentField.getFieldName()), vars);
        return o instanceof Date;
    }

    private String getSuccesfulExplanation() {
        if (this.currentField.getOperator().equals("==")) {
            return "[" + this.factName + "] field [" + this.currentField.getFieldName() + "] was [" + this.currentField.getExpected() + "].";
        }
        if (this.currentField.getOperator().equals("!=")) {
            return "[" + this.factName + "] field [" + this.currentField.getFieldName() + "] was not [" + this.currentField.getExpected() + "].";
        }
        return "";
    }

    private String getFailingExplanation() {
        if (this.currentField.getOperator().equals("==")) {
            return "[" + this.factName + "] field [" + this.currentField.getFieldName() + "] was [" + this.currentField.getActualResult() + "] expected [" + this.currentField.getExpected() + "].";
        }
        return "[" + this.factName + "] field [" + this.currentField.getFieldName() + "] was not expected to be [" + this.currentField.getActualResult() + "].";
    }
}

