/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.ArrayList;
import java.util.List;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.server.util.DRLConstraintValueBuilder;
import org.drools.ide.common.server.util.GuidedDTDRLUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidedDTDRLOtherwiseHelper {
    public static OtherwiseBuilder getBuilder(ConditionCol52 c) {
        if (c.getOperator().equals("==")) {
            return new EqualsOtherwiseBuilder();
        }
        if (c.getOperator().equals("!=")) {
            return new NotEqualsOtherwiseBuilder();
        }
        throw new IllegalArgumentException("ConditionCol operator does not support Otherwise values");
    }

    private static List<DTCellValue52> extractColumnData(List<List<DTCellValue52>> data, int columnIndex) {
        ArrayList<DTCellValue52> columnData = new ArrayList<DTCellValue52>();
        for (List<DTCellValue52> row : data) {
            columnData.add(row.get(columnIndex));
        }
        return columnData;
    }

    private GuidedDTDRLOtherwiseHelper() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractOtherwiseBuilder
    implements OtherwiseBuilder {
        AbstractOtherwiseBuilder() {
        }

        @Override
        public FieldConstraint makeFieldConstraint(ConditionCol52 c, List<BaseColumn> allColumns, List<List<DTCellValue52>> data) {
            int index = allColumns.indexOf(c);
            List columnData = GuidedDTDRLOtherwiseHelper.extractColumnData(data, index);
            return this.constructSingleFieldConstraint(c, columnData);
        }

        abstract FieldConstraint constructSingleFieldConstraint(ConditionCol52 var1, List<DTCellValue52> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OtherwiseBuilder {
        public FieldConstraint makeFieldConstraint(ConditionCol52 var1, List<BaseColumn> var2, List<List<DTCellValue52>> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotEqualsOtherwiseBuilder
    extends AbstractOtherwiseBuilder {
        @Override
        SingleFieldConstraint constructSingleFieldConstraint(ConditionCol52 c, List<DTCellValue52> columnData) {
            SingleFieldConstraint sfc = new SingleFieldConstraint(c.getFactField());
            sfc.setConstraintValueType(c.getConstraintValueType());
            sfc.setOperator("in");
            ArrayList<String> consumedValues = new ArrayList<String>();
            StringBuilder value = new StringBuilder();
            value.append("( ");
            for (DTCellValue52 cv : columnData) {
                String scv = GuidedDTDRLUtilities.convertDTCellValueToString(cv);
                if (scv == null) continue;
                if (!consumedValues.contains(scv)) {
                    DRLConstraintValueBuilder.buildLHSFieldValue(value, c.getConstraintValueType(), c.getFieldType(), scv);
                    value.append(", ");
                }
                consumedValues.add(scv);
            }
            value.delete(value.lastIndexOf(","), value.length() - 1);
            value.append(")");
            sfc.setValue(value.toString());
            return sfc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EqualsOtherwiseBuilder
    extends AbstractOtherwiseBuilder {
        @Override
        FieldConstraint constructSingleFieldConstraint(ConditionCol52 c, List<DTCellValue52> columnData) {
            SingleFieldConstraint sfc = new SingleFieldConstraint(c.getFactField());
            sfc.setConstraintValueType(c.getConstraintValueType());
            sfc.setOperator("not in");
            ArrayList<String> consumedValues = new ArrayList<String>();
            StringBuilder value = new StringBuilder();
            value.append("( ");
            for (DTCellValue52 cv : columnData) {
                String scv = GuidedDTDRLUtilities.convertDTCellValueToString(cv);
                if (scv == null) continue;
                if (!consumedValues.contains(scv)) {
                    DRLConstraintValueBuilder.buildLHSFieldValue(value, c.getConstraintValueType(), c.getFieldType(), scv);
                    value.append(", ");
                }
                consumedValues.add(scv);
            }
            value.delete(value.lastIndexOf(","), value.length() - 1);
            value.append(")");
            sfc.setValue(value.toString());
            return sfc;
        }
    }
}

