/*
 * Decompiled with CFR 0.152.
 */
package org.drools.contrib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.RuntimeDroolsException;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.DecisionTableInputType;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.rule.Rule;
import org.drools.io.ResourceFactory;
import org.drools.lang.Expander;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.lang.dsl.DefaultExpander;
import org.drools.lang.dsl.DefaultExpanderResolver;
import org.drools.rule.Package;

public class DroolsCompilerAntTask
extends MatchingTask {
    public static String BRLFILEEXTENSION = ".brl";
    public static String XMLFILEEXTENSION = ".xml";
    public static String RULEFLOWMODELFILEEXTENSION = ".rfm";
    public static String RULEFLOWFILEEXTENSION = ".rf";
    public static String DSLFILEEXTENSION = ".dsl";
    public static String DSLRFILEEXTENSION = ".dslr";
    public static String XLSFILEEXTENSION = ".xls";
    public static String DROOLSPACKAGEEXTENSION = ".package";
    public static String PACKAGEBINFORMAT = "package";
    public static String PACKAGEBINTYPE = "knowledge";
    private File srcdir;
    private File toFile;
    private Path classpath;
    private String binformat;
    private String bintype;
    private String verbose;
    private boolean verboseoption;

    public void setSrcDir(File directory) {
        this.srcdir = directory;
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathref(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void execute() throws BuildException {
        super.execute();
        boolean bl = this.verboseoption = this.verbose != null && this.verbose.equalsIgnoreCase("true");
        if (this.toFile == null) {
            throw new BuildException("Destination rulebase file does not specified.");
        }
        if (this.srcdir == null) {
            throw new BuildException("Source directory not specified.");
        }
        if (!this.srcdir.exists()) {
            throw new BuildException("Source directory does not exists." + this.srcdir.getAbsolutePath());
        }
        AntClassLoader loader = null;
        try {
            loader = this.getClassLoader();
            if (PACKAGEBINTYPE.equals(this.bintype)) {
                this.createWithKnowledgeBuilder(loader);
            } else {
                this.createWithPackageBuilder(loader);
            }
        }
        catch (Exception e) {
            throw new BuildException("RuleBaseTask failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (loader != null) {
                loader.resetThreadContextLoader();
            }
        }
    }

    private void createWithKnowledgeBuilder(AntClassLoader loader) throws FileNotFoundException, DroolsParserException, IOException {
        KnowledgeBuilder kbuilder = this.getKnowledgeBuilder(loader);
        this.compileAndAddFiles(kbuilder);
        Collection pkgs = kbuilder.getKnowledgePackages();
        if (this.verboseoption) {
            for (KnowledgePackage pkg : pkgs) {
                this.log("** Content of package: " + pkg.getName());
                Iterator riter = pkg.getRules().iterator();
                while (riter.hasNext()) {
                    this.log("\tRule name: " + ((Rule)riter.next()).getName());
                }
            }
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        if (PACKAGEBINFORMAT.equals(this.binformat)) {
            for (KnowledgePackage pkg : pkgs) {
                if (this.verboseoption) {
                    this.log("** Serializing package [" + pkg.getName() + "] to destination file. **** THIS WILL OVERRIDE ANY PREVIOUSLY SERIALIZED PACKAGE ****");
                }
                this.serializeObject(pkg);
            }
        } else {
            if (this.verboseoption) {
                this.log("** Serializing KnowledgeBase to destination file.");
            }
            this.serializeObject(kbase);
        }
    }

    private void compileAndAddFiles(KnowledgeBuilder kbuilder) throws FileNotFoundException, DroolsParserException, IOException {
        String[] droolsPackageNames = this.getDroolsPackageFileList();
        if (droolsPackageNames != null) {
            for (int i = 0; i < droolsPackageNames.length; ++i) {
                this.compileAndAddFile(kbuilder, droolsPackageNames[i]);
            }
        }
        String[] fileNames = this.getFileList();
        for (int i = 0; i < fileNames.length; ++i) {
            this.compileAndAddFile(kbuilder, fileNames[i]);
        }
        if (kbuilder.hasErrors()) {
            System.err.println(kbuilder.getErrors().toString());
        }
    }

    private void compileAndAddFiles(PackageBuilder pbuilder) throws FileNotFoundException, DroolsParserException, IOException {
        String[] droolsPackageNames = this.getDroolsPackageFileList();
        if (droolsPackageNames != null) {
            for (int i = 0; i < droolsPackageNames.length; ++i) {
                this.compileAndAddFile(pbuilder, droolsPackageNames[i]);
            }
        }
        String[] fileNames = this.getFileList();
        for (int i = 0; i < fileNames.length; ++i) {
            this.compileAndAddFile(pbuilder, fileNames[i]);
        }
        if (pbuilder.hasErrors()) {
            System.err.println(pbuilder.getErrors().toString());
        }
    }

    private void createWithPackageBuilder(AntClassLoader loader) throws FileNotFoundException, DroolsParserException, IOException {
        PackageBuilder builder = this.getPackageBuilder(loader);
        this.compileAndAddFiles(builder);
        Package[] packages = builder.getPackages();
        if (this.verboseoption) {
            for (Package pkg : packages) {
                org.drools.rule.Rule[] rules;
                this.log("** Content of package: " + pkg.getName());
                for (org.drools.rule.Rule rule : rules = pkg.getRules()) {
                    this.log("\tRule name: " + rule.getName());
                }
            }
        }
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackages(packages);
        if (PACKAGEBINFORMAT.equals(this.binformat)) {
            for (Package pkg : packages) {
                if (this.verboseoption) {
                    this.log("** Serializing package [" + pkg.getName() + "] to destination file. **** THIS WILL OVERRIDE ANY PREVIOUSLY SERIALIZED PACKAGE ****");
                }
                this.serializeObject(pkg);
            }
        } else {
            if (this.verboseoption) {
                this.log("** Serializing RuleBase to destination file.");
            }
            this.serializeObject(ruleBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeObject(Object object) throws FileNotFoundException, IOException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(this.toFile);
            DroolsStreamUtils.streamOut((OutputStream)fout, (Object)object);
        }
        finally {
            if (fout != null) {
                fout.close();
            }
        }
    }

    private void compileAndAddFile(KnowledgeBuilder kbuilder, String fileName) throws FileNotFoundException, DroolsParserException, IOException {
        FileReader fileReader = new FileReader(new File(this.srcdir, fileName));
        if (fileName.endsWith(BRLFILEEXTENSION)) {
            kbuilder.add(ResourceFactory.newReaderResource((Reader)fileReader), ResourceType.BRL);
        } else if (fileName.endsWith(RULEFLOWMODELFILEEXTENSION) || fileName.endsWith(RULEFLOWFILEEXTENSION)) {
            kbuilder.add(ResourceFactory.newReaderResource((Reader)fileReader), ResourceType.DRF);
        } else if (fileName.endsWith(XMLFILEEXTENSION)) {
            kbuilder.add(ResourceFactory.newReaderResource((Reader)fileReader), ResourceType.XDRL);
        } else if (fileName.endsWith(XLSFILEEXTENSION)) {
            DecisionTableConfiguration dtableconfiguration = KnowledgeBuilderFactory.newDecisionTableConfiguration();
            dtableconfiguration.setInputType(DecisionTableInputType.XLS);
            kbuilder.add(ResourceFactory.newReaderResource((Reader)fileReader), ResourceType.DTABLE, (ResourceConfiguration)dtableconfiguration);
        } else if (fileName.endsWith(DSLRFILEEXTENSION)) {
            String[] dsls = this.resolveDSLFilesToArray();
            for (int i = 0; i < dsls.length; ++i) {
                kbuilder.add(ResourceFactory.newFileResource((File)new File(this.srcdir, dsls[i])), ResourceType.DSL);
            }
            kbuilder.add(ResourceFactory.newReaderResource((Reader)fileReader), ResourceType.DSLR);
        } else {
            kbuilder.add(ResourceFactory.newReaderResource((Reader)fileReader), ResourceType.DRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileAndAddFile(PackageBuilder builder, String fileName) throws FileNotFoundException, DroolsParserException, IOException {
        InputStreamReader instream = null;
        File file = new File(this.srcdir, fileName);
        try {
            instream = new InputStreamReader(new FileInputStream(file));
            if (fileName.endsWith(RULEFLOWMODELFILEEXTENSION) || fileName.endsWith(RULEFLOWFILEEXTENSION)) {
                builder.addRuleFlow((Reader)instream);
            } else if (fileName.endsWith(XMLFILEEXTENSION)) {
                builder.addPackageFromXml((Reader)instream);
            } else if (fileName.endsWith(BRLFILEEXTENSION)) {
                builder.addPackageFromBrl(ResourceFactory.newReaderResource((Reader)instream));
            } else if (fileName.endsWith(XLSFILEEXTENSION)) {
                SpreadsheetCompiler converter = new SpreadsheetCompiler();
                String drl = converter.compile((InputStream)new FileInputStream(file), InputType.XLS);
                System.out.println(drl);
                builder.addPackageFromDrl((Reader)new StringReader(drl));
            } else if (fileName.endsWith(DSLRFILEEXTENSION)) {
                DrlParser parser = new DrlParser();
                String expandedDRL = parser.getExpandedDRL(this.loadResource(fileName), this.resolveDSLFiles());
                builder.addPackageFromDrl((Reader)new StringReader(expandedDRL));
            } else {
                builder.addPackageFromDrl((Reader)instream);
            }
        }
        finally {
            if (instream != null) {
                instream.close();
            }
        }
    }

    private String[] resolveDSLFilesToArray() {
        ArrayList list = new ArrayList();
        File dir = new File(this.srcdir.getAbsolutePath());
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".dsl");
            }
        };
        return dir.list(filter);
    }

    private DefaultExpanderResolver resolveDSLFiles() throws IOException {
        DefaultExpanderResolver resolver = new DefaultExpanderResolver();
        File dir = new File(this.srcdir.getAbsolutePath());
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".dsl");
            }
        };
        String[] children = dir.list(filter);
        if (children.length == 0) {
            throw new BuildException("There are no DSL files for this directory:" + this.srcdir.getAbsolutePath());
        }
        for (int index = 0; index < children.length; ++index) {
            if (!file.parseAndLoad((Reader)new StringReader(this.loadResource(children[index])))) {
                throw new RuntimeDroolsException("Error parsing and loading DSL file." + file.getErrors());
            }
            DefaultExpander expander = new DefaultExpander();
            expander.addDSLMapping(file.getMapping());
            resolver.addExpander("*", (Expander)expander);
        }
        return resolver;
    }

    private String resolvePackageFile(String dirname) {
        File dir = new File(dirname);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".package");
            }
        };
        String[] children = dir.list(filter);
        if (children.length > 1) {
            throw new BuildException("There are more than one package configuration file for this directory :" + dirname);
        }
        if (children.length == 0) {
            throw new BuildException("There is no package configuration file for this directory:" + dirname);
        }
        return children[0];
    }

    private String loadResource(String name) throws IOException {
        FileInputStream in = new FileInputStream(this.srcdir + "/" + name);
        InputStreamReader reader = new InputStreamReader(in);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    private AntClassLoader getClassLoader() {
        AntClassLoader loader = null;
        loader = this.classpath != null ? new AntClassLoader(PackageBuilder.class.getClassLoader(), this.getProject(), this.classpath, false) : new AntClassLoader(PackageBuilder.class.getClassLoader(), false);
        loader.setThreadContextLoader();
        return loader;
    }

    private PackageBuilder getPackageBuilder(AntClassLoader loader) {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration(new ClassLoader[]{loader});
        PackageBuilder builder = new PackageBuilder(conf);
        return builder;
    }

    private String[] getFileList() {
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.srcdir);
        String[] excludes = new String[]{"*\\*\\*." + DROOLSPACKAGEEXTENSION};
        directoryScanner.setExcludes(excludes);
        String[] fileNames = directoryScanner.getIncludedFiles();
        if (fileNames == null || fileNames.length <= 0) {
            throw new BuildException("No rule files found in include directory.");
        }
        return fileNames;
    }

    private String[] getDroolsPackageFileList() {
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.srcdir);
        String[] includes = new String[]{"*\\*\\*." + DROOLSPACKAGEEXTENSION};
        directoryScanner.setIncludes(includes);
        String[] fileNames = directoryScanner.getIncludedFiles();
        if (fileNames == null || fileNames.length <= 0) {
            this.log("no drools package files found in " + this.srcdir);
        }
        return fileNames;
    }

    private KnowledgeBuilder getKnowledgeBuilder(AntClassLoader loader) {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration(new ClassLoader[]{loader});
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        return kbuilder;
    }

    public void addConfiguredSysproperty(Environment.Variable sysp) {
        String syspString = sysp.getContent();
        this.getProject().log("sysproperty added: " + syspString, 4);
        System.setProperty(sysp.getKey(), sysp.getValue());
    }

    public void setBinformat(String binformat) {
        this.binformat = binformat;
    }

    public String getBinformat() {
        return this.binformat;
    }

    public String getBintype() {
        return this.bintype;
    }

    public void setBintype(String bintype) {
        this.bintype = bintype;
    }

    public void setVerbose(String verbose) {
        this.verbose = verbose;
    }

    public String getVerbose() {
        return this.verbose;
    }
}

