/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.transaction.UserTransaction;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.jbpm.task.Attachment;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.Deadline;
import org.jbpm.task.Deadlines;
import org.jbpm.task.Escalation;
import org.jbpm.task.Group;
import org.jbpm.task.Notification;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Reassignment;
import org.jbpm.task.Status;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.query.DeadlineSummary;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.Allowed;
import org.jbpm.task.service.CannotAddTaskException;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.Operation;
import org.jbpm.task.service.OperationCommand;
import org.jbpm.task.service.PermissionDeniedException;
import org.jbpm.task.service.SendIcal;
import org.jbpm.task.service.TaskException;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceRequest;
import org.jbpm.task.service.UserGroupCallbackManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskServiceSession {
    private final TaskService service;
    private final EntityManager em;
    private Map<String, RuleBase> ruleBases;
    private Map<String, Map<String, Object>> globals;
    private Map<String, Boolean> userGroupsMap = new HashMap<String, Boolean>();
    private String transactionType = "default";
    private static final Logger logger = LoggerFactory.getLogger(TaskServiceSession.class);

    public TaskServiceSession(TaskService service, EntityManager em) {
        this.service = service;
        this.em = em;
    }

    public void setTransactionType(String type) {
        this.transactionType = type;
    }

    public void dispose() {
        this.em.close();
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    public TaskService getService() {
        return this.service;
    }

    public void setRuleBase(String type, RuleBase ruleBase) {
        if (this.ruleBases == null) {
            this.ruleBases = new HashMap<String, RuleBase>();
        }
        this.ruleBases.put(type, ruleBase);
    }

    public void setGlobals(String type, Map<String, Object> globals) {
        if (this.globals == null) {
            this.globals = new HashMap<String, Map<String, Object>>();
        }
        this.globals.put(type, globals);
    }

    public void addUser(User user) {
        this.persistInTransaction(user);
    }

    public void addGroup(Group group) {
        this.persistInTransaction(group);
    }

    private void executeTaskAddRules(Task task, ContentData contentData) throws CannotAddTaskException {
        RuleBase ruleBase = this.ruleBases.get("addTask");
        if (ruleBase != null) {
            StatefulSession session = ruleBase.newStatefulSession();
            Map<String, Object> globals = this.globals.get("addTask");
            if (globals != null) {
                for (Map.Entry<String, Object> entry : globals.entrySet()) {
                    session.setGlobal(entry.getKey(), entry.getValue());
                }
            }
            TaskServiceRequest request = new TaskServiceRequest("addTask", null, null);
            session.setGlobal("request", (Object)request);
            session.insert((Object)task);
            session.insert((Object)contentData);
            session.fireAllRules();
            if (!request.isAllowed()) {
                StringBuilder error = new StringBuilder("Cannot add Task:\n");
                if (request.getReasons() != null) {
                    for (String reason : request.getReasons()) {
                        error.append(reason).append('\n');
                    }
                }
                throw new CannotAddTaskException(error.toString());
            }
        }
    }

    public void addTask(final Task task, final ContentData contentData) throws CannotAddTaskException {
        PeopleAssignments assignments;
        this.doCallbackOperationForPeopleAssignments(task.getPeopleAssignments());
        this.doCallbackOperationForTaskData(task.getTaskData());
        this.doCallbackOperationForTaskDeadlines(task.getDeadlines());
        final TaskData taskData = task.getTaskData();
        Status currentStatus = taskData.initialize();
        if (this.ruleBases != null) {
            this.executeTaskAddRules(task, contentData);
        }
        if ((assignments = task.getPeopleAssignments()) != null) {
            List<OrganizationalEntity> potentialOwners = assignments.getPotentialOwners();
            currentStatus = taskData.assignOwnerAndStatus(potentialOwners);
        }
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                TaskServiceSession.this.em.persist((Object)task);
                if (contentData != null) {
                    Content content = new Content(contentData.getContent());
                    TaskServiceSession.this.em.persist((Object)content);
                    taskData.setDocument(content.getId(), contentData);
                }
            }
        });
        if (task.getDeadlines() != null) {
            this.scheduleTask(task);
        }
        if (currentStatus == Status.Reserved) {
            SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
            this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId());
        }
    }

    private void scheduleTask(Task task) {
        List<Deadline> endDeadlines;
        long now = System.currentTimeMillis();
        List<Deadline> startDeadlines = task.getDeadlines().getStartDeadlines();
        if (startDeadlines != null) {
            this.scheduleDeadlines(startDeadlines, now, task.getId());
        }
        if ((endDeadlines = task.getDeadlines().getEndDeadlines()) != null) {
            this.scheduleDeadlines(endDeadlines, now, task.getId());
        }
    }

    private void scheduleDeadlines(List<Deadline> deadlines, long now, long taskId) {
        for (Deadline deadline : deadlines) {
            if (deadline.isEscalated()) continue;
            Date date = deadline.getDate();
            this.service.schedule(new TaskService.ScheduledTaskDeadline(taskId, deadline.getId(), this.service), date.getTime() - now);
        }
    }

    void evalCommand(Operation operation, List<OperationCommand> commands, Task task, User user, OrganizationalEntity targetEntity, List<String> groupIds) throws PermissionDeniedException {
        TaskData taskData = task.getTaskData();
        boolean statusMatched = false;
        for (OperationCommand command : commands) {
            if (command.getStatus() != null) {
                for (Status status : command.getStatus()) {
                    if (taskData.getStatus() == status) {
                        statusMatched = true;
                        if (!this.isAllowed(command, task, user, groupIds)) {
                            String errorMessage = "User '" + user + "' does not have permissions to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId();
                            throw new PermissionDeniedException(errorMessage);
                        }
                        this.commands(command, task, user, targetEntity);
                        continue;
                    }
                    logger.debug("No match on status for task " + task.getId() + ": status " + (Object)((Object)taskData.getStatus()) + " != " + (Object)((Object)status));
                }
            }
            if (command.getPreviousStatus() == null) continue;
            for (Status status : command.getPreviousStatus()) {
                if (taskData.getPreviousStatus() == status) {
                    statusMatched = true;
                    if (!this.isAllowed(command, task, user, groupIds)) {
                        String errorMessage = "User '" + user + "' does not have permissions to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId();
                        throw new PermissionDeniedException(errorMessage);
                    }
                    this.commands(command, task, user, targetEntity);
                    continue;
                }
                logger.debug("No match on previous status for task " + task.getId() + ": status " + (Object)((Object)taskData.getStatus()) + " != " + (Object)((Object)status));
            }
        }
        if (!statusMatched) {
            String errorMessage = "User '" + user + "' was unable to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId() + " due to a no 'current status' match";
            throw new PermissionDeniedException(errorMessage);
        }
    }

    private boolean isAllowed(OperationCommand command, Task task, User user, List<String> groupIds) {
        PeopleAssignments people = task.getPeopleAssignments();
        TaskData taskData = task.getTaskData();
        boolean operationAllowed = false;
        for (Allowed allowed : command.getAllowed()) {
            if (operationAllowed) break;
            switch (allowed) {
                case Owner: {
                    operationAllowed = taskData.getActualOwner() != null && taskData.getActualOwner().equals(user);
                    break;
                }
                case Initiator: {
                    operationAllowed = taskData.getCreatedBy() != null && taskData.getCreatedBy().equals(user) || groupIds != null && groupIds.contains(taskData.getCreatedBy().getId());
                    break;
                }
                case PotentialOwner: {
                    operationAllowed = this.isAllowed(user, groupIds, people.getPotentialOwners());
                    break;
                }
                case BusinessAdministrator: {
                    operationAllowed = this.isAllowed(user, groupIds, people.getBusinessAdministrators());
                    break;
                }
                case Anyone: {
                    operationAllowed = true;
                }
            }
        }
        if (operationAllowed && command.isUserIsExplicitPotentialOwner()) {
            operationAllowed = people.getPotentialOwners().contains(user);
        }
        if (operationAllowed && command.isSkippable()) {
            operationAllowed = taskData.isSkipable();
        }
        return operationAllowed;
    }

    private void commands(OperationCommand command, Task task, User user, OrganizationalEntity targetEntity) {
        PeopleAssignments people = task.getPeopleAssignments();
        TaskData taskData = task.getTaskData();
        if (command.getNewStatus() != null) {
            taskData.setStatus(command.getNewStatus());
        } else if (command.isSetToPreviousStatus()) {
            taskData.setStatus(taskData.getPreviousStatus());
        }
        if (command.isAddTargetEntityToPotentialOwners() && !people.getPotentialOwners().contains(targetEntity)) {
            people.getPotentialOwners().add(targetEntity);
        }
        if (command.isRemoveUserFromPotentialOwners()) {
            people.getPotentialOwners().remove(user);
        }
        if (command.isSetNewOwnerToUser()) {
            taskData.setActualOwner(user);
        }
        if (command.isSetNewOwnerToNull()) {
            taskData.setActualOwner(null);
        }
        if (command.getExec() != null) {
            switch (command.getExec()) {
                case Claim: {
                    taskData.setActualOwner((User)targetEntity);
                    SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
                    this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId());
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void taskOperation(Operation operation, long taskId, String userId, String targetEntityId, ContentData data, List<String> groupIds) throws TaskException {
        targetEntity = null;
        groupIds = this.doUserGroupCallbackOperation(userId, groupIds);
        this.doCallbackUserOperation(targetEntityId);
        if (targetEntityId != null) {
            targetEntity = this.getEntity(OrganizationalEntity.class, targetEntityId);
        }
        task = this.getTask(taskId);
        user = this.getEntity(User.class, userId);
        transactionStarted = false;
        try {
            commands = this.service.getCommandsForOperation(operation);
            transactionStarted = this.beginOrUseExistingTransaction();
            this.evalCommand(operation, commands, task, user, targetEntity, groupIds);
            switch (15.$SwitchMap$org$jbpm$task$service$Operation[operation.ordinal()]) {
                case 1: {
                    this.taskClaimOperation(task);
                    ** break;
lbl17:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.taskCompleteOperation(task, data);
                    ** break;
lbl21:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.taskFailOperation(task, data);
                    ** break;
lbl25:
                    // 1 sources

                    break;
                }
                case 4: {
                    this.taskSkipOperation(task, userId);
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 5: {
                    this.taskRemoveOperation(task, user);
                    ** break;
lbl33:
                    // 1 sources

                    break;
                }
                case 6: {
                    this.taskRegisterOperation(task, user);
                    break;
                }
                ** default:
lbl38:
                // 1 sources

                break;
            }
        }
        catch (RuntimeException e) {
            if ("default".equals(this.transactionType)) {
                if (this.em.getTransaction().isActive()) {
                    this.em.getTransaction().rollback();
                }
            } else if ("local-JTA".equals(this.transactionType)) {
                try {
                    ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                    ut.setRollbackOnly();
                }
                catch (Exception exc) {
                    throw new RuntimeException(e);
                }
            }
            this.doOperationInTransaction(new TransactedOperation(){

                public void doOperation() {
                    task.getTaskData().setStatus(Status.Error);
                }
            });
            throw e;
        }
        finally {
            if ("default".equals(this.transactionType)) {
                if (this.em.getTransaction().isActive()) {
                    this.em.getTransaction().commit();
                }
            } else if ("local-JTA".equals(this.transactionType) && transactionStarted) {
                try {
                    ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                    ut.commit();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        switch (15.$SwitchMap$org$jbpm$task$service$Operation[operation.ordinal()]) {
            case 1: {
                this.postTaskClaimOperation(task);
                break;
            }
            case 2: {
                this.postTaskCompleteOperation(task);
                break;
            }
            case 3: {
                this.postTaskFailOperation(task);
                break;
            }
            case 4: {
                this.postTaskSkipOperation(task, userId);
            }
        }
    }

    private void taskClaimOperation(Task task) {
        SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
    }

    private void postTaskClaimOperation(Task task) {
        this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId());
    }

    private void taskCompleteOperation(Task task, ContentData data) {
        if (data != null) {
            this.setOutput(task.getId(), task.getTaskData().getActualOwner().getId(), data);
        }
        this.checkSubTaskStrategy(task);
    }

    private void postTaskCompleteOperation(Task task) {
        this.service.getEventSupport().fireTaskCompleted(task.getId(), task.getTaskData().getActualOwner().getId());
    }

    private void taskFailOperation(Task task, ContentData data) {
        if (data != null) {
            this.setFault(task.getId(), task.getTaskData().getActualOwner().getId(), (FaultData)data);
        }
    }

    private void postTaskFailOperation(Task task) {
        this.service.getEventSupport().fireTaskFailed(task.getId(), task.getTaskData().getActualOwner().getId());
    }

    private void taskSkipOperation(Task task, String userId) {
        this.checkSubTaskStrategy(task);
    }

    private void postTaskSkipOperation(Task task, String userId) {
        this.service.getEventSupport().fireTaskSkipped(task.getId(), userId);
    }

    public Task getTask(long taskId) {
        return this.getEntity(Task.class, taskId);
    }

    public void addComment(long taskId, final Comment comment) {
        final Task task = this.getTask(taskId);
        this.doCallbackOperationForComment(comment);
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                task.getTaskData().addComment(comment);
            }
        });
    }

    public void addAttachment(long taskId, final Attachment attachment, final Content content) {
        final Task task = this.getTask(taskId);
        this.doCallbackOperationForAttachment(attachment);
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                TaskServiceSession.this.em.persist((Object)content);
                attachment.setContent(content);
                task.getTaskData().addAttachment(attachment);
            }
        });
    }

    public void setDocumentContent(long taskId, final Content content) {
        final Task task = this.getTask(taskId);
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                TaskServiceSession.this.em.persist((Object)content);
                task.getTaskData().setDocumentContentId(content.getId());
            }
        });
    }

    public Content getContent(long contentId) {
        return this.getEntity(Content.class, contentId);
    }

    public void deleteAttachment(long taskId, final long attachmentId, final long contentId) {
        final Task task = this.getTask(taskId);
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                Attachment removedAttachment = task.getTaskData().removeAttachment(attachmentId);
                if (removedAttachment != null) {
                    TaskServiceSession.this.em.remove((Object)removedAttachment);
                }
                String deleteContent = "delete from Content c where c.id = :id";
                TaskServiceSession.this.em.createQuery("delete from Content c where c.id = :id").setParameter("id", (Object)contentId).executeUpdate();
            }
        });
    }

    public void deleteComment(long taskId, final long commentId) {
        final Task task = this.getTask(taskId);
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                Comment removedComment = task.getTaskData().removeComment(commentId);
                if (removedComment != null) {
                    TaskServiceSession.this.em.remove((Object)removedComment);
                }
            }
        });
    }

    public List<DeadlineSummary> getUnescalatedDeadlines() {
        return this.em.createNamedQuery("UnescalatedDeadlines").getResultList();
    }

    public Task getTaskByWorkItemId(long workItemId) {
        Query task = this.em.createNamedQuery("TaskByWorkItemId");
        task.setParameter("workItemId", (Object)workItemId);
        return (Task)task.getSingleResult();
    }

    public List<TaskSummary> getTasksOwned(String userId, String language) {
        this.doCallbackUserOperation(userId);
        Query tasksOwned = this.em.createNamedQuery("TasksOwned");
        tasksOwned.setParameter("userId", (Object)userId);
        tasksOwned.setParameter("language", (Object)language);
        return tasksOwned.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        this.doCallbackUserOperation(userId);
        Query tasksAssignedAsBusinessAdministrator = this.em.createNamedQuery("TasksAssignedAsBusinessAdministrator");
        tasksAssignedAsBusinessAdministrator.setParameter("userId", (Object)userId);
        tasksAssignedAsBusinessAdministrator.setParameter("language", (Object)language);
        return tasksAssignedAsBusinessAdministrator.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        this.doCallbackUserOperation(userId);
        Query tasksAssignedAsExcludedOwner = this.em.createNamedQuery("TasksAssignedAsExcludedOwner");
        tasksAssignedAsExcludedOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsExcludedOwner.setParameter("language", (Object)language);
        return tasksAssignedAsExcludedOwner.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        this.doCallbackUserOperation(userId);
        Query tasksAssignedAsPotentialOwner = this.em.createNamedQuery("TasksAssignedAsPotentialOwner");
        tasksAssignedAsPotentialOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsPotentialOwner.setParameter("language", (Object)language);
        return tasksAssignedAsPotentialOwner.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language) {
        return this.getTasksAssignedAsPotentialOwner(userId, groupIds, language, -1, -1);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResults) {
        this.doCallbackUserOperation(userId);
        groupIds = this.doUserGroupCallbackOperation(userId, groupIds);
        Query tasksAssignedAsPotentialOwner = this.em.createNamedQuery("TasksAssignedAsPotentialOwnerWithGroups");
        tasksAssignedAsPotentialOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsPotentialOwner.setParameter("groupIds", groupIds);
        tasksAssignedAsPotentialOwner.setParameter("language", (Object)language);
        if (maxResults != -1) {
            tasksAssignedAsPotentialOwner.setFirstResult(firstResult);
            tasksAssignedAsPotentialOwner.setMaxResults(maxResults);
        }
        return tasksAssignedAsPotentialOwner.getResultList();
    }

    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        this.doCallbackUserOperation(userId);
        Query tasksAssignedAsPotentialOwner = this.em.createNamedQuery("SubTasksAssignedAsPotentialOwner");
        tasksAssignedAsPotentialOwner.setParameter("parentId", (Object)parentId);
        tasksAssignedAsPotentialOwner.setParameter("userId", (Object)userId);
        tasksAssignedAsPotentialOwner.setParameter("language", (Object)language);
        return tasksAssignedAsPotentialOwner.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByGroup(String groupId, String language) {
        this.doCallbackGroupOperation(groupId);
        Query tasksAssignedAsPotentialOwnerByGroup = this.em.createNamedQuery("TasksAssignedAsPotentialOwnerByGroup");
        tasksAssignedAsPotentialOwnerByGroup.setParameter("groupId", (Object)groupId);
        tasksAssignedAsPotentialOwnerByGroup.setParameter("language", (Object)language);
        return tasksAssignedAsPotentialOwnerByGroup.getResultList();
    }

    public List<TaskSummary> getSubTasksByParent(long parentId, String language) {
        Query subTaskByParent = this.em.createNamedQuery("GetSubTasksByParentTaskId");
        subTaskByParent.setParameter("parentId", (Object)parentId);
        subTaskByParent.setParameter("language", (Object)language);
        return subTaskByParent.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        this.doCallbackUserOperation(userId);
        Query tasksAssignedAsRecipient = this.em.createNamedQuery("TasksAssignedAsRecipient");
        tasksAssignedAsRecipient.setParameter("userId", (Object)userId);
        tasksAssignedAsRecipient.setParameter("language", (Object)language);
        return tasksAssignedAsRecipient.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        this.doCallbackUserOperation(userId);
        Query tasksAssignedAsTaskInitiator = this.em.createNamedQuery("TasksAssignedAsTaskInitiator");
        tasksAssignedAsTaskInitiator.setParameter("userId", (Object)userId);
        tasksAssignedAsTaskInitiator.setParameter("language", (Object)language);
        return tasksAssignedAsTaskInitiator.getResultList();
    }

    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        this.doCallbackUserOperation(userId);
        Query tasksAssignedAsTaskStakeholder = this.em.createNamedQuery("TasksAssignedAsTaskStakeholder");
        tasksAssignedAsTaskStakeholder.setParameter("userId", (Object)userId);
        tasksAssignedAsTaskStakeholder.setParameter("language", (Object)language);
        return tasksAssignedAsTaskStakeholder.getResultList();
    }

    public List<?> query(String qlString, Integer size, Integer offset) {
        Query genericQuery = this.em.createQuery(qlString);
        genericQuery.setMaxResults(size.intValue());
        genericQuery.setFirstResult(offset.intValue());
        return genericQuery.getResultList();
    }

    private void taskRemoveOperation(Task task, User user) {
        if (!task.getPeopleAssignments().getRecipients().contains(user)) {
            throw new RuntimeException("Couldn't remove user " + user.getId() + " since it isn't a notification recipient");
        }
        task.getPeopleAssignments().getRecipients().remove(user);
    }

    private void taskRegisterOperation(Task task, User user) {
        if (!task.getPeopleAssignments().getRecipients().contains(user)) {
            task.getPeopleAssignments().getRecipients().add(user);
        }
    }

    public void nominateTask(long taskId, String userId, final List<OrganizationalEntity> potentialOwners) {
        this.doCallbackUserOperation(userId);
        this.doCallbackOperationForPotentialOwners(potentialOwners);
        final Task task = this.getEntity(Task.class, taskId);
        User user = this.getEntity(User.class, userId);
        if (!this.isAllowed(user, null, task.getPeopleAssignments().getBusinessAdministrators())) {
            throw new PermissionDeniedException("User " + userId + " is not allowed to perform Nominate on Task " + taskId);
        }
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                task.getTaskData().assignOwnerAndStatus(potentialOwners);
                if (task.getTaskData().getStatus() == Status.Ready) {
                    task.getPeopleAssignments().setPotentialOwners(potentialOwners);
                }
            }
        });
    }

    public void setOutput(final long taskId, final String userId, final ContentData outputContentData) {
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                Task task = (Task)TaskServiceSession.this.getEntity(Task.class, taskId);
                if (!userId.equals(task.getTaskData().getActualOwner().getId())) {
                    throw new RuntimeException("User " + userId + " is not the actual owner of the task " + taskId + " and can't perform setOutput");
                }
                Content content = new Content();
                content.setContent(outputContentData.getContent());
                TaskServiceSession.this.em.persist((Object)content);
                task.getTaskData().setOutput(content.getId(), outputContentData);
            }
        });
    }

    public void setFault(final long taskId, final String userId, final FaultData faultContentData) {
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                Task task = (Task)TaskServiceSession.this.getEntity(Task.class, taskId);
                if (!userId.equals(task.getTaskData().getActualOwner().getId())) {
                    throw new RuntimeException("User " + userId + " is not the actual owner of the task " + taskId + " and can't perform setFault");
                }
                Content content = new Content();
                content.setContent(faultContentData.getContent());
                TaskServiceSession.this.em.persist((Object)content);
                task.getTaskData().setFault(content.getId(), faultContentData);
            }
        });
    }

    public void setPriority(final long taskId, String userId, final int priority) {
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                Task task = (Task)TaskServiceSession.this.getEntity(Task.class, taskId);
                task.setPriority(priority);
            }
        });
    }

    public void deleteOutput(final long taskId, final String userId) {
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                Task task = (Task)TaskServiceSession.this.getEntity(Task.class, taskId);
                if (!userId.equals(task.getTaskData().getActualOwner().getId())) {
                    throw new RuntimeException("User " + userId + " is not the actual owner of the task " + taskId + " and can't perform deleteOutput");
                }
                long contentId = task.getTaskData().getOutputContentId();
                Content content = (Content)TaskServiceSession.this.getEntity(Content.class, contentId);
                ContentData data = new ContentData();
                TaskServiceSession.this.em.remove((Object)content);
                task.getTaskData().setOutput(0L, data);
            }
        });
    }

    public void deleteFault(final long taskId, final String userId) {
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                Task task = (Task)TaskServiceSession.this.getEntity(Task.class, taskId);
                if (!userId.equals(task.getTaskData().getActualOwner().getId())) {
                    throw new RuntimeException("User " + userId + " is not the actual owner of the task " + taskId + " and can't perform deleteFault");
                }
                long contentId = task.getTaskData().getFaultContentId();
                Content content = (Content)TaskServiceSession.this.getEntity(Content.class, contentId);
                FaultData data = new FaultData();
                TaskServiceSession.this.em.remove((Object)content);
                task.getTaskData().setFault(0L, data);
            }
        });
    }

    private boolean isAllowed(User user, List<OrganizationalEntity>[] people) {
        for (List<OrganizationalEntity> list : people) {
            if (!this.isAllowed(user, null, list)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowed(User user, List<String> groupIds, List<OrganizationalEntity> entities) {
        for (OrganizationalEntity entity : entities) {
            if (entity instanceof User && entity.equals(user)) {
                return true;
            }
            if (!(entity instanceof Group) || groupIds == null || !groupIds.contains(entity.getId())) continue;
            return true;
        }
        return false;
    }

    private void checkSubTaskStrategy(Task task) {
        for (SubTasksStrategy strategy : task.getSubTaskStrategies()) {
            strategy.execute(this, this.service, task);
        }
        if (task.getTaskData().getParentId() != -1L) {
            Task parentTask = this.getTask(task.getTaskData().getParentId());
            for (SubTasksStrategy strategy : parentTask.getSubTaskStrategies()) {
                strategy.execute(this, this.service, parentTask);
            }
        }
    }

    private <T> T getEntity(Class<T> entityClass, Object primaryKey) {
        Object entity = this.em.find(entityClass, primaryKey);
        if (entity == null) {
            throw new EntityNotFoundException("No " + entityClass.getSimpleName() + " with ID " + primaryKey + " was found!");
        }
        return (T)entity;
    }

    private void persistInTransaction(final Object object) {
        this.doOperationInTransaction(new TransactedOperation(){

            public void doOperation() {
                TaskServiceSession.this.em.persist(object);
            }
        });
    }

    private boolean beginOrUseExistingTransaction() {
        if ("default".equals(this.transactionType)) {
            EntityTransaction tx = this.em.getTransaction();
            if (!tx.isActive()) {
                tx.begin();
                return true;
            }
            return false;
        }
        if ("local-JTA".equals(this.transactionType)) {
            try {
                UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                if (ut.getStatus() == 6) {
                    ut.begin();
                    this.em.joinTransaction();
                    return true;
                }
                return false;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        throw new IllegalArgumentException("Unknown transaction type " + this.transactionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOperationInTransaction(TransactedOperation operation) {
        if ("default".equals(this.transactionType)) {
            EntityTransaction tx = this.em.getTransaction();
            try {
                if (!tx.isActive()) {
                    tx.begin();
                }
                operation.doOperation();
                tx.commit();
            }
            finally {
                if (tx.isActive()) {
                    tx.rollback();
                }
            }
        }
        if ("local-JTA".equals(this.transactionType)) {
            try {
                UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                if (ut.getStatus() == 6) {
                    ut.begin();
                    this.em.joinTransaction();
                    operation.doOperation();
                    ut.commit();
                } else {
                    this.em.joinTransaction();
                    operation.doOperation();
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private List<String> doUserGroupCallbackOperation(String userId, List<String> groupIds) {
        if (UserGroupCallbackManager.getInstance().existsCallback()) {
            this.doCallbackUserOperation(userId);
            this.doCallbackGroupsOperation(userId, groupIds);
            List allGroups = this.em.createQuery("from Group").getResultList();
            ArrayList<String> allGroupIds = new ArrayList<String>();
            if (allGroups != null) {
                for (Group g : allGroups) {
                    allGroupIds.add(g.getId());
                }
            }
            return UserGroupCallbackManager.getInstance().getCallback().getGroupsForUser(userId, groupIds, allGroupIds);
        }
        logger.debug("UserGroupCallback has not been registered.");
        return groupIds;
    }

    private void doCallbackUserOperation(String userId) {
        if (UserGroupCallbackManager.getInstance().existsCallback()) {
            if (userId != null && UserGroupCallbackManager.getInstance().getCallback().existsUser(userId)) {
                this.addUserFromCallbackOperation(userId);
            }
        } else {
            logger.debug("UserGroupCallback has not been registered.");
        }
    }

    private void doCallbackGroupOperation(String groupId) {
        if (UserGroupCallbackManager.getInstance().existsCallback()) {
            if (groupId != null && UserGroupCallbackManager.getInstance().getCallback().existsGroup(groupId)) {
                this.addGroupFromCallbackOperation(groupId);
            }
        } else {
            logger.debug("UserGroupCallback has not been registered.");
        }
    }

    private void doCallbackOperationForTaskData(TaskData data) {
        if (UserGroupCallbackManager.getInstance().existsCallback() && data != null) {
            if (data.getActualOwner() != null) {
                this.doCallbackUserOperation(data.getActualOwner().getId());
            }
            if (data.getCreatedBy() != null) {
                this.doCallbackUserOperation(data.getCreatedBy().getId());
            }
        }
    }

    private void doCallbackOperationForPotentialOwners(List<OrganizationalEntity> potentialOwners) {
        if (UserGroupCallbackManager.getInstance().existsCallback() && potentialOwners != null) {
            for (OrganizationalEntity orgEntity : potentialOwners) {
                if (orgEntity instanceof User) {
                    this.doCallbackUserOperation(orgEntity.getId());
                }
                if (!(orgEntity instanceof Group)) continue;
                this.doCallbackGroupOperation(orgEntity.getId());
            }
        }
    }

    private void doCallbackOperationForPeopleAssignments(PeopleAssignments assignments) {
        if (UserGroupCallbackManager.getInstance().existsCallback() && assignments != null) {
            List<OrganizationalEntity> stakeholders;
            List<OrganizationalEntity> recipients;
            List<OrganizationalEntity> excludedOwners;
            List<OrganizationalEntity> potentialOwners;
            List<OrganizationalEntity> businessAdmins = assignments.getBusinessAdministrators();
            if (businessAdmins != null) {
                for (OrganizationalEntity admin : businessAdmins) {
                    if (admin instanceof User) {
                        this.doCallbackUserOperation(admin.getId());
                    }
                    if (!(admin instanceof Group)) continue;
                    this.doCallbackGroupOperation(admin.getId());
                }
            }
            if ((potentialOwners = assignments.getPotentialOwners()) != null) {
                for (OrganizationalEntity powner : potentialOwners) {
                    if (powner instanceof User) {
                        this.doCallbackUserOperation(powner.getId());
                    }
                    if (!(powner instanceof Group)) continue;
                    this.doCallbackGroupOperation(powner.getId());
                }
            }
            if (assignments.getTaskInitiator() != null && assignments.getTaskInitiator().getId() != null) {
                this.doCallbackUserOperation(assignments.getTaskInitiator().getId());
            }
            if ((excludedOwners = assignments.getExcludedOwners()) != null) {
                for (OrganizationalEntity exowner : excludedOwners) {
                    if (exowner instanceof User) {
                        this.doCallbackUserOperation(exowner.getId());
                    }
                    if (!(exowner instanceof Group)) continue;
                    this.doCallbackGroupOperation(exowner.getId());
                }
            }
            if ((recipients = assignments.getRecipients()) != null) {
                for (OrganizationalEntity recipient : recipients) {
                    if (recipient instanceof User) {
                        this.doCallbackUserOperation(recipient.getId());
                    }
                    if (!(recipient instanceof Group)) continue;
                    this.doCallbackGroupOperation(recipient.getId());
                }
            }
            if ((stakeholders = assignments.getTaskStakeholders()) != null) {
                for (OrganizationalEntity stakeholder : stakeholders) {
                    if (stakeholder instanceof User) {
                        this.doCallbackUserOperation(stakeholder.getId());
                    }
                    if (!(stakeholder instanceof Group)) continue;
                    this.doCallbackGroupOperation(stakeholder.getId());
                }
            }
        }
    }

    private void doCallbackOperationForComment(Comment comment) {
        if (comment != null && comment.getAddedBy() != null) {
            this.doCallbackUserOperation(comment.getAddedBy().getId());
        }
    }

    private void doCallbackOperationForAttachment(Attachment attachment) {
        if (attachment != null && attachment.getAttachedBy() != null) {
            this.doCallbackUserOperation(attachment.getAttachedBy().getId());
        }
    }

    private void doCallbackOperationForTaskDeadlines(Deadlines deadlines) {
        if (deadlines != null) {
            List<OrganizationalEntity> potentialOwners;
            List<OrganizationalEntity> administrators;
            List<OrganizationalEntity> recipients;
            List<Reassignment> ressignments;
            List<Notification> notifications;
            List<Escalation> escalations;
            if (deadlines.getStartDeadlines() != null) {
                List<Deadline> startDeadlines = deadlines.getStartDeadlines();
                for (Deadline startDeadline : startDeadlines) {
                    escalations = startDeadline.getEscalations();
                    if (escalations == null) continue;
                    for (Escalation escalation : escalations) {
                        notifications = escalation.getNotifications();
                        ressignments = escalation.getReassignments();
                        if (notifications != null) {
                            for (Notification notification : notifications) {
                                recipients = notification.getRecipients();
                                if (recipients != null) {
                                    for (OrganizationalEntity recipient : recipients) {
                                        if (recipient instanceof User) {
                                            this.doCallbackUserOperation(recipient.getId());
                                        }
                                        if (!(recipient instanceof Group)) continue;
                                        this.doCallbackGroupOperation(recipient.getId());
                                    }
                                }
                                if ((administrators = notification.getBusinessAdministrators()) == null) continue;
                                for (OrganizationalEntity administrator : administrators) {
                                    if (administrator instanceof User) {
                                        this.doCallbackUserOperation(administrator.getId());
                                    }
                                    if (!(administrator instanceof Group)) continue;
                                    this.doCallbackGroupOperation(administrator.getId());
                                }
                            }
                        }
                        if (ressignments == null) continue;
                        for (Reassignment reassignment : ressignments) {
                            potentialOwners = reassignment.getPotentialOwners();
                            if (potentialOwners == null) continue;
                            for (OrganizationalEntity potentialOwner : potentialOwners) {
                                if (potentialOwner instanceof User) {
                                    this.doCallbackUserOperation(potentialOwner.getId());
                                }
                                if (!(potentialOwner instanceof Group)) continue;
                                this.doCallbackGroupOperation(potentialOwner.getId());
                            }
                        }
                    }
                }
            }
            if (deadlines.getEndDeadlines() != null) {
                List<Deadline> endDeadlines = deadlines.getEndDeadlines();
                for (Deadline endDeadline : endDeadlines) {
                    escalations = endDeadline.getEscalations();
                    if (escalations == null) continue;
                    for (Escalation escalation : escalations) {
                        notifications = escalation.getNotifications();
                        ressignments = escalation.getReassignments();
                        if (notifications != null) {
                            for (Notification notification : notifications) {
                                recipients = notification.getRecipients();
                                if (recipients != null) {
                                    for (OrganizationalEntity recipient : recipients) {
                                        if (recipient instanceof User) {
                                            this.doCallbackUserOperation(recipient.getId());
                                        }
                                        if (!(recipient instanceof Group)) continue;
                                        this.doCallbackGroupOperation(recipient.getId());
                                    }
                                }
                                if ((administrators = notification.getBusinessAdministrators()) == null) continue;
                                for (OrganizationalEntity administrator : administrators) {
                                    if (administrator instanceof User) {
                                        this.doCallbackUserOperation(administrator.getId());
                                    }
                                    if (!(administrator instanceof Group)) continue;
                                    this.doCallbackGroupOperation(administrator.getId());
                                }
                            }
                        }
                        if (ressignments == null) continue;
                        for (Reassignment reassignment : ressignments) {
                            potentialOwners = reassignment.getPotentialOwners();
                            if (potentialOwners == null) continue;
                            for (OrganizationalEntity potentialOwner : potentialOwners) {
                                if (potentialOwner instanceof User) {
                                    this.doCallbackUserOperation(potentialOwner.getId());
                                }
                                if (!(potentialOwner instanceof Group)) continue;
                                this.doCallbackGroupOperation(potentialOwner.getId());
                            }
                        }
                    }
                }
            }
        }
    }

    private void doCallbackGroupsOperation(String userId, List<String> groupIds) {
        if (UserGroupCallbackManager.getInstance().existsCallback()) {
            if (userId != null) {
                List<String> userGroups;
                if (groupIds != null && groupIds.size() > 0) {
                    for (String groupId : groupIds) {
                        if (!UserGroupCallbackManager.getInstance().getCallback().existsGroup(groupId) || UserGroupCallbackManager.getInstance().getCallback().getGroupsForUser(userId, groupIds) == null || !UserGroupCallbackManager.getInstance().getCallback().getGroupsForUser(userId, groupIds).contains(groupId)) continue;
                        this.addGroupFromCallbackOperation(groupId);
                    }
                } else if (!(this.userGroupsMap.containsKey(userId) && this.userGroupsMap.get(userId).booleanValue() || (userGroups = UserGroupCallbackManager.getInstance().getCallback().getGroupsForUser(userId)) == null || userGroups.size() <= 0)) {
                    for (String group : userGroups) {
                        this.addGroupFromCallbackOperation(group);
                    }
                    this.userGroupsMap.put(userId, true);
                }
            } else if (groupIds != null) {
                for (String groupId : groupIds) {
                    this.addGroupFromCallbackOperation(groupId);
                }
            }
        } else {
            logger.debug("UserGroupCallback has not been registered.");
        }
    }

    private void addGroupFromCallbackOperation(String groupId) {
        try {
            if (!this.isEmpty(groupId) && this.em.find(Group.class, (Object)groupId) == null) {
                Group g = new Group(groupId);
                this.addGroup(g);
            }
        }
        catch (Throwable t) {
            logger.debug("Trying to add group " + groupId + ", but it already exists. ");
        }
    }

    private void addUserFromCallbackOperation(String userId) {
        try {
            if (!this.isEmpty(userId) && this.em.find(User.class, (Object)userId) == null) {
                User toCreateUser = new User(userId);
                this.addUser(toCreateUser);
            }
        }
        catch (Throwable t) {
            logger.debug("Unable to add user " + userId);
        }
    }

    private boolean isEmpty(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    private static interface TransactedOperation {
        public void doOperation();
    }
}

