/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.hornetq;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.jbpm.task.service.BaseHandler;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.hornetq.BaseHornetQHandler;
import org.jbpm.task.service.hornetq.HornetQTaskClientHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HornetQTaskClientConnector
implements TaskClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(HornetQTaskClientConnector.class);
    protected ClientSession session;
    protected final BaseHornetQHandler handler;
    protected final String name;
    protected AtomicInteger counter;
    private String address;
    private Integer port;
    private ServerLocator serverLocator;
    private ClientProducer producer;
    private ClientConsumer consumer;

    public HornetQTaskClientConnector(String name, BaseHornetQHandler handler) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = name;
        this.handler = handler;
        this.counter = new AtomicInteger();
    }

    public boolean connect(String address, int port) {
        this.port = port;
        this.address = address;
        return this.connect();
    }

    public boolean connect() {
        if (this.session != null && !this.session.isClosed()) {
            throw new IllegalStateException("Already connected. Disconnect first.");
        }
        try {
            HashMap<String, Object> connectionParams = new HashMap<String, Object>();
            if (this.address == null) {
                this.address = "127.0.0.1";
            }
            if (this.port == null) {
                this.port = 5445;
            }
            connectionParams.put("port", this.port);
            connectionParams.put("host", this.address);
            TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getCanonicalName(), connectionParams);
            this.serverLocator = HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
            ClientSessionFactory factory = this.serverLocator.createSessionFactory(transportConfiguration);
            this.session = factory.createSession();
            this.producer = this.session.createProducer("tasksQueue");
            this.createClientQueue();
            Thread responsesThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        HornetQTaskClientConnector.this.consumer = HornetQTaskClientConnector.this.session.createConsumer(HornetQTaskClientConnector.this.name);
                        while (true) {
                            ClientMessage serverMessage;
                            if ((serverMessage = HornetQTaskClientConnector.this.consumer.receive()) == null) {
                                continue;
                            }
                            ((HornetQTaskClientHandler)HornetQTaskClientConnector.this.handler).messageReceived(HornetQTaskClientConnector.this.session, HornetQTaskClientConnector.this.readMessage(serverMessage), "tasksQueue");
                        }
                    }
                    catch (HornetQException e) {
                        if (e.getCode() != 102) {
                            throw new RuntimeException("Client Exception with class " + this.getClass() + " using port " + HornetQTaskClientConnector.this.port, e);
                        }
                        logger.info(e.getMessage());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Client Exception with class " + this.getClass() + " using port " + HornetQTaskClientConnector.this.port, e);
                    }
                }
            });
            responsesThread.start();
            this.session.start();
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    private Object readMessage(ClientMessage serverMessage) throws IOException, ClassNotFoundException {
        int bodySize = serverMessage.getBodySize();
        byte[] message = new byte[bodySize];
        serverMessage.getBodyBuffer().readBytes(message);
        ByteArrayInputStream bais = new ByteArrayInputStream(message);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    private void createClientQueue() {
        try {
            this.session.createQueue(this.name, this.name, true);
        }
        catch (HornetQException e) {
            if (e.getCode() != 101) {
                throw new RuntimeException("Client Exception with class " + this.getClass() + " using port " + this.port, e);
            }
            logger.info(e.getMessage());
        }
    }

    public void disconnect() throws Exception {
        if (this.session != null && !this.session.isClosed()) {
            this.session.close();
            this.producer.close();
            if (this.consumer != null) {
                this.consumer.close();
            }
            this.serverLocator.close();
        }
    }

    public void write(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(baos);
            oout.writeObject(object);
            ClientMessage message = this.session.createMessage(true);
            message.getBodyBuffer().writeBytes(baos.toByteArray());
            message.putStringProperty("producerId", this.name);
            this.producer.send((Message)message);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating message", e);
        }
        catch (HornetQException e) {
            throw new RuntimeException("Error writing message", e);
        }
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public BaseHandler getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }
}

