/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.io.Resource;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierKnowledgeBaseBuilder {
    private List<VerifierError> errors = new ArrayList<VerifierError>();

    public KnowledgeBase newVerifierKnowledgeBase(VerifierConfiguration configuration) {
        KnowledgeBase verifierKnowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilderConfiguration kbuilderConfiguration = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        kbuilderConfiguration.setProperty("drools.dialect.java.compiler", "JANINO");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConfiguration);
        if (configuration.getVerifyingResources() != null) {
            for (Resource resource : configuration.getVerifyingResources().keySet()) {
                kbuilder.add(resource, configuration.getVerifyingResources().get(resource));
            }
        }
        if (kbuilder.hasErrors()) {
            Iterator errors = kbuilder.getErrors().iterator();
            while (errors.hasNext()) {
                this.errors.add(new VerifierError("Error compiling verifier rules: " + ((KnowledgeBuilderError)errors.next()).getMessage()));
            }
        }
        verifierKnowledgeBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return verifierKnowledgeBase;
    }

    public List<VerifierError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

