/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.client.WebDAVFactory;
import org.eclipse.webdav.http.client.BufferPool;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public abstract class Message {
    protected static BufferPool bufferPool = new BufferPool();
    protected InputStream is;
    protected boolean inputRead = false;
    protected boolean hasInputStream = false;
    protected IContext context;

    public Message(IContext context, InputStream is) {
        this.context = context;
        if (context == null) {
            this.context = WebDAVFactory.contextFactory.newContext();
        }
        this.is = is;
        if (is == null) {
            this.is = new ByteArrayInputStream(new byte[0]);
        }
    }

    public void close() throws IOException {
        this.is.close();
    }

    public long getContentLength() {
        long contentLength = this.context.getContentLength();
        if (contentLength != -1L) {
            return contentLength;
        }
        if (this.is instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)this.is).available();
        }
        return -1L;
    }

    public IContext getContext() {
        return this.context;
    }

    public InputStream getInputStream() {
        this.hasInputStream = true;
        return this.is;
    }

    public String toString() {
        return this.context.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(OutputStream os) throws IOException {
        Assert.isTrue(!this.inputRead);
        Assert.isTrue(!this.hasInputStream);
        int bytesRead = 0;
        int totalBytesRead = 0;
        byte[] buffer = bufferPool.getBuffer();
        long contentLength = this.getContentLength();
        try {
            while (bytesRead != -1 && (contentLength == -1L || contentLength > (long)totalBytesRead)) {
                bytesRead = contentLength == -1L ? this.is.read(buffer) : this.is.read(buffer, 0, (int)Math.min((long)buffer.length, contentLength - (long)totalBytesRead));
                if (bytesRead == -1) {
                    if (contentLength < 0L) continue;
                    throw new IOException(Policy.bind("exception.unexpectedEndStream"));
                }
                totalBytesRead += bytesRead;
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            bufferPool.putBuffer(buffer);
            this.inputRead = true;
            throw throwable;
        }
        {
            Object var7_8 = null;
            bufferPool.putBuffer(buffer);
            this.inputRead = true;
            return;
        }
    }
}

