/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.identity;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.jbpm.task.identity.UserGroupCallback;
import org.jbpm.task.identity.UserGroupCallbackManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAASUserGroupCallbackImpl
implements UserGroupCallback {
    private static final Logger logger = LoggerFactory.getLogger(JAASUserGroupCallbackImpl.class);
    protected static final String DEFAULT_PROPERTIES_NAME = "/jbpm.usergroup.callback.properties";
    private String rolePrincipleName = null;

    public JAASUserGroupCallbackImpl() {
        this("Roles");
        InputStream in;
        String propertiesLocation = System.getProperty("jbpm.usergroup.callback.properties");
        if (propertiesLocation == null) {
            propertiesLocation = DEFAULT_PROPERTIES_NAME;
        }
        if ((in = this.getClass().getResourceAsStream(propertiesLocation)) != null) {
            Properties config = new Properties();
            try {
                config.load(in);
                this.rolePrincipleName = config.getProperty("jaas.role.principle.name");
            }
            catch (IOException e) {
                logger.error("Error when loading properties for DB user group callback", (Throwable)e);
                Object var3_3 = null;
            }
        }
    }

    public JAASUserGroupCallbackImpl(String rolesPrincipleName) {
        this.rolePrincipleName = rolesPrincipleName;
        UserGroupCallbackManager.getInstance().setProperty("disable.all.groups", "true");
    }

    public String getRolePrincipleName() {
        return this.rolePrincipleName;
    }

    public void setRolePrincipleName(String rolePrincipleName) {
        this.rolePrincipleName = rolePrincipleName;
    }

    @Override
    public boolean existsUser(String userId) {
        return true;
    }

    @Override
    public boolean existsGroup(String groupId) {
        return true;
    }

    @Override
    public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
        ArrayList<String> roles;
        block4: {
            roles = null;
            try {
                Set<Principal> principals;
                Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
                if (subject == null || (principals = subject.getPrincipals()) == null) break block4;
                roles = new ArrayList<String>();
                for (Principal principal : principals) {
                    if (!(principal instanceof Group) || !this.rolePrincipleName.equalsIgnoreCase(principal.getName())) continue;
                    Enumeration groups = ((Group)principal).members();
                    while (groups.hasMoreElements()) {
                        Principal groupPrincipal = (Principal)groups.nextElement();
                        roles.add(groupPrincipal.getName());
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Error when getting user roles, userid:" + userId, (Throwable)e);
            }
        }
        return roles;
    }
}

