/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.refactoring;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.refactoring.DRLProjectDetector;
import org.drools.eclipse.refactoring.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RuleSourceFieldRenameParticipant
extends RenameParticipant {
    public static final String NAME = "Rule Source Field Rename Refactoring";
    private static final String FIELD_NAME = "(?<=[!\\(:\\s])FIELD_NAME(?=[\\s=\\),\\.<>!])";
    private static final String VARIABLE_ASSIGNED = "[\\w]*(?=\\s*:\\s*TYPE\\s*\\()";
    private static final String GETTER_NAME = "(?<=VARIABLE_NAME\\.)CURRENT_GETTER_NAME(?=\\s*\\()";
    private static final String SETTER_NAME = "(?<=VARIABLE_NAME\\.)CURRENT_SETTER_NAME(?=\\s*\\()";
    private DRLProjectDetector drlProjectDetector = new DRLProjectDetector();
    private RefactoringProcessor processor;
    private List<IFile> drlFiles;
    private SourceField sourceField;
    private String newName;
    private String currentName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            Pattern pattern;
            Matcher matcher;
            IFile file = this.getSourceFieldIFile();
            if (file == null) return status;
            if (file.isReadOnly()) {
                return status;
            }
            this.drlFiles = this.drlProjectDetector.detect(file.getProject());
            String content = null;
            Iterator<IFile> iterator = this.drlFiles.iterator();
            do {
                if (!iterator.hasNext()) {
                    return status;
                }
                IFile drlFile = iterator.next();
                content = FileUtil.readFile(drlFile);
                if (content != null) continue;
                return null;
            } while (!(matcher = (pattern = Pattern.compile("(?<=:\\s)" + this.currentName + "|" + this.currentName + "(?=\\s=)")).matcher(content)).find());
            RenameFieldProcessor renameFieldProcessor = (RenameFieldProcessor)this.processor;
            if (renameFieldProcessor.getRenameGetter()) return status;
            status.addInfo("The getter must be also updated to refactor the DRL files.");
            return status;
        }
        catch (CoreException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange changes = null;
        changes = new CompositeChange("Fix " + this.currentName + " field on DRL files");
        IFile file = this.getSourceFieldIFile();
        String typeName = this.sourceField.getParent().getElementName();
        Pattern fieldPattern = Pattern.compile(FIELD_NAME.replaceAll("FIELD_NAME", this.currentName));
        Pattern typePattern = Pattern.compile(VARIABLE_ASSIGNED.replace("TYPE", typeName));
        if (file != null) {
            RenameFieldProcessor renameFieldProcessor = (RenameFieldProcessor)this.processor;
            for (IFile drlFile : this.drlFiles) {
                String content = FileUtil.readFile(drlFile);
                if (content == null) {
                    return null;
                }
                TextFileChange change = new TextFileChange(drlFile.getName(), drlFile);
                MultiTextEdit mte = new MultiTextEdit();
                change.setEdit((TextEdit)mte);
                Matcher matcher = fieldPattern.matcher(content);
                while (matcher.find()) {
                    if (!this.isFieldInRightType(content, typeName, matcher.start())) continue;
                    ReplaceEdit replace = new ReplaceEdit(matcher.start(), this.currentName.length(), this.newName);
                    mte.addChild((TextEdit)replace);
                }
                matcher = typePattern.matcher(content);
                while (matcher.find()) {
                    String regexp;
                    if (matcher.group().length() <= 0) continue;
                    String variableNameAssigned = matcher.group();
                    if (renameFieldProcessor.getRenameGetter()) {
                        String newGetterName = renameFieldProcessor.getNewGetterName();
                        String currentGetterName = renameFieldProcessor.getGetter().getElementName();
                        regexp = GETTER_NAME.replace("VARIABLE_NAME", variableNameAssigned).replace("CURRENT_GETTER_NAME", currentGetterName);
                        this.createFieldRenameChanges(mte, content, regexp, currentGetterName, newGetterName);
                    }
                    if (!renameFieldProcessor.getRenameSetter()) continue;
                    String newSetterName = renameFieldProcessor.getNewSetterName();
                    String currentSetterName = renameFieldProcessor.getSetter().getElementName();
                    regexp = SETTER_NAME.replace("VARIABLE_NAME", variableNameAssigned).replace("CURRENT_SETTER_NAME", currentSetterName);
                    this.createFieldRenameChanges(mte, content, regexp, currentSetterName, newSetterName);
                }
                if (change.getEdit().getChildrenSize() <= 0) continue;
                changes.add((Change)change);
            }
        }
        return changes.getChildren().length > 0 ? changes : null;
    }

    private boolean isFieldInRightType(String content, String typeName, int offset) {
        int lastTypeOccurence = content.lastIndexOf(typeName, offset);
        if (lastTypeOccurence < 0) {
            return false;
        }
        int typeConstraintsStart = content.indexOf(40, lastTypeOccurence);
        if (typeConstraintsStart < 0 || typeConstraintsStart > offset) {
            return false;
        }
        String s = content.substring(lastTypeOccurence, typeConstraintsStart);
        if (s.indexOf("global") >= 0 || s.indexOf("function") >= 0) {
            return false;
        }
        int parenthesisCounter = 1;
        int typeConstraintsEnd = typeConstraintsStart + 1;
        while (parenthesisCounter != 0 && typeConstraintsEnd < content.length()) {
            if (content.charAt(typeConstraintsEnd) == '(') {
                ++parenthesisCounter;
            } else if (content.charAt(typeConstraintsEnd) == ')') {
                --parenthesisCounter;
            }
            ++typeConstraintsEnd;
        }
        return typeConstraintsEnd < content.length() && typeConstraintsEnd > offset;
    }

    private void createFieldRenameChanges(MultiTextEdit mte, String content, String regexp, String currentName, String newName) {
        Pattern pattern = Pattern.compile(regexp);
        Matcher setterMatcher = pattern.matcher(content);
        ReplaceEdit replace = null;
        while (setterMatcher.find()) {
            replace = new ReplaceEdit(setterMatcher.start(), currentName.length(), newName);
            mte.addChild((TextEdit)replace);
        }
    }

    public String getName() {
        return NAME;
    }

    private IFile getSourceFieldIFile() {
        try {
            SearchResultGroup[] object;
            Field fReferences = this.processor.getClass().getDeclaredField("fReferences");
            fReferences.setAccessible(true);
            SearchResultGroup[] searchResultGroupArray = object = (SearchResultGroup[])fReferences.get(this.processor);
            int n = object.length;
            int n2 = 0;
            while (n2 < n) {
                SearchResultGroup searchResultGroup = searchResultGroupArray[n2];
                if (searchResultGroup.getResource() instanceof IFile) {
                    return (IFile)searchResultGroup.getResource();
                }
                ++n2;
            }
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        return null;
    }

    protected boolean initialize(Object element) {
        if (element instanceof SourceField) {
            this.sourceField = (SourceField)element;
            this.processor = this.getProcessor();
            if (this.processor instanceof JavaRenameProcessor) {
                this.newName = ((JavaRenameProcessor)this.processor).getNewElementName();
                this.currentName = ((JavaRenameProcessor)this.processor).getCurrentElementName();
                return true;
            }
        }
        return false;
    }
}

