/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.utils.UUID;

public abstract class NodeManager
implements HornetQComponent {
    private boolean isStarted = false;
    protected volatile SimpleString nodeID;
    protected volatile UUID uuid;

    public abstract void awaitLiveNode() throws Exception;

    public abstract void startBackup() throws Exception;

    public abstract void startLiveNode() throws Exception;

    public abstract void pauseLiveServer() throws Exception;

    public abstract void crashLiveServer() throws Exception;

    public abstract void stopBackup() throws Exception;

    public abstract void releaseBackup() throws Exception;

    @Override
    public void start() throws Exception {
        this.isStarted = true;
    }

    @Override
    public void stop() throws Exception {
        this.isStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    public SimpleString getNodeId() {
        return this.nodeID;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public abstract boolean isAwaitingFailback() throws Exception;

    public abstract boolean isBackupLive() throws Exception;

    public abstract void interrupt();
}

