/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.settings.impl;

import java.io.Serializable;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.settings.Mergeable;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.utils.BufferHelper;

public class AddressSettings
implements Mergeable<AddressSettings>,
Serializable,
EncodingSupport {
    private static final long serialVersionUID = 1607502280582336366L;
    private static Logger log = Logger.getLogger(AddressSettings.class);
    public static final long DEFAULT_MAX_SIZE_BYTES = -1L;
    public static final AddressFullMessagePolicy DEFAULT_ADDRESS_FULL_MESSAGE_POLICY = AddressFullMessagePolicy.PAGE;
    public static final long DEFAULT_PAGE_SIZE = 0xA00000L;
    public static final int DEFAULT_MAX_DELIVERY_ATTEMPTS = 10;
    public static final int DEFAULT_PAGE_MAX_CACHE = 5;
    public static final int DEFAULT_MESSAGE_COUNTER_HISTORY_DAY_LIMIT = 0;
    public static final long DEFAULT_REDELIVER_DELAY = 0L;
    public static final boolean DEFAULT_LAST_VALUE_QUEUE = false;
    public static final long DEFAULT_REDISTRIBUTION_DELAY = -1L;
    public static final boolean DEFAULT_SEND_TO_DLA_ON_NO_ROUTE = false;
    private AddressFullMessagePolicy addressFullMessagePolicy = null;
    private Long maxSizeBytes = null;
    private Long pageSizeBytes = null;
    private Integer pageMaxCache = null;
    private Boolean dropMessagesWhenFull = null;
    private Integer maxDeliveryAttempts = null;
    private Integer messageCounterHistoryDayLimit = null;
    private Long redeliveryDelay = null;
    private SimpleString deadLetterAddress = null;
    private SimpleString expiryAddress = null;
    private Boolean lastValueQueue = null;
    private Long redistributionDelay = null;
    private Boolean sendToDLAOnNoRoute = null;

    public boolean isLastValueQueue() {
        return this.lastValueQueue != null ? this.lastValueQueue : false;
    }

    public void setLastValueQueue(boolean lastValueQueue) {
        this.lastValueQueue = lastValueQueue;
    }

    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy != null ? this.addressFullMessagePolicy : DEFAULT_ADDRESS_FULL_MESSAGE_POLICY;
    }

    public void setAddressFullMessagePolicy(AddressFullMessagePolicy addressFullMessagePolicy) {
        this.addressFullMessagePolicy = addressFullMessagePolicy;
    }

    public long getPageSizeBytes() {
        return this.pageSizeBytes != null ? this.pageSizeBytes : 0xA00000L;
    }

    public void setPageSizeBytes(long pageSize) {
        this.pageSizeBytes = pageSize;
    }

    public int getPageCacheMaxSize() {
        return this.pageMaxCache != null ? this.pageMaxCache : 5;
    }

    public void setPageCacheMaxSize(int pageMaxCache) {
        this.pageMaxCache = pageMaxCache;
    }

    public long getMaxSizeBytes() {
        return this.maxSizeBytes != null ? this.maxSizeBytes : -1L;
    }

    public void setMaxSizeBytes(long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
    }

    public int getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts != null ? this.maxDeliveryAttempts : 10;
    }

    public void setMaxDeliveryAttempts(int maxDeliveryAttempts) {
        this.maxDeliveryAttempts = maxDeliveryAttempts;
    }

    public int getMessageCounterHistoryDayLimit() {
        return this.messageCounterHistoryDayLimit != null ? this.messageCounterHistoryDayLimit : 0;
    }

    public void setMessageCounterHistoryDayLimit(int messageCounterHistoryDayLimit) {
        this.messageCounterHistoryDayLimit = messageCounterHistoryDayLimit;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay != null ? this.redeliveryDelay : 0L;
    }

    public void setRedeliveryDelay(long redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
    }

    public SimpleString getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    public void setDeadLetterAddress(SimpleString deadLetterAddress) {
        this.deadLetterAddress = deadLetterAddress;
    }

    public SimpleString getExpiryAddress() {
        return this.expiryAddress;
    }

    public void setExpiryAddress(SimpleString expiryAddress) {
        this.expiryAddress = expiryAddress;
    }

    public boolean isSendToDLAOnNoRoute() {
        return this.sendToDLAOnNoRoute != null ? this.sendToDLAOnNoRoute : false;
    }

    public void setSendToDLAOnNoRoute(boolean value) {
        this.sendToDLAOnNoRoute = value;
    }

    public long getRedistributionDelay() {
        return this.redistributionDelay != null ? this.redistributionDelay : -1L;
    }

    public void setRedistributionDelay(long redistributionDelay) {
        this.redistributionDelay = redistributionDelay;
    }

    @Override
    public void merge(AddressSettings merged) {
        if (this.maxDeliveryAttempts == null) {
            this.maxDeliveryAttempts = merged.maxDeliveryAttempts;
        }
        if (this.dropMessagesWhenFull == null) {
            this.dropMessagesWhenFull = merged.dropMessagesWhenFull;
        }
        if (this.maxSizeBytes == null) {
            this.maxSizeBytes = merged.maxSizeBytes;
        }
        if (this.pageMaxCache == null) {
            this.pageMaxCache = merged.pageMaxCache;
        }
        if (this.pageSizeBytes == null) {
            this.pageSizeBytes = merged.getPageSizeBytes();
        }
        if (this.messageCounterHistoryDayLimit == null) {
            this.messageCounterHistoryDayLimit = merged.messageCounterHistoryDayLimit;
        }
        if (this.redeliveryDelay == null) {
            this.redeliveryDelay = merged.redeliveryDelay;
        }
        if (this.deadLetterAddress == null) {
            this.deadLetterAddress = merged.deadLetterAddress;
        }
        if (this.expiryAddress == null) {
            this.expiryAddress = merged.expiryAddress;
        }
        if (this.redistributionDelay == null) {
            this.redistributionDelay = merged.redistributionDelay;
        }
        if (this.sendToDLAOnNoRoute == null) {
            this.sendToDLAOnNoRoute = merged.sendToDLAOnNoRoute;
        }
        if (this.addressFullMessagePolicy == null) {
            this.addressFullMessagePolicy = merged.addressFullMessagePolicy;
        }
    }

    @Override
    public void decode(HornetQBuffer buffer) {
        SimpleString policyStr = buffer.readNullableSimpleString();
        this.addressFullMessagePolicy = policyStr != null ? AddressFullMessagePolicy.valueOf(policyStr.toString()) : null;
        this.maxSizeBytes = BufferHelper.readNullableLong(buffer);
        this.pageSizeBytes = BufferHelper.readNullableLong(buffer);
        this.pageMaxCache = BufferHelper.readNullableInteger(buffer);
        this.dropMessagesWhenFull = BufferHelper.readNullableBoolean(buffer);
        this.maxDeliveryAttempts = BufferHelper.readNullableInteger(buffer);
        this.messageCounterHistoryDayLimit = BufferHelper.readNullableInteger(buffer);
        this.redeliveryDelay = BufferHelper.readNullableLong(buffer);
        this.deadLetterAddress = buffer.readNullableSimpleString();
        this.expiryAddress = buffer.readNullableSimpleString();
        this.lastValueQueue = BufferHelper.readNullableBoolean(buffer);
        this.redistributionDelay = BufferHelper.readNullableLong(buffer);
        this.sendToDLAOnNoRoute = BufferHelper.readNullableBoolean(buffer);
    }

    @Override
    public int getEncodeSize() {
        return BufferHelper.sizeOfNullableSimpleString(this.addressFullMessagePolicy != null ? this.addressFullMessagePolicy.toString() : null) + BufferHelper.sizeOfNullableLong(this.maxSizeBytes) + BufferHelper.sizeOfNullableLong(this.pageSizeBytes) + BufferHelper.sizeOfNullableInteger(this.pageMaxCache) + BufferHelper.sizeOfNullableBoolean(this.dropMessagesWhenFull) + BufferHelper.sizeOfNullableInteger(this.maxDeliveryAttempts) + BufferHelper.sizeOfNullableInteger(this.messageCounterHistoryDayLimit) + BufferHelper.sizeOfNullableLong(this.redeliveryDelay) + SimpleString.sizeofNullableString(this.deadLetterAddress) + SimpleString.sizeofNullableString(this.expiryAddress) + BufferHelper.sizeOfNullableBoolean(this.lastValueQueue) + BufferHelper.sizeOfNullableLong(this.redistributionDelay) + BufferHelper.sizeOfNullableBoolean(this.sendToDLAOnNoRoute);
    }

    @Override
    public void encode(HornetQBuffer buffer) {
        buffer.writeNullableSimpleString(this.addressFullMessagePolicy != null ? new SimpleString(this.addressFullMessagePolicy.toString()) : null);
        BufferHelper.writeNullableLong(buffer, this.maxSizeBytes);
        BufferHelper.writeNullableLong(buffer, this.pageSizeBytes);
        BufferHelper.writeNullableInteger(buffer, this.pageMaxCache);
        BufferHelper.writeNullableBoolean(buffer, this.dropMessagesWhenFull);
        BufferHelper.writeNullableInteger(buffer, this.maxDeliveryAttempts);
        BufferHelper.writeNullableInteger(buffer, this.messageCounterHistoryDayLimit);
        BufferHelper.writeNullableLong(buffer, this.redeliveryDelay);
        buffer.writeNullableSimpleString(this.deadLetterAddress);
        buffer.writeNullableSimpleString(this.expiryAddress);
        BufferHelper.writeNullableBoolean(buffer, this.lastValueQueue);
        BufferHelper.writeNullableLong(buffer, this.redistributionDelay);
        BufferHelper.writeNullableBoolean(buffer, this.sendToDLAOnNoRoute);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addressFullMessagePolicy == null ? 0 : this.addressFullMessagePolicy.hashCode());
        result = 31 * result + (this.deadLetterAddress == null ? 0 : this.deadLetterAddress.hashCode());
        result = 31 * result + (this.dropMessagesWhenFull == null ? 0 : this.dropMessagesWhenFull.hashCode());
        result = 31 * result + (this.expiryAddress == null ? 0 : this.expiryAddress.hashCode());
        result = 31 * result + (this.lastValueQueue == null ? 0 : this.lastValueQueue.hashCode());
        result = 31 * result + (this.maxDeliveryAttempts == null ? 0 : this.maxDeliveryAttempts.hashCode());
        result = 31 * result + (this.maxSizeBytes == null ? 0 : this.maxSizeBytes.hashCode());
        result = 31 * result + (this.messageCounterHistoryDayLimit == null ? 0 : this.messageCounterHistoryDayLimit.hashCode());
        result = 31 * result + (this.pageSizeBytes == null ? 0 : this.pageSizeBytes.hashCode());
        result = 31 * result + (this.pageMaxCache == null ? 0 : this.pageMaxCache.hashCode());
        result = 31 * result + (this.redeliveryDelay == null ? 0 : this.redeliveryDelay.hashCode());
        result = 31 * result + (this.redistributionDelay == null ? 0 : this.redistributionDelay.hashCode());
        result = 31 * result + (this.sendToDLAOnNoRoute == null ? 0 : this.sendToDLAOnNoRoute.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressSettings other = (AddressSettings)obj;
        if (this.addressFullMessagePolicy == null ? other.addressFullMessagePolicy != null : !this.addressFullMessagePolicy.equals((Object)other.addressFullMessagePolicy)) {
            return false;
        }
        if (this.deadLetterAddress == null ? other.deadLetterAddress != null : !this.deadLetterAddress.equals(other.deadLetterAddress)) {
            return false;
        }
        if (this.dropMessagesWhenFull == null ? other.dropMessagesWhenFull != null : !this.dropMessagesWhenFull.equals(other.dropMessagesWhenFull)) {
            return false;
        }
        if (this.expiryAddress == null ? other.expiryAddress != null : !this.expiryAddress.equals(other.expiryAddress)) {
            return false;
        }
        if (this.lastValueQueue == null ? other.lastValueQueue != null : !this.lastValueQueue.equals(other.lastValueQueue)) {
            return false;
        }
        if (this.maxDeliveryAttempts == null ? other.maxDeliveryAttempts != null : !this.maxDeliveryAttempts.equals(other.maxDeliveryAttempts)) {
            return false;
        }
        if (this.maxSizeBytes == null ? other.maxSizeBytes != null : !this.maxSizeBytes.equals(other.maxSizeBytes)) {
            return false;
        }
        if (this.messageCounterHistoryDayLimit == null ? other.messageCounterHistoryDayLimit != null : !this.messageCounterHistoryDayLimit.equals(other.messageCounterHistoryDayLimit)) {
            return false;
        }
        if (this.pageSizeBytes == null ? other.pageSizeBytes != null : !this.pageSizeBytes.equals(other.pageSizeBytes)) {
            return false;
        }
        if (this.pageMaxCache == null ? other.pageMaxCache != null : !this.pageMaxCache.equals(other.pageMaxCache)) {
            return false;
        }
        if (this.redeliveryDelay == null ? other.redeliveryDelay != null : !this.redeliveryDelay.equals(other.redeliveryDelay)) {
            return false;
        }
        if (this.redistributionDelay == null ? other.redistributionDelay != null : !this.redistributionDelay.equals(other.redistributionDelay)) {
            return false;
        }
        return !(this.sendToDLAOnNoRoute == null ? other.sendToDLAOnNoRoute != null : !this.sendToDLAOnNoRoute.equals(other.sendToDLAOnNoRoute));
    }

    public String toString() {
        return "AddressSettings [addressFullMessagePolicy=" + (Object)((Object)this.addressFullMessagePolicy) + ", deadLetterAddress=" + this.deadLetterAddress + ", dropMessagesWhenFull=" + this.dropMessagesWhenFull + ", expiryAddress=" + this.expiryAddress + ", lastValueQueue=" + this.lastValueQueue + ", maxDeliveryAttempts=" + this.maxDeliveryAttempts + ", maxSizeBytes=" + this.maxSizeBytes + ", messageCounterHistoryDayLimit=" + this.messageCounterHistoryDayLimit + ", pageSizeBytes=" + this.pageSizeBytes + ", pageMaxCache=" + this.pageMaxCache + ", redeliveryDelay=" + this.redeliveryDelay + ", redistributionDelay=" + this.redistributionDelay + ", sendToDLAOnNoRoute=" + this.sendToDLAOnNoRoute + "]";
    }
}

