/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.hornetq;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.jbpm.task.service.BaseClientHandler;
import org.jbpm.task.service.BaseHandler;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.hornetq.HornetQTaskClientHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HornetQTaskClientConnector
implements TaskClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(HornetQTaskClientConnector.class);
    protected ClientSession session;
    protected final BaseClientHandler handler;
    protected final String name;
    protected AtomicInteger counter;
    private String address;
    private Integer port;
    private ServerLocator serverLocator;
    private ClientProducer producer;
    private ClientConsumer consumer;
    private Thread responsesThread;

    public HornetQTaskClientConnector(String name, BaseClientHandler handler) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = name;
        this.handler = handler;
        this.counter = new AtomicInteger();
    }

    public boolean connect(String address, int port) {
        this.port = port;
        this.address = address;
        return this.connect();
    }

    public boolean connect() {
        if (this.session != null && !this.session.isClosed()) {
            throw new IllegalStateException("Already connected. Disconnect first.");
        }
        try {
            HashMap<String, Object> connectionParams = new HashMap<String, Object>();
            if (this.address == null) {
                this.address = "127.0.0.1";
            }
            if (this.port == null) {
                this.port = 5445;
            }
            connectionParams.put("port", this.port);
            connectionParams.put("host", this.address);
            TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getCanonicalName(), connectionParams);
            this.serverLocator = HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
            ClientSessionFactory factory = this.serverLocator.createSessionFactory(transportConfiguration);
            this.session = factory.createSession();
            this.producer = this.session.createProducer("tasksQueue");
            this.createClientQueue();
            this.responsesThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        HornetQTaskClientConnector.this.consumer = HornetQTaskClientConnector.this.session.createConsumer(HornetQTaskClientConnector.this.name);
                    }
                    catch (HornetQException e) {
                        logger.error("Error creating consumer. ", (Throwable)e);
                        if (e.getCode() == 102) {
                            logger.info(e.getMessage());
                            return;
                        }
                        throw new RuntimeException("Client Exception with class " + this.getClass() + " using port " + HornetQTaskClientConnector.this.port, e);
                    }
                    while (!HornetQTaskClientConnector.this.consumer.isClosed()) {
                        try {
                            ClientMessage serverMessage = HornetQTaskClientConnector.this.consumer.receive();
                            if (serverMessage == null) continue;
                            ((HornetQTaskClientHandler)HornetQTaskClientConnector.this.handler).messageReceived(HornetQTaskClientConnector.this.session, HornetQTaskClientConnector.this.readMessage(serverMessage), "tasksQueue");
                        }
                        catch (HornetQException e) {
                            if (e.getCode() == 102) {
                                try {
                                    logger.warn("Connection lost, trying to reconnect...");
                                    HornetQTaskClientConnector.this.disconnect();
                                    HornetQTaskClientConnector.this.connect();
                                    continue;
                                }
                                catch (Exception e1) {
                                    logger.error("Reconnecting failed, exiting...", (Throwable)e);
                                    return;
                                }
                            }
                            logger.error("HornetQ Exception with class " + this.getClass() + " using port " + HornetQTaskClientConnector.this.port, (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.error("Client Exception with class " + this.getClass() + " using port " + HornetQTaskClientConnector.this.port, (Throwable)e);
                        }
                    }
                }
            });
            this.responsesThread.start();
            this.session.start();
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    private Object readMessage(ClientMessage serverMessage) throws IOException, ClassNotFoundException {
        int bodySize = serverMessage.getBodySize();
        byte[] message = new byte[bodySize];
        serverMessage.getBodyBuffer().readBytes(message);
        ByteArrayInputStream bais = new ByteArrayInputStream(message);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    private void createClientQueue() {
        try {
            this.session.createQueue(this.name, this.name, true);
        }
        catch (HornetQException e) {
            if (e.getCode() != 101) {
                throw new RuntimeException("Client Exception with class " + this.getClass() + " using port " + this.port, e);
            }
            logger.info(e.getMessage());
        }
    }

    public void disconnect() throws Exception {
        if (this.session != null && !this.session.isClosed()) {
            this.session.close();
            this.producer.close();
            if (this.consumer != null) {
                this.consumer.close();
            }
            this.serverLocator.close();
            this.responsesThread.interrupt();
        }
    }

    public void write(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(baos);
            oout.writeObject(object);
            ClientMessage message = this.session.createMessage(true);
            message.getBodyBuffer().writeBytes(baos.toByteArray());
            message.putStringProperty("producerId", this.name);
            this.producer.send((Message)message);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating message", e);
        }
        catch (HornetQException e) {
            if (e.getCode() == 102) {
                try {
                    logger.warn("Connection lost, trying to reconnect...");
                    this.disconnect();
                    boolean connected = this.connect();
                    if (!connected) {
                        throw e;
                    }
                    this.write(object);
                }
                catch (Exception e1) {
                    throw new RuntimeException("Error writing message (Reconnecting failed, exiting...)", e);
                }
            }
            throw new RuntimeException("Error writing message", e);
        }
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public BaseHandler getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }
}

