/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.http.client.ISocketFactory;
import org.eclipse.webdav.http.client.IStatusCodes;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class HttpConnection
implements IStatusCodes {
    private double httpVersion = 1.1;
    private String method = "GET";
    private URL resourceUrl = null;
    private URL proxyServerUrl = null;
    protected Header requestHeader = new Header();
    protected Header responseHeader = new Header();
    protected Header internalHeader = new Header();
    private int statusCode;
    private String statusMessage;
    private ISocketFactory socketFactory = null;
    private Socket socket = null;
    private int receiveBufferSize = 0;
    private int sendBufferSize = 0;
    private int soLinger = -1;
    private int soTimeout = 0;
    private boolean tcpNoDelay = false;
    protected InputStream socketIn = null;
    protected OutputStream socketOut = null;
    private InputStream is = null;
    private OutputStream os = null;
    private boolean closeConnection;
    private boolean persistent = true;
    private boolean sendChunked = true;
    private boolean connected = false;
    private boolean sentRequest = false;
    private Date timestamp = null;

    public HttpConnection(URL resourceUrl) {
        Assert.isNotNull(resourceUrl);
        this.resourceUrl = resourceUrl;
    }

    public HttpConnection(URL proxyServerUrl, URL resourceUrl) {
        Assert.isNotNull(proxyServerUrl);
        Assert.isNotNull(resourceUrl);
        this.proxyServerUrl = proxyServerUrl;
        this.resourceUrl = resourceUrl;
    }

    public void clearRequestHeader() {
        this.endRequest();
        this.requestHeader.clear();
    }

    public void close() throws IOException {
        this.endRequest();
        if (this.connected) {
            this.connected = false;
            this.socket.close();
        }
    }

    private void connect() throws IOException {
        if (!this.connected) {
            int port;
            String host;
            String protocol;
            if (this.proxyServerUrl == null) {
                protocol = this.resourceUrl.getProtocol();
                host = this.resourceUrl.getHost();
                port = this.getPort(this.resourceUrl);
            } else {
                protocol = this.proxyServerUrl.getProtocol();
                host = this.proxyServerUrl.getHost();
                port = this.getPort(this.proxyServerUrl);
            }
            this.socket = this.socketFactory == null ? new Socket(host, port) : this.socketFactory.createSocket(protocol, host, port);
            if (this.receiveBufferSize > 0) {
                this.socket.setReceiveBufferSize(this.receiveBufferSize);
            }
            if (this.sendBufferSize > 0) {
                this.socket.setSendBufferSize(this.sendBufferSize);
            }
            this.socket.setSoLinger(this.soLinger >= 0, this.soLinger >= 0 ? this.soLinger : 0);
            this.socket.setSoTimeout(this.soTimeout);
            this.socket.setTcpNoDelay(this.tcpNoDelay);
            this.socketOut = new BufferedOutputStream(this.socket.getOutputStream());
            this.socketIn = new BufferedInputStream(this.socket.getInputStream());
            this.closeConnection = this.httpVersion == 1.0 || !this.persistent;
            this.connected = true;
        }
    }

    private void endRequest() {
        if (this.sentRequest) {
            boolean failed = false;
            if (this.os != null) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    failed = true;
                }
            }
            try {
                this.getInputStream().close();
            }
            catch (IOException iOException) {
                failed = true;
            }
            this.sentRequest = false;
            if (this.closeConnection || failed) {
                try {
                    this.connected = false;
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.os = null;
        this.is = null;
        this.internalHeader.clear();
    }

    public double getHttpVersion() {
        return this.httpVersion;
    }

    public InputStream getInputStream() throws IOException {
        if (this.is != null) {
            return this.is;
        }
        this.sendRequest();
        String transferEncoding = this.responseHeader.getFieldValue("Transfer-Encoding");
        String contentLength = this.responseHeader.getFieldValue("Content-Length");
        if ("chunked".equalsIgnoreCase(transferEncoding)) {
            this.is = new ChunkedInputStream();
        } else if (this.method.equals("HEAD") && this.statusCode == 200) {
            this.is = new LimitedInputStream(0);
        } else if (contentLength != null) {
            try {
                this.is = new LimitedInputStream(Integer.parseInt(contentLength));
            }
            catch (NumberFormatException e) {
                throw new IOException(e.getMessage());
            }
        } else if (this.statusCode >= 100 && this.statusCode < 200 || this.statusCode == 204 || this.statusCode == 304) {
            this.is = new LimitedInputStream(0);
        } else {
            this.closeConnection = true;
            this.is = this.socketIn;
        }
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os != null) {
            return this.os;
        }
        String contentLength = this.requestHeader.getFieldValue("Content-Length");
        if (this.sendChunked && this.httpVersion > 1.0) {
            this.os = new ChunkedOutputStream();
        } else if (contentLength != null) {
            try {
                this.os = new LimitedOutputStream(Integer.parseInt(contentLength));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(Policy.bind("exception.malformedContentLength"));
            }
        } else {
            this.os = new CachedOutputStream();
            return this.os;
        }
        this.sendRequest();
        return this.os;
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    private int getPort(URL url) {
        String protocol = url.getProtocol();
        int port = url.getPort();
        if (port == -1) {
            if (protocol.equals("http")) {
                return 80;
            }
            if (protocol.equals("https")) {
                return 443;
            }
            return -1;
        }
        return port;
    }

    public URL getProxyServerUrl() {
        return this.proxyServerUrl;
    }

    public int getReceiveBufferSize() throws IOException {
        if (this.connected) {
            return this.socket.getReceiveBufferSize();
        }
        return this.receiveBufferSize;
    }

    public String getRequestHeaderFieldValue(String fieldName) {
        Assert.isNotNull(fieldName);
        return this.requestHeader.getFieldValue(fieldName);
    }

    public String getRequestMethod() {
        return this.method;
    }

    public URL getResourceUrl() {
        return this.resourceUrl;
    }

    public String getResponseHeaderFieldName(int position) throws IOException {
        Assert.isTrue(position >= 0);
        this.sendRequest();
        return this.responseHeader.getFieldName(position);
    }

    public String getResponseHeaderFieldValue(int position) throws IOException {
        Assert.isTrue(position >= 0);
        this.sendRequest();
        return this.responseHeader.getFieldValue(position);
    }

    public String getResponseHeaderFieldValue(String fieldName) throws IOException {
        Assert.isNotNull(fieldName);
        this.sendRequest();
        return this.responseHeader.getFieldValue(fieldName);
    }

    public int getSendBufferSize() throws IOException {
        if (this.connected) {
            return this.socket.getSendBufferSize();
        }
        return this.sendBufferSize;
    }

    public boolean getSendChunked() {
        return this.sendChunked;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getStatusCode() throws IOException {
        this.sendRequest();
        return this.statusCode;
    }

    public String getStatusMessage() throws IOException {
        this.sendRequest();
        return this.statusMessage;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    protected void output(OutputStream stream, String output) throws IOException {
        stream.write(output.getBytes("UTF8"));
    }

    protected void readHeader(Header header) throws IOException {
        String line = null;
        while ((line = this.readln()).length() > 0) {
            int index = line.indexOf(":");
            if (index < 0) {
                throw new IOException(Policy.bind("exception.malformedHeaderField"));
            }
            String fieldName = line.substring(0, index);
            String fieldValue = line.substring(index + 1).trim();
            header.addField(fieldName, fieldValue);
        }
        String fieldValue = header.getFieldValue("Connection");
        if (fieldValue != null && fieldValue.equalsIgnoreCase("close")) {
            this.closeConnection = true;
        }
    }

    protected String readln() throws IOException {
        boolean foundCR = false;
        StringBuffer result = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.socketIn.read()) < 0) {
                throw new IOException(Policy.bind("exception.unexpectedEndStream"));
            }
            if (foundCR) {
                if (c == 10) break;
                result.append('\r');
            }
            if (c == 13) {
                foundCR = true;
                continue;
            }
            result.append((char)c);
        }
        return result.toString();
    }

    protected void readServerResponse() throws IOException {
        double protocolVersion;
        this.socketOut.flush();
        String statusLine = this.readln();
        if (!statusLine.startsWith("HTTP/")) {
            throw new IOException(Policy.bind("exception.malformedStatusLine"));
        }
        int firstSpace = statusLine.indexOf(32, 5);
        if (firstSpace == -1) {
            throw new IOException(Policy.bind("exception.malformedStatusLine"));
        }
        int secondSpace = statusLine.indexOf(32, firstSpace + 1);
        if (secondSpace == -1) {
            throw new IOException(Policy.bind("exception.malformedStatusLine"));
        }
        try {
            protocolVersion = Double.parseDouble(statusLine.substring(5, firstSpace));
            this.statusCode = Integer.parseInt(statusLine.substring(firstSpace + 1, secondSpace));
            this.statusMessage = statusLine.substring(secondSpace + 1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(Policy.bind("exception.malformedStatusLine"));
        }
        if (protocolVersion == 1.0) {
            this.httpVersion = 1.0;
            this.closeConnection = true;
        }
        this.responseHeader.clear();
        this.readHeader(this.responseHeader);
    }

    protected void sendRequest() throws IOException {
        if (this.sentRequest) {
            return;
        }
        this.connect();
        if (this.requestHeader.getFieldValue("Host") == null) {
            this.internalHeader.addField("Host", String.valueOf(this.resourceUrl.getHost()) + (this.resourceUrl.getPort() == -1 ? "" : ":" + this.resourceUrl.getPort()));
        }
        if (this.httpVersion > 1.0 && !this.persistent && this.requestHeader.getFieldValue("Connection") == null) {
            this.internalHeader.addField("Connection", "close");
        }
        if (this.os != null || "100-continue".equals(this.requestHeader.getFieldValue("Expect"))) {
            if (this.requestHeader.getFieldValue("Content-Type") == null) {
                this.internalHeader.addField("Content-Type", "application/x-www-form-urlencoded");
            }
            if (this.httpVersion > 1.0 && this.sendChunked) {
                this.internalHeader.addField("Transfer-Encoding", "chunked");
            }
        }
        this.output(this.socketOut, this.method);
        this.output(this.socketOut, " ");
        this.output(this.socketOut, this.proxyServerUrl == null ? this.resourceUrl.getFile() : this.resourceUrl.toString());
        this.output(this.socketOut, " HTTP/1.1\r\n");
        this.writeHeader(this.internalHeader);
        this.writeHeader(this.requestHeader);
        this.output(this.socketOut, "\r\n");
        this.sentRequest = true;
        if (this.os == null) {
            this.readServerResponse();
        }
    }

    public void setHttpVersion(double version) {
        Assert.isTrue(version == 1.0 || version == 1.1);
        this.endRequest();
        this.httpVersion = version;
    }

    public void setPersistent(boolean close) {
        this.endRequest();
        this.persistent = close;
    }

    public void setProxyServerUrl(URL proxyServerUrl) {
        this.endRequest();
        if (proxyServerUrl == null && this.proxyServerUrl == null) {
            return;
        }
        boolean closeConnection = true;
        if (proxyServerUrl != null && this.proxyServerUrl != null) {
            URL oldProxyServerUrl = null;
            URL newProxyServerUrl = null;
            try {
                oldProxyServerUrl = new URL(this.proxyServerUrl.getProtocol(), this.proxyServerUrl.getHost(), this.proxyServerUrl.getPort(), "/");
                newProxyServerUrl = new URL(proxyServerUrl.getProtocol(), proxyServerUrl.getHost(), proxyServerUrl.getPort(), "/");
            }
            catch (MalformedURLException malformedURLException) {}
            if (oldProxyServerUrl.equals(newProxyServerUrl)) {
                closeConnection = false;
            }
        }
        if (closeConnection) {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
        this.proxyServerUrl = proxyServerUrl;
    }

    public void setReceiveBufferSize(int size) throws IOException {
        Assert.isTrue(size > 0);
        if (size != this.getReceiveBufferSize()) {
            this.receiveBufferSize = size;
            if (this.connected) {
                this.socket.setReceiveBufferSize(this.receiveBufferSize);
            }
        }
    }

    public void setRequestHeaderField(String fieldName, String fieldValue) {
        Assert.isNotNull(fieldName);
        Assert.isNotNull(fieldValue);
        this.endRequest();
        this.requestHeader.addField(fieldName, fieldValue);
    }

    public void setRequestMethod(String method) {
        Assert.isNotNull(method);
        this.endRequest();
        this.method = method;
    }

    public void setResourceUrl(URL resourceUrl) {
        Assert.isNotNull(resourceUrl);
        this.endRequest();
        URL oldOriginServerUrl = null;
        URL newOriginServerUrl = null;
        try {
            oldOriginServerUrl = new URL(this.resourceUrl.getProtocol(), this.resourceUrl.getHost(), this.resourceUrl.getPort(), "/");
            newOriginServerUrl = new URL(resourceUrl.getProtocol(), resourceUrl.getHost(), resourceUrl.getPort(), "/");
        }
        catch (MalformedURLException malformedURLException) {}
        if (!oldOriginServerUrl.equals(newOriginServerUrl)) {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
        this.resourceUrl = resourceUrl;
    }

    public void setSendBufferSize(int size) throws IOException {
        Assert.isTrue(size > 0);
        if (size != this.getSendBufferSize()) {
            this.sendBufferSize = size;
            if (this.connected) {
                this.socket.setSendBufferSize(this.sendBufferSize);
            }
        }
    }

    public void setSendChunked(boolean chunked) {
        this.endRequest();
        this.sendChunked = chunked;
    }

    public void setSocketFactory(ISocketFactory socketFactory) {
        this.endRequest();
        if (socketFactory == this.socketFactory) {
            return;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {}
        this.socketFactory = socketFactory;
    }

    public void setSoLinger(boolean on, int linger) throws IOException {
        Assert.isTrue(linger >= 0);
        if (!on && this.soLinger != -1 || on && linger != this.soLinger) {
            int n = this.soLinger = on ? linger : -1;
            if (this.connected) {
                this.socket.setSoLinger(on, linger);
            }
        }
    }

    public void setSoTimeout(int timeout) throws IOException {
        Assert.isTrue(timeout >= 0);
        if (timeout != this.soTimeout) {
            this.soTimeout = timeout;
            if (this.connected) {
                this.socket.setSoTimeout(this.soTimeout);
            }
        }
    }

    public void setTcpNoDelay(boolean on) throws IOException {
        if (on != this.tcpNoDelay) {
            this.tcpNoDelay = on;
            if (this.connected) {
                this.socket.setTcpNoDelay(this.tcpNoDelay);
            }
        }
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    private void writeHeader(Header header) throws IOException {
        int i = 0;
        while (i < header.size()) {
            String fieldName = header.getFieldName(i);
            String fieldValue = header.getFieldValue(fieldName);
            this.output(this.socketOut, fieldName);
            this.output(this.socketOut, ": ");
            this.output(this.socketOut, fieldValue);
            this.output(this.socketOut, "\r\n");
            ++i;
        }
    }

    private class CachedOutputStream
    extends OutputStream {
        private static final int INITIAL_CACHE_SIZE = 1024;
        private ByteArrayOutputStream cache = new ByteArrayOutputStream(1024);
        private boolean closed = false;

        private CachedOutputStream() {
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                String contentLength = Integer.toString(this.cache.size());
                HttpConnection.this.internalHeader.addField("Content-Length", contentLength);
                HttpConnection.this.sendRequest();
                this.cache.writeTo(HttpConnection.this.socketOut);
                HttpConnection.this.readServerResponse();
            }
            finally {
                this.closed = true;
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
        }

        public void write(int data) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            this.cache.write(data);
        }

        public void write(byte[] buffer, int offset, int count) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            this.cache.write(buffer, offset, count);
        }
    }

    private class ChunkedInputStream
    extends InputStream {
        private int bytesRemaining = -1;
        private boolean atEnd = false;

        private ChunkedInputStream() {
        }

        public int available() throws IOException {
            return Math.min(HttpConnection.this.socketIn.available(), this.bytesRemaining);
        }

        public void close() throws IOException {
            while (this.skip(4096) > 0L) {
            }
        }

        public int read() throws IOException {
            if (!this.atEnd && this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (this.atEnd) {
                return -1;
            }
            --this.bytesRemaining;
            return HttpConnection.this.socketIn.read();
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            if (!this.atEnd && this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (this.atEnd) {
                return -1;
            }
            int result = HttpConnection.this.socketIn.read(buf, offset, Math.min(length, this.bytesRemaining));
            if (result > 0) {
                this.bytesRemaining -= result;
            }
            return result;
        }

        private void readChunkSize() throws IOException {
            String size;
            int index;
            if (this.bytesRemaining == 0) {
                HttpConnection.this.readln();
            }
            if ((index = (size = HttpConnection.this.readln()).indexOf(";")) >= 0) {
                size = size.substring(0, index);
            }
            try {
                this.bytesRemaining = Integer.parseInt(size.trim(), 16);
            }
            catch (NumberFormatException exception) {
                throw new IOException(exception.getMessage());
            }
            if (this.bytesRemaining == 0) {
                this.atEnd = true;
                HttpConnection.this.readHeader(HttpConnection.this.responseHeader);
            }
        }

        public long skip(int amount) throws IOException {
            if (!this.atEnd && this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (this.atEnd) {
                return -1L;
            }
            long result = HttpConnection.this.socketIn.skip(Math.min(amount, this.bytesRemaining));
            if (result > 0L) {
                this.bytesRemaining = (int)((long)this.bytesRemaining - result);
            }
            return result;
        }
    }

    private class ChunkedOutputStream
    extends OutputStream {
        private static final int MAX_BUFFER_SIZE = 1024;
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
        private boolean closed = false;

        private ChunkedOutputStream() {
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.sendBuffer();
                HttpConnection.this.output(HttpConnection.this.socketOut, "0\r\n\r\n");
                HttpConnection.this.readServerResponse();
            }
            finally {
                this.closed = true;
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.sendBuffer();
            HttpConnection.this.socketOut.flush();
        }

        public void sendBuffer() throws IOException {
            int chunkSize = this.buffer.size();
            if (chunkSize > 0) {
                HttpConnection.this.output(HttpConnection.this.socketOut, String.valueOf(Integer.toHexString(chunkSize)) + "\r\n");
                this.buffer.writeTo(HttpConnection.this.socketOut);
                this.buffer.reset();
                HttpConnection.this.output(HttpConnection.this.socketOut, "\r\n");
            }
        }

        public void write(int data) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            this.buffer.write(data);
            if (this.buffer.size() >= 1024) {
                this.sendBuffer();
            }
        }

        public void write(byte[] buf, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            int bufferSize = this.buffer.size();
            if (bufferSize + len < 1024) {
                this.buffer.write(buf, off, len);
            } else {
                HttpConnection.this.output(HttpConnection.this.socketOut, String.valueOf(Integer.toHexString(bufferSize + len)) + "\r\n");
                this.buffer.writeTo(HttpConnection.this.socketOut);
                this.buffer.reset();
                HttpConnection.this.socketOut.write(buf, off, len);
                HttpConnection.this.output(HttpConnection.this.socketOut, "\r\n");
            }
        }
    }

    public class Header {
        private Vector fieldNames = new Vector(5);
        private Vector fieldValues = new Vector(5);

        public void addField(String fieldName, String fieldValue) {
            Assert.isNotNull(fieldName);
            Assert.isNotNull(fieldValue);
            this.fieldNames.addElement(fieldName);
            this.fieldValues.addElement(fieldValue);
        }

        public void clear() {
            this.fieldNames.removeAllElements();
            this.fieldValues.removeAllElements();
        }

        public String getFieldValue(int position) {
            if (position < 0 || position >= this.fieldValues.size()) {
                return null;
            }
            return (String)this.fieldValues.elementAt(position);
        }

        public String getFieldValue(String fieldName) {
            Assert.isNotNull(fieldName);
            return this.getFieldValue(this.fieldNames.indexOf(fieldName));
        }

        public String getFieldName(int position) {
            if (position < 0 || position >= this.fieldNames.size()) {
                return null;
            }
            return (String)this.fieldNames.elementAt(position);
        }

        public int size() {
            return this.fieldNames.size();
        }
    }

    private class LimitedInputStream
    extends InputStream {
        private int bytesRemaining;

        public LimitedInputStream(int length) {
            Assert.isTrue(length >= 0);
            this.bytesRemaining = length;
        }

        public int available() throws IOException {
            return Math.min(HttpConnection.this.socketIn.available(), this.bytesRemaining);
        }

        public void close() throws IOException {
            while (this.skip(4096) > 0L) {
            }
        }

        public int read() throws IOException {
            if (this.bytesRemaining <= 0) {
                return -1;
            }
            --this.bytesRemaining;
            return HttpConnection.this.socketIn.read();
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            if (this.bytesRemaining <= 0) {
                return -1;
            }
            int result = HttpConnection.this.socketIn.read(buf, offset, Math.min(length, this.bytesRemaining));
            if (result > 0) {
                this.bytesRemaining -= result;
            }
            return result;
        }

        public long skip(int amount) throws IOException {
            if (this.bytesRemaining <= 0) {
                return -1L;
            }
            long result = HttpConnection.this.socketIn.skip(Math.min(amount, this.bytesRemaining));
            if (result > 0L) {
                this.bytesRemaining = (int)((long)this.bytesRemaining - result);
            }
            return result;
        }
    }

    private class LimitedOutputStream
    extends OutputStream {
        private int limit;
        private boolean closed = false;

        public LimitedOutputStream(int limit) {
            Assert.isTrue(limit >= 0);
            this.limit = limit;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.flush();
                if (this.limit > 0) {
                    throw new IOException(Policy.bind("exception.contentLengthUnderflow"));
                }
                HttpConnection.this.readServerResponse();
            }
            finally {
                this.closed = true;
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            HttpConnection.this.socketOut.flush();
        }

        public void write(int data) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            if (this.limit == 0) {
                throw new IOException(Policy.bind("exception.contentLengthExceeded"));
            }
            --this.limit;
            HttpConnection.this.socketOut.write(data);
        }

        public void write(byte[] buffer, int offset, int count) throws IOException {
            if (this.closed) {
                throw new IOException(Policy.bind("exception.closed"));
            }
            if (count > this.limit) {
                throw new IOException(Policy.bind("exception.contentLengthExceeded"));
            }
            this.limit -= count;
            HttpConnection.this.socketOut.write(buffer, offset, count);
        }
    }
}

