/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util.upgrade;

import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.server.util.upgrade.IUpgradeHelper;

public class RuleModelUpgradeHelper3
implements IUpgradeHelper<RuleModel, RuleModel> {
    @Override
    public RuleModel upgrade(RuleModel model) {
        this.updateConstraints(model);
        return model;
    }

    private void updateConstraints(RuleModel model) {
        for (IPattern p : model.lhs) {
            this.fixConstraints(p);
        }
    }

    private void fixConstraints(IPattern p) {
        if (p instanceof FactPattern) {
            this.fixConstraints((FactPattern)p);
        } else if (p instanceof CompositeFactPattern) {
            this.fixConstraints((CompositeFactPattern)p);
        }
    }

    private void fixConstraints(FactPattern p) {
        for (FieldConstraint fc : p.getFieldConstraints()) {
            this.fixConstraints(p, fc);
        }
    }

    private void fixConstraints(CompositeFactPattern p) {
        for (IFactPattern cp : p.getPatterns()) {
            this.fixConstraints(cp);
        }
    }

    private void fixConstraints(FactPattern fp, FieldConstraint fc) {
        if (fc instanceof SingleFieldConstraint) {
            this.fixConstraints(fp, (SingleFieldConstraint)fc);
        } else if (fc instanceof CompositeFieldConstraint) {
            this.fixConstraints(fp, (CompositeFieldConstraint)fc);
        }
    }

    private void fixConstraints(FactPattern fp, SingleFieldConstraint sfc) {
        sfc.setFactType(fp.getFactType());
        sfc.setFieldName(this.fixFieldName(sfc.getFieldName()));
        if (sfc.connectives == null) {
            return;
        }
        for (ConnectiveConstraint cc : sfc.connectives) {
            cc.setFactType(fp.getFactType());
            cc.setFieldName(this.fixFieldName(cc.getFieldName()));
        }
    }

    private void fixConstraints(FactPattern fp, CompositeFieldConstraint cfc) {
        if (cfc.constraints == null) {
            return;
        }
        for (FieldConstraint fc : cfc.constraints) {
            this.fixConstraints(fp, fc);
        }
    }

    private String fixFieldName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex != -1) {
            return fieldName.substring(dotIndex + 1);
        }
        return fieldName;
    }
}

