/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.antlr.runtime.RecognitionException;
import org.drools.builder.KnowledgeBuilderResult;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.FactTemplateError;
import org.drools.compiler.FieldTemplateError;
import org.drools.compiler.FunctionError;
import org.drools.compiler.GlobalError;
import org.drools.compiler.ImportError;
import org.drools.compiler.ParserError;
import org.drools.compiler.RuleBuildError;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.builder.DroolsBuildMarker;
import org.drools.eclipse.builder.ResourceDescr;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.ide.common.server.util.GuidedDTDRLPersistence;
import org.drools.ide.common.server.util.GuidedDTXMLPersistence;
import org.drools.lang.ExpanderException;
import org.drools.template.parser.DecisionTableParseException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.drools.eclipse.droolsbuilder";
    private Map<String, IPath> kbases;
    private Map<IPath, String> kbasePaths;
    private Map<String, Set<String>> kbaseFiles;
    private Set<String> dirtyKbases;

    void getAllKBaseFilesFromDisk(Set files, IFolder folder, IProject currentProject) {
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFolder) {
                    this.getAllKBaseFilesFromDisk(files, (IFolder)res, currentProject);
                } else if (res instanceof IFile) {
                    files.add(((IFile)res).getProjectRelativePath().toString());
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    public void writeAllKBaseFilesToProperties(String kbaseName, IProject currentProject) throws IOException, CoreException {
        Properties props;
        IFile ifile;
        IFolder ifolder;
        block22: {
            ifolder = currentProject.getFolder(this.kbases.get(kbaseName));
            ifile = ifolder.getFile(String.valueOf(kbaseName) + ".properties");
            props = new Properties();
            if (ifile.exists()) {
                InputStream is = null;
                try {
                    is = ifile.getContents();
                    props.load(is);
                }
                catch (IOException e) {
                    DroolsEclipsePlugin.log(e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            DroolsEclipsePlugin.log(e2);
                        }
                    }
                    break block22;
                }
                catch (CoreException e) {
                    try {
                        DroolsEclipsePlugin.log(e);
                        break block22;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e3) {
                                DroolsEclipsePlugin.log(e3);
                            }
                        }
                    }
                }
                if (is == null) break block22;
                try {
                    is.close();
                }
                catch (IOException e) {
                    DroolsEclipsePlugin.log(e);
                }
            }
        }
        StringBuilder sbuilder = new StringBuilder();
        boolean first = true;
        for (String file : this.kbaseFiles.get(kbaseName)) {
            if (file.equals(ifile.getProjectRelativePath().toString())) continue;
            if (!first) {
                sbuilder.append(", ");
            }
            IFile res = currentProject.getFile((IPath)new Path(file));
            sbuilder.append(res.getFullPath().makeRelativeTo(ifolder.getFullPath()).toString());
            first = false;
        }
        props.setProperty("files", sbuilder.toString());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, null);
        baos.close();
        if (ifile.exists()) {
            ifile.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, null);
        } else {
            ifile.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }

    public void removeKBaseFromKBasePathsProperties(IProject currentProject, String kbaseName, IPath path) throws IOException, CoreException {
        IFile ifile = currentProject.getFile("kbasePaths.properties");
        Properties props = new Properties();
        if (ifile.exists()) {
            InputStream is = null;
            try {
                is = ifile.getContents();
                props.load(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        if (props.remove("kbase." + kbaseName) != null) {
            this.removeKBaseFromKProjectProperties(currentProject, kbaseName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            props.store(baos, null);
            baos.close();
            if (ifile.exists()) {
                ifile.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, null);
            } else {
                ifile.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
            }
        }
    }

    public void removeKBaseFromKProjectProperties(IProject currentProject, String kbaseName) throws IOException, CoreException {
        IFolder ifolder = currentProject.getProject().getFolder("src");
        IFile ifile = ifolder.getFile("kproject.properties");
        Properties props = new Properties();
        if (ifile.exists()) {
            InputStream is = null;
            try {
                is = ifile.getContents();
                props.load(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        String kbaseEntries = props.getProperty("kbaseEntries", "");
        String[] strEntries = kbaseEntries.split(",");
        StringBuilder sbuilder = new StringBuilder();
        boolean first = true;
        String[] stringArray = strEntries;
        int n = strEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String strEntry = stringArray[n2];
            if (!strEntry.trim().equals(kbaseName)) {
                if (!first) {
                    sbuilder.append(", ");
                }
                sbuilder.append(strEntry);
                first = false;
            }
            ++n2;
        }
        props.setProperty("kbaseEntries", sbuilder.toString());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, null);
        baos.close();
        if (ifile.exists()) {
            ifile.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, null);
        } else {
            ifile.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        if (currentProject == null || !currentProject.isAccessible()) {
            return new IProject[0];
        }
        try {
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        catch (CoreException e) {
            IMarker marker = currentProject.createMarker("org.drools.eclipse.problem");
            marker.setAttribute("message", (Object)("Error when trying to build Drools project: " + e.getLocalizedMessage()));
            marker.setAttribute("severity", 2);
        }
        return this.getRequiredProjects(currentProject);
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.removeProblemsFor((IResource)this.getProject());
        IJavaProject project = JavaCore.create((IProject)this.getProject());
        IClasspathEntry[] classpathEntries = project.getRawClasspath();
        int i = 0;
        while (i < classpathEntries.length) {
            String[] jars;
            if ("DROOLS/Drools".equals(classpathEntries[i].getPath().toString()) && ((jars = DroolsRuntimeManager.getDroolsRuntimeJars(this.getProject())) == null || jars.length == 0)) {
                String runtime = DroolsRuntimeManager.getDroolsRuntime(this.getProject());
                IMarker marker = this.getProject().createMarker("org.drools.eclipse.problem");
                if (runtime == null) {
                    marker.setAttribute("message", (Object)"Could not find default Drools runtime");
                } else {
                    marker.setAttribute("message", (Object)("Could not find Drools runtime " + runtime));
                }
                marker.setAttribute("severity", 2);
                return;
            }
            ++i;
        }
        if (DroolsEclipsePlugin.getDefault().getPreferenceStore().getBoolean("Drools.CrossBuild")) {
            DroolsBatchBuildVisitor batchBuildVisitor = new DroolsBatchBuildVisitor();
            this.getProject().accept((IResourceVisitor)batchBuildVisitor);
            batchBuildVisitor.build();
        } else {
            this.getProject().accept((IResourceVisitor)new DroolsBuildVisitor());
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        boolean fullBuild;
        IPreferenceStore store = DroolsEclipsePlugin.getDefault().getPreferenceStore();
        boolean bl = fullBuild = store.getBoolean("Drools.CrossBuild") || store.getBoolean("Drools.BuildAll");
        if (!fullBuild) {
            fullBuild = DroolsEclipsePlugin.getDefault().resetForceFullBuild();
        }
        if (fullBuild) {
            this.fullBuild(monitor);
        } else {
            delta.accept((IResourceDeltaVisitor)new DroolsBuildDeltaVisitor());
        }
    }

    private boolean isInOutputDirectory(IResource res) throws JavaModelException {
        IJavaProject project = JavaCore.create((IProject)res.getProject());
        return !project.getOutputLocation().equals((Object)project.getPath()) && project.getOutputLocation().isPrefixOf(res.getFullPath());
    }

    private boolean exists(IResource res) {
        if (!res.exists()) {
            IPath path;
            if (res instanceof IFolder && this.kbasePaths.containsKey(path = ((IFolder)res).getProjectRelativePath())) {
                String kbaseName = this.kbasePaths.remove(path);
                try {
                    this.removeKBaseFromKBasePathsProperties(this.getProject(), kbaseName, path);
                }
                catch (IOException e) {
                    DroolsEclipsePlugin.log(e);
                }
                catch (CoreException e) {
                    DroolsEclipsePlugin.log(e);
                }
                this.dirtyKbases.remove(kbaseName);
                this.kbases.remove(kbaseName);
                this.kbaseFiles.remove(kbaseName);
            }
            this.removeProblemsFor(res);
            DroolsEclipsePlugin.getDefault().invalidateResource(res);
            return false;
        }
        return true;
    }

    protected boolean parseResource(IResource res, boolean clean) {
        block29: {
            try {
                if (!".guvnorinfo".equals(res.getName())) break block29;
                return false;
            }
            catch (JavaModelException javaModelException) {}
        }
        if (this.isInOutputDirectory(res)) {
            return false;
        }
        if (!this.exists(res)) {
            return false;
        }
        if (res instanceof IFile && ("drl".equals(res.getFileExtension()) || "dslr".equals(res.getFileExtension()) || ".package".equals(res.getName()))) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                this.appendMarkers(res, this.parseDRLFile((IFile)res));
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        if (res instanceof IFile && "xls".equals(res.getFileExtension())) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                this.appendMarkers(res, this.parseXLSFile((IFile)res));
            }
            catch (Throwable t) {
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        if (res instanceof IFile && "csv".equals(res.getFileExtension())) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                this.appendMarkers(res, this.parseCSVFile((IFile)res));
            }
            catch (Throwable t) {
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        if (res instanceof IFile && "brl".equals(res.getFileExtension())) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                this.appendMarkers(res, this.parseBRLFile((IFile)res));
            }
            catch (Throwable t) {
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        if (res instanceof IFile && "rf".equals(res.getFileExtension())) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                this.appendMarkers(res, this.parseRuleFlowFile((IFile)res));
            }
            catch (Throwable t) {
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        if (res instanceof IFile && ("bpmn".equals(res.getFileExtension()) || "bpmn2".equals(res.getFileExtension()))) {
            this.removeProblemsFor(res);
            try {
                if (clean) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(res);
                }
                this.appendMarkers(res, this.parseRuleFlowFile((IFile)res));
            }
            catch (Throwable t) {
                this.createMarker(res, t.getMessage(), -1);
            }
            return false;
        }
        return true;
    }

    private void appendMarkers(DRLInfo drlInfo) {
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        this.markParseErrors(markers, drlInfo.getParserErrors());
        this.markOtherErrors(markers, drlInfo.getBuilderErrors());
        this.appendMarkers(drlInfo.getResource(), markers);
    }

    private void appendMarkers(IResource res, List<DroolsBuildMarker> markers) {
        for (DroolsBuildMarker marker : markers) {
            this.createMarker(res, marker.getText(), marker.getLine());
        }
    }

    private List<DroolsBuildMarker> parseResource(ResourceParser resourceParser) {
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        try {
            DRLInfo drlInfo = resourceParser.parseResource();
            this.markParseErrors(markers, drlInfo.getParserErrors());
            this.markOtherErrors(markers, drlInfo.getBuilderErrors());
        }
        catch (DroolsParserException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RecognitionException) {
                RecognitionException recogErr = (RecognitionException)cause;
                markers.add(new DroolsBuildMarker(recogErr.getMessage(), recogErr.line));
            }
        }
        catch (DecisionTableParseException e) {
            if (!"No RuleTable's were found in spreadsheet.".equals(e.getMessage())) {
                throw e;
            }
        }
        catch (Exception t) {
            String message = t.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Error: " + t.getClass().getName();
            }
            markers.add(new DroolsBuildMarker(message));
        }
        return markers;
    }

    private List<DroolsBuildMarker> parseDRLFile(final IFile file) {
        return this.parseResource(new ResourceParser(){

            public DRLInfo parseResource() throws DroolsParserException {
                return DroolsEclipsePlugin.getDefault().parseResource((IResource)file, true);
            }
        });
    }

    private List<DroolsBuildMarker> parseXLSFile(final IFile file) {
        return this.parseResource(new ResourceParser(){

            public DRLInfo parseResource() throws DroolsParserException, DecisionTableParseException, CoreException {
                SpreadsheetCompiler converter = new SpreadsheetCompiler();
                String drl = converter.compile(file.getContents(), InputType.XLS);
                return DroolsEclipsePlugin.getDefault().parseXLSResource(drl, (IResource)file);
            }
        });
    }

    private List<DroolsBuildMarker> parseCSVFile(final IFile file) {
        return this.parseResource(new ResourceParser(){

            public DRLInfo parseResource() throws DroolsParserException, CoreException {
                SpreadsheetCompiler converter = new SpreadsheetCompiler();
                String drl = converter.compile(file.getContents(), InputType.CSV);
                return DroolsEclipsePlugin.getDefault().parseXLSResource(drl, (IResource)file);
            }
        });
    }

    private List<DroolsBuildMarker> parseBRLFile(final IFile file) {
        return this.parseResource(new ResourceParser(){

            public DRLInfo parseResource() throws DroolsParserException, CoreException, IOException {
                String brl = DroolsBuilder.convertToString(file.getContents());
                RuleModel model = BRXMLPersistence.getInstance().unmarshal(brl);
                String drl = BRDRLPersistence.getInstance().marshal(model);
                return DroolsEclipsePlugin.getDefault().parseBRLResource(drl, (IResource)file);
            }
        });
    }

    private List<DroolsBuildMarker> parseGDSTFile(final IFile file) {
        return this.parseResource(new ResourceParser(){

            public DRLInfo parseResource() throws DroolsParserException, CoreException, IOException {
                String gdst = DroolsBuilder.convertToString(file.getContents());
                GuidedDecisionTable52 dt = GuidedDTXMLPersistence.getInstance().unmarshal(gdst);
                String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
                return DroolsEclipsePlugin.getDefault().parseGDSTResource(drl, (IResource)file);
            }
        });
    }

    protected List<DroolsBuildMarker> parseRuleFlowFile(IFile file) {
        ArrayList<DroolsBuildMarker> markers = new ArrayList<DroolsBuildMarker>();
        if (!file.exists()) {
            return markers;
        }
        try {
            String input = DroolsBuilder.convertToString(file.getContents());
            ProcessInfo processInfo = DroolsEclipsePlugin.getDefault().parseProcess(input, (IResource)file);
            if (processInfo != null) {
                this.markParseErrors(markers, processInfo.getErrors());
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            String message = t.getMessage();
            if (message == null || message.trim().equals("")) {
                message = "Error: " + t.getClass().getName();
            }
            markers.add(new DroolsBuildMarker(message));
        }
        return markers;
    }

    protected static String convertToString(InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    protected void markParseErrors(List<DroolsBuildMarker> markers, List<DroolsError> parserErrors) {
        for (DroolsError error : parserErrors) {
            if (error instanceof ParserError) {
                ParserError err = (ParserError)error;
                markers.add(new DroolsBuildMarker(err.getMessage(), err.getRow()));
                continue;
            }
            if (error instanceof KnowledgeBuilderResult) {
                KnowledgeBuilderResult res = (KnowledgeBuilderResult)error;
                int[] errorLines = res.getLines();
                markers.add(new DroolsBuildMarker(res.getMessage(), errorLines != null && errorLines.length > 0 ? errorLines[0] : -1));
                continue;
            }
            if (error instanceof ExpanderException) {
                ExpanderException exc = (ExpanderException)error;
                markers.add(new DroolsBuildMarker(exc.getMessage(), -1));
                continue;
            }
            markers.add(new DroolsBuildMarker(error.toString()));
        }
    }

    private void markOtherErrors(List<DroolsBuildMarker> markers, DroolsError[] buildErrors) {
        int i = 0;
        while (i < buildErrors.length) {
            int j;
            CompilationProblem[] problems;
            DroolsError error = buildErrors[i];
            if (error instanceof GlobalError) {
                GlobalError globalError = (GlobalError)error;
                markers.add(new DroolsBuildMarker("Global error: " + globalError.getGlobal(), -1));
            } else if (error instanceof RuleBuildError) {
                RuleBuildError ruleError = (RuleBuildError)error;
                if (ruleError.getObject() instanceof CompilationProblem[]) {
                    problems = (CompilationProblem[])ruleError.getObject();
                    j = 0;
                    while (j < problems.length) {
                        markers.add(new DroolsBuildMarker(problems[j].getMessage(), ruleError.getLine()));
                        ++j;
                    }
                } else {
                    markers.add(new DroolsBuildMarker(String.valueOf(ruleError.getRule().getName()) + ":" + ruleError.getMessage(), ruleError.getLine()));
                }
            } else if (error instanceof ParserError) {
                ParserError parserError = (ParserError)error;
                markers.add(new DroolsBuildMarker(parserError.getMessage(), parserError.getRow()));
            } else if (error instanceof FunctionError) {
                FunctionError functionError = (FunctionError)error;
                if (functionError.getObject() instanceof CompilationProblem[]) {
                    problems = (CompilationProblem[])functionError.getObject();
                    j = 0;
                    while (j < problems.length) {
                        markers.add(new DroolsBuildMarker(problems[j].getMessage(), functionError.getLines()[j]));
                        ++j;
                    }
                } else {
                    markers.add(new DroolsBuildMarker(String.valueOf(functionError.getFunctionDescr().getName()) + ":" + functionError.getMessage(), -1));
                }
            } else if (error instanceof FieldTemplateError) {
                markers.add(new DroolsBuildMarker(error.getMessage(), ((FieldTemplateError)error).getLine()));
            } else if (error instanceof FactTemplateError) {
                markers.add(new DroolsBuildMarker(error.getMessage(), ((FactTemplateError)error).getLine()));
            } else if (error instanceof ImportError) {
                markers.add(new DroolsBuildMarker("ImportError: " + error.getMessage()));
            } else if (error instanceof DescrBuildError) {
                markers.add(new DroolsBuildMarker("BuildError: " + error.getMessage(), ((DescrBuildError)error).getLine()));
            } else {
                markers.add(new DroolsBuildMarker("Unknown DroolsError " + error.getClass() + ": " + error));
            }
            ++i;
        }
    }

    protected void createMarker(final IResource res, final String message, final int lineNumber) {
        try {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker marker = res.createMarker("org.drools.eclipse.problem");
                    marker.setAttribute("message", (Object)message);
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("lineNumber", lineNumber);
                }
            };
            res.getWorkspace().run(r, null, 1, null);
        }
        catch (CoreException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    protected void removeProblemsFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.drools.eclipse.problem", false, 2);
            }
        }
        catch (CoreException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    private IProject[] getRequiredProjects(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IProject p;
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && (p = project.getWorkspace().getRoot().getProject(entry.getPath().lastSegment())) != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return new IProject[0];
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    private class DroolsBatchBuildVisitor
    implements IResourceVisitor {
        private final List<ResourceDescr> resourceDescrs = new ArrayList<ResourceDescr>();

        private DroolsBatchBuildVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            try {
                if (DroolsBuilder.this.isInOutputDirectory(resource)) {
                    return false;
                }
            }
            catch (JavaModelException javaModelException) {}
            if (!DroolsBuilder.this.exists(resource)) {
                return false;
            }
            ResourceDescr resourceDescr = ResourceDescr.createResourceDescr(resource);
            if (resourceDescr != null) {
                DroolsBuilder.this.removeProblemsFor(resource);
                DroolsEclipsePlugin.getDefault().invalidateResource(resource);
                this.resourceDescrs.add(resourceDescr);
            }
            return true;
        }

        public void build() {
            List<DRLInfo> drlInfos = DroolsEclipsePlugin.getDefault().parseResources(this.resourceDescrs);
            for (DRLInfo drlInfo : drlInfos) {
                DroolsBuilder.this.appendMarkers(drlInfo);
            }
        }
    }

    private class DroolsBuildDeltaVisitor
    implements IResourceDeltaVisitor {
        private DroolsBuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            return DroolsBuilder.this.parseResource(delta.getResource(), false);
        }
    }

    private class DroolsBuildVisitor
    implements IResourceVisitor {
        private DroolsBuildVisitor() {
        }

        public boolean visit(IResource res) {
            return DroolsBuilder.this.parseResource(res, true);
        }
    }

    private static interface ResourceParser {
        public DRLInfo parseResource() throws DroolsParserException, DecisionTableParseException, CoreException, IOException;
    }
}

