/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ActionInsertFreeFormLineWidget
extends Widget {
    private FreeFormLine action;
    private final boolean rhs;

    public ActionInsertFreeFormLineWidget(FormToolkit toolkit, Composite comp, RuleModeller ruleModeller, FreeFormLine action, int i, boolean rhs) {
        super(comp, toolkit, ruleModeller, i);
        this.rhs = rhs;
        GridLayout l = new GridLayout();
        l.numColumns = 2;
        this.parent.setLayout((Layout)l);
        this.createTextfield(comp, action);
        this.addRemoveFieldAction(this.parent, i);
        toolkit.paintBordersFor(this.parent);
        this.action = action;
    }

    private void createTextfield(Composite comp, final FreeFormLine action) {
        final Text text = this.toolkit.createText(comp, action.text);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 100;
        text.setLayoutData((Object)gd);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActionInsertFreeFormLineWidget.this.getModeller().setDirty(true);
                action.text = text.getText();
            }
        });
    }

    private void addRemoveFieldAction(Composite constraintComposite, final int row) {
        ImageHyperlink delLink = this.addImage(constraintComposite, "icons/delete_item_small.gif");
        delLink.setToolTipText("Remove this field action");
        delLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                dialog.setMessage("Remove this item?");
                dialog.setText("Remove this item?");
                if (dialog.open() == 64) {
                    if (ActionInsertFreeFormLineWidget.this.rhs) {
                        ActionInsertFreeFormLineWidget.this.getModeller().getModel().removeRhsItem(row);
                        ActionInsertFreeFormLineWidget.this.getModeller().setDirty(true);
                        ActionInsertFreeFormLineWidget.this.getModeller().reloadRhs();
                    } else {
                        ActionInsertFreeFormLineWidget.this.getModeller().getModel().removeLhsItem(row);
                        ActionInsertFreeFormLineWidget.this.getModeller().setDirty(true);
                        ActionInsertFreeFormLineWidget.this.getModeller().reloadLhs();
                    }
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }
}

