/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ActionSetFieldDialog
extends RuleDialog {
    private String[] fieldCompletions;
    private RuleModeller modeller;
    private ActionSetField field;
    private String variableClass;

    public ActionSetFieldDialog(Shell parent, RuleModeller modeller, ActionSetField field, String[] fieldCompletions, String variableClass) {
        super(parent, "Add a field", "Add a field");
        this.fieldCompletions = fieldCompletions;
        this.modeller = modeller;
        this.field = field;
        this.variableClass = variableClass;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createLabel(composite, "Add a field");
        final Combo fieldsCombo = new Combo(parent, 8);
        fieldsCombo.add("Choose field...");
        int i = 0;
        while (i < this.fieldCompletions.length) {
            fieldsCombo.add(this.fieldCompletions[i]);
            ++i;
        }
        fieldsCombo.select(0);
        fieldsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (fieldsCombo.getSelectionIndex() == 0) {
                    return;
                }
                String fieldType = ActionSetFieldDialog.this.modeller.getSuggestionCompletionEngine().getFieldType(ActionSetFieldDialog.this.variableClass, fieldsCombo.getText());
                ActionSetFieldDialog.this.field.addFieldValue(new ActionFieldValue(fieldsCombo.getText(), "", fieldType));
                ActionSetFieldDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ActionSetFieldDialog.this.modeller.reloadRhs();
                        ActionSetFieldDialog.this.modeller.setDirty(true);
                        ActionSetFieldDialog.this.close();
                    }
                });
            }
        });
        return composite;
    }
}

