/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.view.rules;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.core.DroolsElement;
import org.drools.eclipse.core.DroolsModelBuilder;
import org.drools.eclipse.core.Function;
import org.drools.eclipse.core.Global;
import org.drools.eclipse.core.Package;
import org.drools.eclipse.core.Process;
import org.drools.eclipse.core.Query;
import org.drools.eclipse.core.Rule;
import org.drools.eclipse.core.RuleSet;
import org.drools.eclipse.core.ui.DroolsContentProvider;
import org.drools.eclipse.core.ui.DroolsLabelProvider;
import org.drools.eclipse.core.ui.DroolsTreeSorter;
import org.drools.eclipse.core.ui.FilterActionGroup;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RulesView
extends ViewPart
implements IDoubleClickListener,
IResourceVisitor,
IResourceChangeListener {
    private final RuleSet ruleSet = DroolsModelBuilder.createRuleSet();
    private Map resourcesMap = new HashMap();
    private TreeViewer treeViewer;

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.treeViewer.setContentProvider((IContentProvider)new DroolsContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DroolsLabelProvider());
        this.treeViewer.setSorter((ViewerSorter)new DroolsTreeSorter());
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput((Object)this.ruleSet);
        FilterActionGroup filterActionGroup = new FilterActionGroup((StructuredViewer)this.treeViewer, "org.drools.eclipse.view.rules.RulesView");
        filterActionGroup.fillActionBars(this.getViewSite().getActionBars());
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)this);
        }
        catch (CoreException e) {
            DroolsEclipsePlugin.log(e);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public boolean visit(IResource resource) throws CoreException {
        return this.updateResource(resource);
    }

    private boolean updateResource(IResource resource) {
        IProject project = resource.getProject();
        if (project != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (!javaProject.exists()) {
                return false;
            }
            if (resource instanceof IFile && javaProject.isOnClasspath(resource)) {
                IFile file = (IFile)resource;
                if ("drl".equals(resource.getFileExtension()) || "dslr".equals(resource.getFileExtension())) {
                    Package pkg;
                    DRLInfo drlInfo;
                    block22: {
                        drlInfo = DroolsEclipsePlugin.getDefault().parseResource(resource, false);
                        String packageName = drlInfo.getPackageName();
                        pkg = this.ruleSet.getPackage(packageName);
                        if (pkg == null) {
                            pkg = DroolsModelBuilder.addPackage(this.ruleSet, packageName, 0, 0);
                        }
                        if (drlInfo.getBuilderErrors().length <= 0 && drlInfo.getPackageDescr() != null) break block22;
                        return false;
                    }
                    try {
                        List rules = drlInfo.getPackageDescr().getRules();
                        for (RuleDescr ruleDescr : rules) {
                            List<DroolsElement> droolsElements;
                            boolean isQuery = ruleDescr instanceof QueryDescr;
                            String ruleName = ruleDescr.getName();
                            if (!isQuery) {
                                Rule rule = DroolsModelBuilder.addRule(pkg, ruleName, file, ruleDescr.getStartCharacter(), ruleDescr.getEndCharacter() - ruleDescr.getStartCharacter() + 1, null);
                                droolsElements = (List)this.resourcesMap.get(file);
                                if (droolsElements == null) {
                                    droolsElements = new ArrayList();
                                    this.resourcesMap.put(file, droolsElements);
                                }
                                droolsElements.add(rule);
                                continue;
                            }
                            Query query = DroolsModelBuilder.addQuery(pkg, ruleName, file, ruleDescr.getStartCharacter(), ruleDescr.getEndCharacter() - ruleDescr.getStartCharacter() + 1);
                            droolsElements = (ArrayList<DroolsElement>)this.resourcesMap.get(file);
                            if (droolsElements == null) {
                                droolsElements = new ArrayList<DroolsElement>();
                                this.resourcesMap.put(file, droolsElements);
                            }
                            droolsElements.add(query);
                        }
                        List globals = drlInfo.getPackageDescr().getGlobals();
                        for (GlobalDescr globalDescr : globals) {
                            Global global = DroolsModelBuilder.addGlobal(pkg, globalDescr.getIdentifier(), file, globalDescr.getStartCharacter(), globalDescr.getEndCharacter() - globalDescr.getStartCharacter() + 1);
                            ArrayList<Global> droolsElements = (ArrayList<Global>)this.resourcesMap.get(file);
                            if (droolsElements == null) {
                                droolsElements = new ArrayList<Global>();
                                this.resourcesMap.put(file, droolsElements);
                            }
                            droolsElements.add(global);
                        }
                        List functions = drlInfo.getPackageDescr().getFunctions();
                        for (FunctionDescr functionDescr : functions) {
                            String functionName = functionDescr.getName();
                            Function function = DroolsModelBuilder.addFunction(pkg, functionName, file, functionDescr.getStartCharacter(), functionDescr.getEndCharacter() - functionDescr.getStartCharacter() + 1);
                            ArrayList<Function> droolsElements = (ArrayList<Function>)this.resourcesMap.get(file);
                            if (droolsElements == null) {
                                droolsElements = new ArrayList<Function>();
                                this.resourcesMap.put(file, droolsElements);
                            }
                            droolsElements.add(function);
                        }
                    }
                    catch (Throwable t) {
                        DroolsEclipsePlugin.log(t);
                    }
                    return false;
                }
                if ("rf".equals(resource.getFileExtension())) {
                    try {
                        String processString = RulesView.convertToString(file.getContents());
                        ProcessInfo processInfo = DroolsEclipsePlugin.getDefault().parseProcess(processString, resource);
                        if (processInfo != null && processInfo.getProcess() != null) {
                            String packageName = processInfo.getProcess().getPackageName();
                            Package pkg = this.ruleSet.getPackage(packageName);
                            if (pkg == null) {
                                pkg = DroolsModelBuilder.addPackage(this.ruleSet, packageName, 0, 0);
                            }
                            Process process = DroolsModelBuilder.addProcess(pkg, processInfo.getProcess().getId(), file);
                            ArrayList<Process> droolsElements = (ArrayList<Process>)this.resourcesMap.get(file);
                            if (droolsElements == null) {
                                droolsElements = new ArrayList<Process>();
                                this.resourcesMap.put(file, droolsElements);
                            }
                            droolsElements.add(process);
                        }
                    }
                    catch (Throwable t) {
                        DroolsEclipsePlugin.log(t);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResource resource;
            if (event.getType() == 1) {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource = delta.getResource();
                            RulesView.this.removeElementsFromResource(resource);
                            boolean result = true;
                            if (delta.getKind() != 2) {
                                result = RulesView.this.updateResource(resource);
                            }
                            RulesView.this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    if (!RulesView.this.treeViewer.getControl().isDisposed()) {
                                        RulesView.this.treeViewer.refresh();
                                    }
                                }
                            });
                            return result;
                        }
                    });
                }
            } else if (event.getType() == 4) {
                IResource resource2 = event.getResource();
                if (resource2 != null) {
                    resource2.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            RulesView.this.removeElementsFromResource(resource);
                            return true;
                        }
                    });
                }
            } else if (event.getType() == 2 && (resource = event.getResource()) != null) {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        RulesView.this.removeElementsFromResource(resource);
                        return true;
                    }
                });
            }
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
        }
    }

    private void removeElementsFromResource(IResource resource) {
        List droolsElements = (List)this.resourcesMap.get(resource);
        if (droolsElements != null) {
            Iterator iterator = droolsElements.iterator();
            while (iterator.hasNext()) {
                DroolsModelBuilder.removeElement((DroolsElement)iterator.next());
            }
            this.resourcesMap.remove(resource);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        DroolsElement droolsSelected;
        IFile file;
        Object selected;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (selected = ((StructuredSelection)selection).getFirstElement()) != null && selected instanceof DroolsElement && (file = (droolsSelected = (DroolsElement)selected).getFile()) != null) {
            try {
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IFile)file);
                if (editor instanceof FormEditor) {
                    editor = ((FormEditor)editor).getActiveEditor();
                }
                if (editor instanceof ITextEditor) {
                    ((ITextEditor)editor).selectAndReveal(droolsSelected.getOffset(), droolsSelected.getLength());
                }
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
            }
        }
    }

    private static String convertToString(InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }
}

