/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Iterator;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.HierarchyEncoder;
import org.drools.core.util.HierarchyEncoderImpl;
import org.kie.api.runtime.ObjectFilter;

public class IsAEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator ISA = Operator.addOperatorToRegistry("isA", false);
    public static final Operator NOT_ISA = Operator.addOperatorToRegistry("isA", true);
    protected static final String[] SUPPORTED_IDS = new String[]{ISA.getOperatorString()};
    private Evaluator[] evaluator;

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
        IsAEvaluator evaluator = new IsAEvaluator(type, isNegated);
        evaluator.setParameterText(parameterText);
        return evaluator;
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return type.equals(ValueType.TRAIT_TYPE);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluator = (Evaluator[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluator);
    }

    public static class IsAEvaluator
    extends BaseEvaluator {
        public void setParameterText(String parameterText) {
        }

        public IsAEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? NOT_ISA : ISA);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle handle, FieldValue value) {
            Object objectValue = extractor.getValue(workingMemory, handle.getObject());
            Object typeName = value.getValue();
            if (typeName instanceof Class) {
                typeName = ((Class)typeName).getName();
            }
            TraitableBean core = null;
            if (objectValue instanceof Thing) {
                Thing thing = (Thing)objectValue;
                core = (TraitableBean)thing.getCore();
                return this.getOperator().isNegated() ^ core.hasTrait(typeName.toString());
            }
            if (objectValue instanceof TraitableBean) {
                core = (TraitableBean)objectValue;
                return this.getOperator().isNegated() ^ core.hasTrait(typeName.toString());
            }
            core = this.lookForWrapper(objectValue, workingMemory);
            return core == null && this.getOperator().isNegated() || core != null && this.getOperator().isNegated() ^ core.hasTrait(typeName.toString());
        }

        protected TraitableBean lookForWrapper(final Object objectValue, InternalWorkingMemory workingMemory) {
            Iterator iter = workingMemory.getObjectStore().iterateObjects(new ObjectFilter(){

                public boolean accept(Object object) {
                    if (object instanceof TraitProxy) {
                        Object core = ((TraitProxy)object).getObject();
                        if (core instanceof CoreWrapper) {
                            core = ((CoreWrapper)core).getCore();
                        }
                        return core == objectValue;
                    }
                    return false;
                }
            });
            if (iter.hasNext()) {
                return (TraitableBean)((TraitProxy)iter.next()).getObject();
            }
            return null;
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor leftExtractor, InternalFactHandle left, InternalReadAccessor rightExtractor, InternalFactHandle right) {
            Object value1 = leftExtractor.getValue(workingMemory, left);
            Object value2 = rightExtractor.getValue(workingMemory, right);
            Object target = value1;
            Object source = value2;
            return this.compare(source, target, workingMemory);
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object target = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object source = right.getObject();
            return this.compare(source, target, workingMemory);
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object target = left.getObject();
            Object source = context.getObject();
            return this.compare(source, target, workingMemory);
        }

        private boolean compare(Object source, Object target, InternalWorkingMemory workingMemory) {
            TraitableBean tbean;
            HierarchyEncoder x;
            BitSet sourceTraits = null;
            BitSet targetTraits = null;
            if (target instanceof Class) {
                x = ((ReteooRuleBase)workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                targetTraits = x.getCode(((Class)target).getName());
            } else if (target instanceof String) {
                x = ((ReteooRuleBase)workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                targetTraits = x.getCode(target);
            } else if (source instanceof Thing) {
                sourceTraits = ((TraitableBean)((Thing)source).getCore()).getCurrentTypeCode();
            } else if (source instanceof TraitableBean) {
                sourceTraits = ((TraitableBean)source).getCurrentTypeCode();
            } else {
                tbean = this.lookForWrapper(source, workingMemory);
                if (tbean != null) {
                    sourceTraits = tbean.getCurrentTypeCode();
                }
            }
            if (target instanceof Thing) {
                targetTraits = ((TraitableBean)((Thing)target).getCore()).getCurrentTypeCode();
            } else if (target instanceof TraitableBean) {
                targetTraits = ((TraitableBean)target).getCurrentTypeCode();
            } else {
                tbean = this.lookForWrapper(target, workingMemory);
                if (tbean != null) {
                    targetTraits = tbean.getCurrentTypeCode();
                }
            }
            if (sourceTraits == null || targetTraits == null) {
                return this.getOperator().isNegated();
            }
            return HierarchyEncoderImpl.supersetOrEqualset(sourceTraits, targetTraits) ^ this.getOperator().isNegated();
        }

        @Override
        public String toString() {
            return "IsAEvaluatorDefinition isA";
        }
    }
}

