/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.io.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import org.drools.core.io.impl.BaseResource;
import org.drools.core.io.impl.ReaderInputStream;
import org.drools.core.io.internal.InternalResource;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class ReaderResource
extends BaseResource
implements InternalResource {
    private static final long serialVersionUID = -2554750160404141191L;
    private transient Reader reader;
    private String encoding;
    private long timestamp;
    private long lastRead;

    public ReaderResource() {
    }

    public ReaderResource(Reader reader) {
        this(reader, null, null);
    }

    public ReaderResource(Reader reader, ResourceType type) {
        this(reader, null, type);
    }

    public ReaderResource(Reader reader, String encoding) {
        this(reader, encoding, null);
    }

    public ReaderResource(Reader reader, String encoding, ResourceType type) {
        if (reader == null) {
            throw new IllegalArgumentException("reader cannot be null");
        }
        if (encoding == null && reader instanceof InputStreamReader) {
            this.encoding = ((InputStreamReader)reader).getEncoding();
        }
        this.reader = reader;
        this.encoding = encoding;
        this.setResourceType(type);
        this.lastRead = this.timestamp = System.currentTimeMillis();
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException("reader cannot be resolved to URL");
    }

    public InputStream getInputStream() throws IOException {
        try {
            this.reader.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.encoding != null) {
            return new ReaderInputStream(this.reader, this.encoding);
        }
        return new ReaderInputStream(this.reader);
    }

    @Override
    public long getLastModified() {
        return this.timestamp;
    }

    @Override
    public long getLastRead() {
        return this.lastRead;
    }

    public Reader getReader() {
        return this.reader;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public Collection<Resource> listResources() {
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }

    @Override
    public boolean hasURL() {
        return false;
    }

    @Override
    public String toString() {
        return "[ReaderResource resource=" + this.reader + " encoding='" + this.encoding + "']";
    }
}

