/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.ActivationListenerFactory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.mvel.MVELSalienceExpression;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleBuilder;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.builder.AccumulateBuilder;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.BuildUtils;
import org.drools.core.reteoo.builder.CollectBuilder;
import org.drools.core.reteoo.builder.ConditionalBranchBuilder;
import org.drools.core.reteoo.builder.EntryPointBuilder;
import org.drools.core.reteoo.builder.EvalBuilder;
import org.drools.core.reteoo.builder.ForallBuilder;
import org.drools.core.reteoo.builder.FromBuilder;
import org.drools.core.reteoo.builder.GroupElementBuilder;
import org.drools.core.reteoo.builder.NamedConsequenceBuilder;
import org.drools.core.reteoo.builder.PatternBuilder;
import org.drools.core.reteoo.builder.QueryElementBuilder;
import org.drools.core.reteoo.builder.ReteooComponentBuilder;
import org.drools.core.reteoo.builder.WindowBuilder;
import org.drools.core.reteoo.builder.WindowReferenceBuilder;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Collect;
import org.drools.core.rule.ConditionalBranch;
import org.drools.core.rule.EntryPoint;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.Forall;
import org.drools.core.rule.From;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.NamedConsequence;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.QueryElement;
import org.drools.core.rule.Rule;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.rule.WindowReference;
import org.drools.core.time.TemporalDependencyMatrix;
import org.kie.api.conf.EventProcessingOption;

public class ReteooRuleBuilder
implements RuleBuilder {
    protected BuildUtils utils = new BuildUtils();

    public ReteooRuleBuilder() {
        this.utils.addBuilder(GroupElement.class, new GroupElementBuilder());
        this.utils.addBuilder(Pattern.class, new PatternBuilder());
        this.utils.addBuilder(EvalCondition.class, new EvalBuilder());
        this.utils.addBuilder(QueryElement.class, new QueryElementBuilder());
        this.utils.addBuilder(From.class, new FromBuilder());
        this.utils.addBuilder(Collect.class, new CollectBuilder());
        this.utils.addBuilder(Accumulate.class, new AccumulateBuilder());
        this.utils.addBuilder(Forall.class, new ForallBuilder());
        this.utils.addBuilder(EntryPoint.class, new EntryPointBuilder());
        this.utils.addBuilder(WindowReference.class, new WindowReferenceBuilder());
        this.utils.addBuilder(NamedConsequence.class, new NamedConsequenceBuilder());
        this.utils.addBuilder(ConditionalBranch.class, new ConditionalBranchBuilder());
    }

    @Override
    public List<TerminalNode> addRule(Rule rule, InternalRuleBase rulebase, ReteooBuilder.IdGenerator idGenerator) throws InvalidPatternException {
        ArrayList<TerminalNode> nodes = new ArrayList<TerminalNode>();
        GroupElement[] subrules = rule.getTransformedLhs(rulebase.getConfiguration().getComponentFactory().getLogicTransformerFactory().getLogicTransformer());
        for (int i = 0; i < subrules.length; ++i) {
            BuildContext context = new BuildContext(rulebase, idGenerator);
            context.setRule(rule);
            if (EventProcessingOption.STREAM.equals((Object)rulebase.getConfiguration().getEventProcessingMode())) {
                TemporalDependencyMatrix temporal = this.utils.calculateTemporalDistance(subrules[i]);
                context.setTemporalDistance(temporal);
            }
            if (rulebase.getConfiguration().isSequential()) {
                context.setTupleMemoryEnabled(false);
                context.setObjectTypeNodeMemoryEnabled(false);
            } else {
                context.setTupleMemoryEnabled(true);
                context.setObjectTypeNodeMemoryEnabled(true);
            }
            TerminalNode node = this.addSubRule(context, subrules[i], i, rule);
            nodes.add(node);
        }
        return nodes;
    }

    private TerminalNode addSubRule(BuildContext context, GroupElement subrule, int subruleIndex, Rule rule) throws InvalidPatternException {
        ReteooComponentBuilder builder = this.utils.getBuilderFor(subrule);
        if (builder.requiresLeftActivation(this.utils, subrule)) {
            this.addInitialFactPattern(subrule);
        }
        builder.build(context, this.utils, subrule);
        ActivationListenerFactory factory = context.getRuleBase().getConfiguration().getActivationListenerFactory(rule.getActivationListener());
        TerminalNode terminal = factory.createActivationListener(context.getNextId(), context.getTupleSource(), rule, subrule, subruleIndex, context, new Object[0]);
        BaseNode baseTerminalNode = (BaseNode)((Object)terminal);
        baseTerminalNode.networkUpdated(new UpdateContext());
        baseTerminalNode.attach(context);
        if (context.getRuleBase().getConfiguration().isPhreakEnabled() && !ReteooRuleBuilder.unlinkingAllowedForRule(context.getRule())) {
            this.setUnlinkDisabledCount(null, terminal.getLeftTupleSource(), context.getWorkingMemories().length == 0 ? null : context.getWorkingMemories());
        }
        context.getNodes().add(baseTerminalNode);
        return terminal;
    }

    public static boolean unlinkingAllowedForRule(Rule rule) {
        return !rule.isQuery() && rule.getTimer() == null && !rule.getAutoFocus() && !(rule.getSalience() instanceof MVELSalienceExpression);
    }

    public void setUnlinkDisabledCount(LeftTupleSource startNode, LeftTupleSource lt, InternalWorkingMemory[] wms) {
    }

    private void addInitialFactPattern(GroupElement subrule) {
        Pattern pattern = new Pattern(0, ClassObjectType.InitialFact_ObjectType);
        subrule.addChild(0, pattern);
    }

    @Override
    public void addEntryPoint(String id, InternalRuleBase rulebase, ReteooBuilder.IdGenerator idGenerator) {
        BuildContext context = new BuildContext(rulebase, idGenerator);
        EntryPoint ep = new EntryPoint(id);
        ReteooComponentBuilder builder = this.utils.getBuilderFor(ep);
        builder.build(context, this.utils, ep);
    }

    @Override
    public WindowNode addWindowNode(WindowDeclaration window, InternalRuleBase ruleBase, ReteooBuilder.IdGenerator idGenerator) {
        BuildContext context = new BuildContext(ruleBase, idGenerator);
        if (ruleBase.getConfiguration().isSequential()) {
            context.setTupleMemoryEnabled(false);
            context.setObjectTypeNodeMemoryEnabled(false);
        } else {
            context.setTupleMemoryEnabled(true);
            context.setObjectTypeNodeMemoryEnabled(true);
        }
        WindowBuilder builder = WindowBuilder.INSTANCE;
        builder.build(context, this.utils, window);
        return (WindowNode)context.getObjectSource();
    }
}

