/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.runtime.process.NodeInstance;

public class WorkflowRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 8210449548783940188L;
    private long processInstanceId;
    private String processId;
    private long nodeInstanceId;
    private long nodeId;
    private String nodeName;
    private Map<String, Object> variables;

    public WorkflowRuntimeException(Exception e) {
        super(e);
    }

    public WorkflowRuntimeException(NodeInstance nodeInstance, String message, Exception e) {
        super(message, e);
        this.initialize(nodeInstance);
    }

    public WorkflowRuntimeException(NodeInstance nodeInstance, Exception e) {
        super(e);
        this.initialize(nodeInstance);
    }

    private void initialize(NodeInstance nodeInstance) {
        this.processInstanceId = nodeInstance.getProcessInstance().getId();
        this.processId = nodeInstance.getProcessInstance().getProcessId();
        this.nodeInstanceId = nodeInstance.getId();
        this.nodeId = nodeInstance.getNodeId();
        this.nodeName = nodeInstance.getNodeName();
        VariableScopeInstance variableScope = (VariableScopeInstance)((Object)((NodeImpl)((NodeInstanceImpl)nodeInstance).getNode()).getContext("VariableScope"));
        this.variables = variableScope != null ? variableScope.getVariables() : new HashMap<String, Object>(0);
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public long getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    public void setNodeInstanceId(long nodeInstanceId) {
        this.nodeInstanceId = nodeInstanceId;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public String getMessage() {
        return MessageFormat.format("[{0}:{4} - {1}:{2}] -- {3}", this.getProcessId(), this.getNodeName(), this.getNodeId(), this.getCause().getMessage(), this.getProcessInstanceId());
    }
}

