/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.LinkedList;
import java.util.Map;
import org.drools.compiler.compiler.xml.XmlDumper;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BusinessRuleTaskHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        return new RuleSetNode();
    }

    public Class generateNodeFor() {
        return RuleSetNode.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        String ruleFlowGroup = element.getAttribute("ruleFlowGroup");
        if (ruleFlowGroup != null) {
            ruleSetNode.setRuleFlowGroup(ruleFlowGroup);
        }
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, this.dataInputs, this.dataOutputs);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, ruleSetNode, this.dataInputs);
                continue;
            }
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataOutputAssociation(xmlNode, ruleSetNode, this.dataOutputs);
        }
        this.handleScript((ExtendedNodeImpl)ruleSetNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)ruleSetNode, element, "onExit");
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        this.writeNode("businessRuleTask", (Node)ruleSetNode, xmlDump, metaDataType);
        if (ruleSetNode.getRuleFlowGroup() != null) {
            xmlDump.append("g:ruleFlowGroup=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(ruleSetNode.getRuleFlowGroup()) + "\" >" + EOL);
        }
        this.writeScripts((ExtendedNodeImpl)ruleSetNode, xmlDump);
        this.writeIO(ruleSetNode, xmlDump);
        this.endNode("businessRuleTask", xmlDump);
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, RuleSetNode ruleSetNode, Map<String, String> dataInputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            String source = subNode.getTextContent();
            subNode = subNode.getNextSibling();
            String target = subNode.getTextContent();
            LinkedList<Assignment> assignments = new LinkedList<Assignment>();
            for (subNode = subNode.getNextSibling(); subNode != null; subNode = subNode.getNextSibling()) {
                org.w3c.dom.Node ssubNode = subNode.getFirstChild();
                String from = ssubNode.getTextContent();
                String to = ssubNode.getNextSibling().getTextContent();
                assignments.add(new Assignment("XPath", from, to));
            }
            ruleSetNode.addInAssociation(new DataAssociation(source, dataInputs.get(target), assignments, null));
        } else {
            String to = subNode.getTextContent();
            if ((subNode = subNode.getNextSibling()) != null) {
                String text;
                org.w3c.dom.Node subSubNode = subNode.getFirstChild();
                NodeList nl = subSubNode.getChildNodes();
                if (nl.getLength() > 1) {
                    ruleSetNode.setParameter(dataInputs.get(to), (Object)subSubNode.getTextContent());
                    return;
                }
                if (nl.getLength() == 0) {
                    return;
                }
                Object result = null;
                org.w3c.dom.Node from = nl.item(0);
                result = from instanceof Text ? ((text = ((Text)from).getTextContent()).startsWith("\"") && text.endsWith("\"") ? text.substring(1, text.length() - 1) : text) : nl.item(0);
                ruleSetNode.setParameter(dataInputs.get(to), result);
            }
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, RuleSetNode ruleSetNode, Map<String, String> dataOutputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String source = subNode.getTextContent();
        subNode = subNode.getNextSibling();
        String target = subNode.getTextContent();
        LinkedList<Assignment> assignments = new LinkedList<Assignment>();
        for (subNode = subNode.getNextSibling(); subNode != null; subNode = subNode.getNextSibling()) {
            org.w3c.dom.Node ssubNode = subNode.getFirstChild();
            String from = ssubNode.getTextContent();
            String to = ssubNode.getNextSibling().getTextContent();
            assignments.add(new Assignment("XPath", from, to));
        }
        ruleSetNode.addOutAssociation(new DataAssociation(dataOutputs.get(source), target, assignments, null));
    }

    protected void writeIO(RuleSetNode ruleSetNode, StringBuilder xmlDump) {
        xmlDump.append("      <ioSpecification>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("        <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Output\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        xmlDump.append("        <inputSet>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        xmlDump.append("        </inputSet>" + EOL);
        xmlDump.append("        <outputSet>" + EOL);
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("          <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</dataOutputRefs>" + EOL);
        }
        xmlDump.append("        </outputSet>" + EOL);
        xmlDump.append("      </ioSpecification>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL + "        <assignment>" + EOL + "          <from xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)entry.getValue().toString()) + "</from>" + EOL + "          <to xsi:type=\"tFormalExpression\">" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</to>" + EOL + "        </assignment>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</sourceRef>" + EOL + "        <targetRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</targetRef>" + EOL);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
        }
    }
}

