/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.core.rule.Package;
import org.drools.core.util.StringUtils;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.builder.DroolsBuilder;
import org.drools.eclipse.builder.ResourceDescr;
import org.drools.eclipse.builder.Util;
import org.drools.eclipse.dsl.editor.DSLAdapter;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.template.parser.DecisionTableParseException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.compiler.ProcessBuilderImpl;
import org.jbpm.compiler.xml.ProcessSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.osgi.framework.BundleContext;

public class DroolsEclipsePlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 120;
    public static final String PLUGIN_ID = "org.drools.eclipse";
    public static final String BUILD_RESULT_PACKAGE = "Package";
    public static final String BUILD_RESULT_PACKAGE_DESCR = "PackageDescr";
    private static DroolsEclipsePlugin plugin;
    private ResourceBundle resourceBundle;
    private Map<String, Color> colors = new HashMap<String, Color>();
    private Map<IResource, DRLInfo> parsedRules = new HashMap<IResource, DRLInfo>();
    private Map<IResource, DRLInfo> compiledRules = new HashMap<IResource, DRLInfo>();
    private Map<String, DRLInfo.RuleInfo> ruleInfoByClassNameMap = new HashMap<String, DRLInfo.RuleInfo>();
    private Map<String, DRLInfo.FunctionInfo> functionInfoByClassNameMap = new HashMap<String, DRLInfo.FunctionInfo>();
    private Map<IResource, ProcessInfo> processInfos = new HashMap<IResource, ProcessInfo>();
    private Map<String, ProcessInfo> processInfosById = new HashMap<String, ProcessInfo>();
    private boolean useCachePreference;
    private FormColors ruleBuilderFormColors;
    private boolean forceFullBuild;

    public DroolsEclipsePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.useCachePreference = preferenceStore.getBoolean("Drools.CacheParsedRules");
        preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("Drools.CacheParsedRules".equals(event.getProperty())) {
                    DroolsEclipsePlugin.this.useCachePreference = (Boolean)event.getNewValue();
                    if (!DroolsEclipsePlugin.this.useCachePreference) {
                        DroolsEclipsePlugin.this.clearCache();
                    }
                }
            }
        });
    }

    public void clearCache() {
        this.parsedRules.clear();
        this.compiledRules.clear();
        this.ruleInfoByClassNameMap.clear();
        this.functionInfoByClassNameMap.clear();
        this.processInfos.clear();
        this.processInfosById = null;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
        this.parsedRules = null;
        this.compiledRules = null;
        this.processInfos = null;
        this.processInfosById = null;
        for (Color color : this.colors.values()) {
            color.dispose();
        }
    }

    public static DroolsEclipsePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = DroolsEclipsePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("droolsIDE.DroolsIDEPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        DroolsEclipsePlugin plugin = DroolsEclipsePlugin.getDefault();
        ImageRegistry reg = plugin.getImageRegistry();
        ImageDescriptor des = reg.getDescriptor(path);
        if (des == null) {
            des = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
            reg.put(path, des);
        }
        return des;
    }

    public static String getUniqueIdentifier() {
        if (DroolsEclipsePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return DroolsEclipsePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(Throwable t) {
        DebugException de;
        IStatus status;
        Throwable top = t;
        if (t instanceof DebugException && (status = (de = (DebugException)t).getStatus()).getException() != null) {
            top = status.getException();
        }
        DroolsEclipsePlugin.log((IStatus)new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), 120, "Internal error in Drools Plugin: ", top));
    }

    public static void log(IStatus status) {
        DroolsEclipsePlugin.getDefault().getLog().log(status);
    }

    public Color getColor(String type) {
        return this.colors.get(type);
    }

    public void setColor(String type, Color color) {
        this.colors.put(type, color);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("Drools.BuildAll", false);
        store.setDefault("Drools.CrossBuild", false);
        store.setDefault("Drools.EditorFolding", true);
        store.setDefault("Drools.CacheParsedRules", true);
        store.setDefault("Drools.DSLRuleEditorCompletionFullSentences", true);
        store.setDefault("Drools.Flow.Skin", "BPMN2");
        store.setDefault("Drools.Flow.AllowNodeCustomization", false);
        store.setDefault("Drools.InternalAPI", 2);
        store.setDefault("Drools.FlowNodes", "1111111111111");
    }

    public List<DRLInfo> parseResources(List<ResourceDescr> resources) {
        ArrayList<ResourceDescr> toBeCompiled = new ArrayList<ResourceDescr>();
        ArrayList<DRLInfo> infos = new ArrayList<DRLInfo>();
        for (ResourceDescr resourceDescr : resources) {
            DRLInfo result = this.getExistingInfoForResource(resourceDescr.getResource(), true);
            if (result != null) {
                infos.add(result);
                continue;
            }
            toBeCompiled.add(resourceDescr);
        }
        infos.addAll(this.buildResources(toBeCompiled));
        return infos;
    }

    private List<DRLInfo> buildResources(List<ResourceDescr> resources) {
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            HashMap<Resource, ResourceDescr> resourceMap = new HashMap<Resource, ResourceDescr>();
            KnowledgeBuilder kbuilder = this.compositeBuild(resources, resourceMap);
            PackageBuilder packageBuilder = ((KnowledgeBuilderImpl)kbuilder).getPackageBuilder();
            Map<IResource, DRLInfo> infoMap = this.collectDRLInfo(resourceMap, packageBuilder);
            this.collectErrors(resourceMap, kbuilder, packageBuilder, infoMap);
            for (DRLInfo drlInfo : infoMap.values()) {
                Object[] objectArray = drlInfo.getRuleInfos();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DRLInfo.RuleInfo ruleInfo = objectArray[n2];
                    this.ruleInfoByClassNameMap.put(ruleInfo.getClassName(), ruleInfo);
                    ++n2;
                }
                objectArray = drlInfo.getFunctionInfos();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Object functionInfo = objectArray[n2];
                    this.functionInfoByClassNameMap.put(((DRLInfo.FunctionInfo)functionInfo).getClassName(), (DRLInfo.FunctionInfo)functionInfo);
                    ++n2;
                }
            }
            this.compiledRules = infoMap;
            ArrayList<DRLInfo> arrayList = new ArrayList<DRLInfo>(infoMap.values());
            return arrayList;
        }
        catch (CoreException e) {
            DroolsEclipsePlugin.log(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        return Collections.emptyList();
    }

    private KnowledgeBuilder compositeBuild(List<ResourceDescr> resources, Map<Resource, ResourceDescr> resourceMap) throws CoreException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)this.getBuilderConfiguration(resources));
        CompositeKnowledgeBuilder compositeKBuilder = kbuilder.batch();
        for (ResourceDescr resourceDescr : resources) {
            Resource resource = resourceDescr.getContentAsDroolsResource();
            resourceMap.put(resource, resourceDescr);
            compositeKBuilder.add(resource, resourceDescr.getType());
        }
        try {
            compositeKBuilder.build();
        }
        catch (DecisionTableParseException decisionTableParseException) {}
        return kbuilder;
    }

    private Map<IResource, DRLInfo> collectDRLInfo(Map<Resource, ResourceDescr> resourceMap, PackageBuilder packageBuilder) {
        HashMap<IResource, DRLInfo> infoMap = new HashMap<IResource, DRLInfo>();
        for (Map.Entry<Resource, PackageDescr> entry : this.groupPackageDescrByResource(packageBuilder).entrySet()) {
            ResourceDescr resourceDescr = resourceMap.get(entry.getKey());
            if (resourceDescr == null) continue;
            PackageDescr packageDescr = entry.getValue();
            DRLInfo info = new DRLInfo(resourceDescr.getSourcePathName(), packageDescr, new ArrayList<DroolsError>(), packageBuilder.getPackageRegistry(packageDescr.getNamespace()).getPackage(), new DroolsError[0], packageBuilder.getPackageRegistry(packageDescr.getNamespace()).getDialectCompiletimeRegistry());
            info.setResource(resourceDescr.getResource());
            infoMap.put(resourceDescr.getResource(), info);
        }
        return infoMap;
    }

    private void collectErrors(Map<Resource, ResourceDescr> resourceMap, KnowledgeBuilder kbuilder, PackageBuilder packageBuilder, Map<IResource, DRLInfo> infoMap) {
        for (KnowledgeBuilderError error : kbuilder.getErrors()) {
            Resource resource;
            if (!(error instanceof DroolsError) || (resource = error.getResource()) == null) continue;
            ResourceDescr resourceDescr = resourceMap.get(resource);
            DroolsError droolsError = (DroolsError)error;
            String pkgName = droolsError.getNamespace();
            List packageDescrs = packageBuilder.getPackageDescrs(pkgName);
            if (packageDescrs == null || packageDescrs.isEmpty()) continue;
            PackageDescr packageDescr = (PackageDescr)packageDescrs.get(0);
            DRLInfo info = infoMap.get(resourceDescr.getResource());
            if (info == null) {
                info = new DRLInfo(resourceDescr.getResource().getName(), packageDescr, (List<DroolsError>)new ArrayList<DroolsError>(droolsError){
                    {
                        this.add(droolsError);
                    }
                }, packageBuilder.getPackageRegistry(packageDescr.getNamespace()).getDialectCompiletimeRegistry());
                info.setResource(resourceDescr.getResource());
                infoMap.put(resourceDescr.getResource(), info);
                continue;
            }
            info.addError(droolsError);
        }
    }

    private Map<Resource, PackageDescr> groupPackageDescrByResource(PackageBuilder packageBuilder) {
        HashMap<Resource, PackageDescr> map = new HashMap<Resource, PackageDescr>();
        for (String pkgName : packageBuilder.getPackageNames()) {
            for (PackageDescr pkgDescr : packageBuilder.getPackageDescrs(pkgName)) {
                for (ImportDescr importDescr : pkgDescr.getImports()) {
                    this.getPkgDescr(map, (BaseDescr)importDescr, pkgName).addImport(importDescr);
                }
                for (FunctionImportDescr function : pkgDescr.getFunctionImports()) {
                    this.getPkgDescr(map, (BaseDescr)function, pkgName).addFunctionImport(function);
                }
                for (AttributeDescr attribute : pkgDescr.getAttributes()) {
                    this.getPkgDescr(map, (BaseDescr)attribute, pkgName).addAttribute(attribute);
                }
                for (GlobalDescr global : pkgDescr.getGlobals()) {
                    this.getPkgDescr(map, (BaseDescr)global, pkgName).addGlobal(global);
                }
                for (FunctionImportDescr function : pkgDescr.getFunctions()) {
                    this.getPkgDescr(map, (BaseDescr)function, pkgName).addFunction((FunctionDescr)function);
                }
                for (TypeDeclarationDescr type : pkgDescr.getTypeDeclarations()) {
                    this.getPkgDescr(map, (BaseDescr)type, pkgName).addTypeDeclaration(type);
                }
                for (RuleDescr rule : pkgDescr.getRules()) {
                    this.getPkgDescr(map, (BaseDescr)rule, pkgName).addRule(rule);
                }
                for (EnumDeclarationDescr enumDescr : pkgDescr.getEnumDeclarations()) {
                    this.getPkgDescr(map, (BaseDescr)enumDescr, pkgName).addEnumDeclaration(enumDescr);
                }
            }
        }
        return map;
    }

    private PackageDescr getPkgDescr(Map<Resource, PackageDescr> map, BaseDescr descr, String pkgName) {
        Resource resource = descr.getResource();
        PackageDescr resourceDescr = map.get(resource);
        if (resourceDescr == null) {
            resourceDescr = new PackageDescr();
            resourceDescr.setNamespace(pkgName);
            map.put(resource, resourceDescr);
        }
        return resourceDescr;
    }

    private PackageBuilderConfiguration getBuilderConfiguration(List<ResourceDescr> resources) throws CoreException {
        ClassLoader newLoader = DroolsBuilder.class.getClassLoader();
        IResource firstResource = resources.get(0).getResource();
        String level = null;
        if (firstResource.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
            IJavaProject project = JavaCore.create((IProject)firstResource.getProject());
            newLoader = ProjectClassLoader.getProjectClassLoader(project);
            level = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        }
        Thread.currentThread().setContextClassLoader(newLoader);
        PackageBuilderConfiguration builderConfiguration = new PackageBuilderConfiguration();
        if (level != null) {
            JavaDialectConfiguration javaConf = (JavaDialectConfiguration)builderConfiguration.getDialectConfiguration("java");
            javaConf.setJavaLanguageLevel(level);
        }
        return builderConfiguration;
    }

    public DRLInfo parseResource(IResource resource, boolean compile) throws DroolsParserException {
        DRLInfo result = this.getExistingInfoForResource(resource, compile);
        if (result != null) {
            return result;
        }
        return this.generateParsedResource(resource, compile);
    }

    private DRLInfo getExistingInfoForResource(IResource resource, boolean compile) {
        DRLInfo result = this.compiledRules.get(resource);
        if (result == null && !compile) {
            result = this.parsedRules.get(resource);
        }
        return result;
    }

    public DRLInfo parseResource(AbstractRuleEditor editor, boolean useUnsavedContent, boolean compile) throws DroolsParserException {
        IResource resource = editor.getResource();
        if (!editor.isDirty() || !useUnsavedContent) {
            DRLInfo result = this.compiledRules.get(resource);
            if (result == null && !compile) {
                result = this.parsedRules.get(resource);
            }
            if (result != null) {
                return result;
            }
        }
        if (!editor.isDirty()) {
            return this.generateParsedResource(editor.getContent(), resource, true, compile);
        }
        return this.generateParsedResource(editor.getContent(), resource, !useUnsavedContent, compile);
    }

    public DRLInfo parseXLSResource(String content, IResource resource) throws DroolsParserException {
        DRLInfo result = this.compiledRules.get(resource);
        if (result != null) {
            return result;
        }
        return this.generateParsedResource(content, resource, false, true);
    }

    public DRLInfo parseBRLResource(String content, IResource resource) throws DroolsParserException {
        DRLInfo result = this.compiledRules.get(resource);
        if (result != null) {
            return result;
        }
        return this.generateParsedResource(content, resource, false, true);
    }

    public DRLInfo parseGDSTResource(String content, IResource resource) throws DroolsParserException {
        DRLInfo result = this.compiledRules.get(resource);
        if (result != null) {
            return result;
        }
        return this.generateParsedResource(content, resource, false, true);
    }

    public void invalidateResource(IResource resource) {
        DRLInfo cached = this.compiledRules.remove(resource);
        if (cached != null) {
            DRLInfo.RuleInfo[] ruleInfos = cached.getRuleInfos();
            int i = 0;
            while (i < ruleInfos.length) {
                this.ruleInfoByClassNameMap.remove(ruleInfos[i].getClassName());
                ++i;
            }
            DRLInfo.FunctionInfo[] functionInfos = cached.getFunctionInfos();
            int i2 = 0;
            while (i2 < functionInfos.length) {
                this.functionInfoByClassNameMap.remove(functionInfos[i2].getClassName());
                ++i2;
            }
        }
        this.parsedRules.remove(resource);
        ProcessInfo processInfo = this.processInfos.remove(resource);
        if (processInfo != null) {
            this.processInfosById.remove(processInfo.getProcessId());
        }
    }

    private DRLInfo generateParsedResource(IResource resource, boolean compile) throws DroolsParserException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            try {
                String content = new String(Util.getResourceContentsAsCharArray(file));
                return this.generateParsedResource(content, (IResource)file, true, compile);
            }
            catch (CoreException e) {
                DroolsEclipsePlugin.log(e);
            }
        }
        return null;
    }

    public DRLInfo generateParsedResource(String content, IResource resource, boolean useCache, boolean compile) throws DroolsParserException {
        useCache = useCache && this.useCachePreference;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newLoader = DroolsBuilder.class.getClassLoader();
        String level = null;
        if (resource != null && resource.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
            IJavaProject project = JavaCore.create((IProject)resource.getProject());
            newLoader = ProjectClassLoader.getProjectClassLoader(project);
            level = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        }
        try {
            DRLInfo cachedDrlInfo;
            Thread.currentThread().setContextClassLoader(newLoader);
            PackageBuilderConfiguration builder_configuration = new PackageBuilderConfiguration(new ClassLoader[]{newLoader});
            if (level != null) {
                JavaDialectConfiguration javaConf = (JavaDialectConfiguration)builder_configuration.getDialectConfiguration("java");
                javaConf.setJavaLanguageLevel(level);
            }
            PackageDescr packageDescr = null;
            List parserErrors = null;
            if (useCache && resource != null && (cachedDrlInfo = this.parsedRules.get(resource)) != null) {
                packageDescr = cachedDrlInfo.getPackageDescr();
                parserErrors = cachedDrlInfo.getParserErrors();
            }
            DrlParser parser = new DrlParser();
            if (packageDescr == null) {
                Reader dslReader = DSLAdapter.getDSLContent(content, resource);
                packageDescr = dslReader != null ? parser.parse(true, content, dslReader) : parser.parse(true, content);
                parserErrors = parser.getErrors();
            }
            PackageBuilder builder = new PackageBuilder(builder_configuration);
            DRLInfo result = null;
            if (packageDescr != null && compile && !parser.hasErrors()) {
                if (resource != null && resource.getParent() != null) {
                    PackageDescr desc;
                    MyResourceVisitor visitor = new MyResourceVisitor();
                    resource.getParent().accept((IResourceVisitor)visitor, 1, 0);
                    IResource packageDef = visitor.getPackageDef();
                    if (packageDef != null && (desc = this.parseResource(packageDef, false).getPackageDescr()) != null) {
                        builder.addPackage(desc);
                    }
                }
                builder.addPackage(packageDescr);
                if (StringUtils.isEmpty((CharSequence)packageDescr.getNamespace())) {
                    packageDescr.setNamespace(builder.getPackageBuilderConfiguration().getDefaultPackageName());
                }
                result = new DRLInfo(resource == null ? "" : resource.getProjectRelativePath().toString(), packageDescr, parserErrors, builder.getPackageRegistry(packageDescr.getNamespace()).getPackage(), builder.getErrors().getErrors(), builder.getPackageRegistry(packageDescr.getNamespace()).getDialectCompiletimeRegistry());
            } else {
                result = new DRLInfo(resource == null ? "" : resource.getProjectRelativePath().toString(), packageDescr, parserErrors, new PackageRegistry(builder, new Package("")).getDialectCompiletimeRegistry());
            }
            if (useCache && resource != null) {
                if (compile && !parser.hasErrors()) {
                    this.parsedRules.remove(resource);
                    this.compiledRules.put(resource, result);
                    DRLInfo.RuleInfo[] ruleInfos = result.getRuleInfos();
                    int i = 0;
                    while (i < ruleInfos.length) {
                        this.ruleInfoByClassNameMap.put(ruleInfos[i].getClassName(), ruleInfos[i]);
                        ++i;
                    }
                    DRLInfo.FunctionInfo[] functionInfos = result.getFunctionInfos();
                    int i2 = 0;
                    while (i2 < functionInfos.length) {
                        this.functionInfoByClassNameMap.put(functionInfos[i2].getClassName(), functionInfos[i2]);
                        ++i2;
                    }
                } else {
                    this.parsedRules.put(resource, result);
                }
            }
            DRLInfo dRLInfo = result;
            Thread.currentThread().setContextClassLoader(oldLoader);
            return dRLInfo;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(oldLoader);
                throw throwable;
            }
            catch (CoreException e) {
                DroolsEclipsePlugin.log(e);
                return null;
            }
        }
    }

    public DRLInfo.RuleInfo getRuleInfoByClass(String ruleClassName) {
        return this.ruleInfoByClassNameMap.get(ruleClassName);
    }

    public DRLInfo.FunctionInfo getFunctionInfoByClass(String functionClassName) {
        return this.functionInfoByClassNameMap.get(functionClassName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessInfo parseProcess(String input, IResource resource) throws Exception {
        try {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader newLoader = ((Object)((Object)this)).getClass().getClassLoader();
            String level = null;
            if (resource.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
                IJavaProject project = JavaCore.create((IProject)resource.getProject());
                newLoader = ProjectClassLoader.getProjectClassLoader(project);
                level = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            }
            try {
                Thread.currentThread().setContextClassLoader(newLoader);
                PackageBuilderConfiguration configuration = new PackageBuilderConfiguration();
                if (level != null) {
                    JavaDialectConfiguration javaConf = (JavaDialectConfiguration)configuration.getDialectConfiguration("java");
                    javaConf.setJavaLanguageLevel(level);
                }
                SemanticModules modules = configuration.getSemanticModules();
                modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
                modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
                modules.addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
                modules.addSemanticModule((SemanticModule)new ProcessSemanticModule());
                XmlProcessReader xmlReader = new XmlProcessReader(modules, Thread.currentThread().getContextClassLoader());
                List processes = xmlReader.read((Reader)new StringReader(input));
                if (processes == null) return null;
                Iterator iterator = processes.iterator();
                if (!iterator.hasNext()) return null;
                Process process = (Process)iterator.next();
                if (process == null) throw new IllegalArgumentException("Could not parse process " + resource);
                ProcessInfo processInfo = this.parseProcess((org.jbpm.process.core.Process)process, resource, configuration);
                return processInfo;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
        catch (Exception e) {
            DroolsEclipsePlugin.log(e);
            throw e;
        }
    }

    public ProcessInfo getProcessInfo(String processId) {
        return this.processInfosById.get(processId);
    }

    public Map<ProcessInfo, List<RuleSetNode>> getRuleSetNodeByFlowGroup(String flowGroup) {
        HashMap<ProcessInfo, List<RuleSetNode>> result = new HashMap<ProcessInfo, List<RuleSetNode>>();
        for (ProcessInfo processInfo : this.processInfosById.values()) {
            Node[] nodes = ((RuleFlowProcess)processInfo.getProcess()).getNodes();
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i] instanceof RuleSetNode && flowGroup.equals(((RuleSetNode)nodes[i]).getRuleFlowGroup())) {
                    if (!result.containsKey(processInfo)) {
                        result.put(processInfo, new ArrayList());
                    }
                    ((List)result.get(processInfo)).add((RuleSetNode)nodes[i]);
                }
                ++i;
            }
        }
        return result;
    }

    public IResource findProcessResource(String processId) {
        if (processId == null) {
            return null;
        }
        for (Map.Entry<IResource, ProcessInfo> entry : this.processInfos.entrySet()) {
            if (!processId.equals(entry.getValue().getProcessId())) continue;
            return entry.getKey();
        }
        return null;
    }

    public ProcessInfo parseProcess(org.jbpm.process.core.Process process, IResource resource, PackageBuilderConfiguration config) {
        PackageBuilder packageBuilder = new PackageBuilder(config);
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, ResourceFactory.newUrlResource((String)("file://" + resource.getLocation().toString())));
        ProcessInfo processInfo = new ProcessInfo(process.getId(), (Process)process);
        ArrayList<DroolsError> errors = new ArrayList<DroolsError>();
        errors.addAll(processBuilder.getErrors());
        errors.addAll(Arrays.asList(packageBuilder.getErrors().getErrors()));
        processInfo.setErrors(errors);
        if (this.useCachePreference) {
            this.processInfos.put(resource, processInfo);
            this.processInfosById.put(process.getId(), processInfo);
        }
        return processInfo;
    }

    public FormColors getRuleBuilderFormColors(Display display) {
        if (this.ruleBuilderFormColors == null) {
            this.ruleBuilderFormColors = new FormColors(display);
            this.ruleBuilderFormColors.markShared();
        }
        return this.ruleBuilderFormColors;
    }

    public boolean resetForceFullBuild() {
        boolean isFullBuild = this.forceFullBuild;
        this.forceFullBuild = false;
        return isFullBuild;
    }

    public void setForceFullBuild() {
        this.forceFullBuild = true;
    }

    private class MyResourceVisitor
    implements IResourceVisitor {
        private IResource packageDef;

        private MyResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if ("package".equals(resource.getFileExtension())) {
                this.packageDef = resource;
            }
            return true;
        }

        public IResource getPackageDef() {
            return this.packageDef;
        }
    }
}

