/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.eclipse.editors.completion.RuleCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractCompletionProcessor
implements IContentAssistProcessor {
    private IEditorPart editor;

    public AbstractCompletionProcessor(IEditorPart editor) {
        this.editor = editor;
    }

    protected IEditorPart getEditor() {
        return this.editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        List proposals = this.getCompletionProposals(viewer, documentOffset);
        if (proposals == null) {
            return new ICompletionProposal[0];
        }
        Collections.sort(proposals, new RuleCompletionProposal.RuleCompletionProposalComparator());
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    protected abstract List getCompletionProposals(ITextViewer var1, int var2);

    protected static void filterProposalsOnPrefix(String prefix, List props) {
        if (prefix != null && prefix.trim().length() > 0) {
            Iterator iterator = props.iterator();
            String prefixLc = prefix.toLowerCase();
            while (iterator.hasNext()) {
                ICompletionProposal item = (ICompletionProposal)iterator.next();
                String content = item.getDisplayString().toLowerCase();
                if (content.toLowerCase().startsWith(prefixLc)) continue;
                iterator.remove();
            }
        }
    }

    protected String readBackwards(int documentOffset, IDocument doc) throws BadLocationException {
        int startPart = doc.getPartition(documentOffset).getOffset();
        String prefix = doc.get(startPart, documentOffset - startPart);
        return prefix;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

