/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorRepository;

public class GuvnorLocationManager {
    private static final String REP_CACHE_NAME = ".replist";
    private static final String HAS_REPOSITORY_PROPERTY = "org.guvnor.tools.repositoryExist";
    private ArrayList<GuvnorRepository> repList = new ArrayList();
    private List<IRepositorySetListener> repsetListeners = new ArrayList<IRepositorySetListener>();

    GuvnorLocationManager() {
        try {
            this.load();
            this.updateSystemProperty();
        }
        catch (Exception e) {
            Activator.getDefault().writeLog(4, e.getMessage(), e);
        }
    }

    private void updateSystemProperty() {
        if (this.getRepositories().size() > 0) {
            System.setProperty(HAS_REPOSITORY_PROPERTY, "true");
        } else {
            System.setProperty(HAS_REPOSITORY_PROPERTY, "false");
        }
    }

    public void addRespository(String location) throws Exception {
        this.addRepository(new GuvnorRepository(location));
    }

    public void addRepository(GuvnorRepository rep) throws Exception {
        if (this.findRepository(rep.getLocation()) != null) {
            throw new Exception("Duplicate repository: " + rep.getLocation());
        }
        this.repList.add(rep);
        this.notifyListeners(0);
        try {
            this.commit();
            this.updateSystemProperty();
        }
        catch (Exception e) {
            Activator.getDefault().displayError(4, e.getMessage(), e, true);
        }
    }

    public List<GuvnorRepository> getRepositories() {
        return this.repList;
    }

    public boolean removeRepository(String rep) {
        GuvnorRepository theRep;
        boolean res;
        block3: {
            res = false;
            theRep = this.findRepository(rep);
            if (theRep != null) break block3;
            return false;
        }
        try {
            res = this.repList.remove(theRep);
            Platform.flushAuthorizationInfo((URL)new URL(rep), (String)"", (String)"basic");
            Activator.getLocationManager().removeRepository(theRep.getLocation());
            this.notifyListeners(0);
            this.commit();
            this.updateSystemProperty();
        }
        catch (Exception e) {
            Activator.getDefault().displayError(4, e.getMessage(), e, true);
        }
        return res;
    }

    public GuvnorRepository findRepository(String rep) {
        GuvnorRepository theRep = null;
        int i = 0;
        while (i < this.repList.size()) {
            if (this.repList.get(i).getLocation().equals(rep)) {
                theRep = this.repList.get(i);
                break;
            }
            ++i;
        }
        return theRep;
    }

    private void commit() throws Exception {
        File repFile = Activator.getDefault().getStateLocation().append(REP_CACHE_NAME).toFile();
        FileOutputStream fos = null;
        PrintWriter writer = null;
        try {
            fos = new FileOutputStream(repFile);
            writer = new PrintWriter(fos);
            int i = 0;
            while (i < this.repList.size()) {
                GuvnorRepository oneRep = this.repList.get(i);
                writer.println(oneRep.getLocation());
                ++i;
            }
            writer.flush();
            fos.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void load() throws Exception {
        this.repList.clear();
        File repFile = Activator.getDefault().getStateLocation().append(REP_CACHE_NAME).toFile();
        if (!repFile.exists()) {
            return;
        }
        FileInputStream fis = null;
        BufferedReader reader = null;
        try {
            fis = new FileInputStream(repFile);
            reader = new BufferedReader(new InputStreamReader(fis));
            String oneRep = null;
            do {
                if ((oneRep = reader.readLine()) == null || oneRep.trim().length() <= 0) continue;
                this.repList.add(new GuvnorRepository(oneRep));
            } while (oneRep != null);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public boolean addRepositorySetListener(IRepositorySetListener listener) {
        return this.repsetListeners.add(listener);
    }

    public boolean removeRepositorySetListener(IRepositorySetListener listener) {
        return this.repsetListeners.remove(listener);
    }

    private void notifyListeners(int eventType) {
        int i = 0;
        while (i < this.repsetListeners.size()) {
            try {
                this.repsetListeners.get(i).repositorySetChanged(eventType, this.repList);
            }
            catch (Throwable t) {
                Activator.getDefault().writeLog(4, t.getMessage(), t);
            }
            ++i;
        }
    }

    public static interface IRepositorySetListener {
        public static final int REP_ADDED = 0;
        public static final int REP_REMOVED = 1;

        public void repositorySetChanged(int var1, List<GuvnorRepository> var2);
    }
}

