/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.reteoo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.BaseNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.util.ObjectHashMap;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.eclipse.editors.rete.model.Connection;
import org.drools.eclipse.editors.rete.model.ReteGraph;
import org.drools.eclipse.reteoo.BaseVertex;
import org.drools.eclipse.reteoo.ReteVertex;

public class ReteooVisitor
extends ReflectiveVisitor {
    private static final String PACKAGE_NAME = "org.drools.eclipse.reteoo.";
    private final Map<String, BaseVertex> visitedNodes = new HashMap<String, BaseVertex>();
    private ReteGraph graph;
    private BaseVertex rootVertex;
    private BaseVertex parentVertex;

    public ReteooVisitor(ReteGraph graph) {
        this.graph = graph;
    }

    public ReteGraph getGraph() {
        return this.graph;
    }

    public BaseVertex getRootVertex() {
        return this.rootVertex;
    }

    public void visitReteooRuleBase(ReteooRuleBase ruleBase) {
        this.visit(ruleBase.getRete());
    }

    public void visitRete(Rete rete) {
        this.rootVertex = (ReteVertex)this.visitedNodes.get(ReteooVisitor.dotId(rete));
        if (this.rootVertex == null) {
            this.rootVertex = new ReteVertex(rete);
            this.visitedNodes.put(ReteooVisitor.dotId(rete), this.rootVertex);
        }
        this.graph.addChild(this.rootVertex);
        this.parentVertex = this.rootVertex;
        for (EntryPointNode node : rete.getEntryPointNodes().values()) {
            this.visit(node);
        }
    }

    public void visitBaseNode(BaseNode node) {
        BaseVertex vertex = this.visitedNodes.get(ReteooVisitor.dotId(node));
        if (vertex == null) {
            try {
                String name = node.getClass().getName();
                name = String.valueOf(name.substring(name.lastIndexOf(46) + 1)) + "Vertex";
                Class<?> clazz = Class.forName(PACKAGE_NAME + name);
                vertex = (BaseVertex)clazz.getConstructor(node.getClass()).newInstance(node);
            }
            catch (Exception e) {
                throw new RuntimeException("problem visiting vertex " + node.getClass().getName(), e);
            }
            this.graph.addChild(vertex);
            this.visitedNodes.put(ReteooVisitor.dotId(node), vertex);
            new Connection(this.parentVertex, vertex);
            BaseVertex oldParentVertex = this.parentVertex;
            this.parentVertex = vertex;
            List<Object> list = null;
            if (node instanceof EntryPointNode) {
                list = new ArrayList(((EntryPointNode)node).getObjectTypeNodes().values());
            } else if (node instanceof ObjectSource) {
                list = Arrays.asList(((ObjectSource)node).getSinkPropagator().getSinks());
            } else if (node instanceof LeftTupleSource) {
                list = Arrays.asList(((LeftTupleSource)node).getSinkPropagator().getSinks());
            }
            if (list != null) {
                for (Object nextNode : list) {
                    this.visitNode(nextNode);
                }
            }
            this.parentVertex = oldParentVertex;
        } else {
            new Connection(this.parentVertex, vertex);
        }
    }

    private void visitNode(Object node) {
        Object realNode = node;
        if (node instanceof ObjectHashMap.ObjectEntry) {
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)node;
            realNode = entry.getValue();
        }
        this.visit(realNode);
    }

    private static String dotId(Object object) {
        return Integer.toHexString(System.identityHashCode(object)).toUpperCase();
    }
}

