/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionSynchronization;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.drools.persistence.map.KnowledgeSessionStorage;
import org.drools.persistence.map.NonTransactionalPersistentSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualTransactionManager
implements TransactionManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private NonTransactionalPersistentSession session;
    private KnowledgeSessionStorage storage;
    private TransactionSynchronization transactionSynchronization;
    private static final ThreadLocal<Map<Object, Object>> transactionResources = new ThreadLocal<Map<Object, Object>>(){

        @Override
        protected Map<Object, Object> initialValue() {
            return Collections.synchronizedMap(new HashMap());
        }
    };

    public ManualTransactionManager(NonTransactionalPersistentSession session, KnowledgeSessionStorage storage) {
        this.session = session;
        this.storage = storage;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public boolean begin() {
        return true;
    }

    @Override
    public void commit(boolean transactionOwner) {
        try {
            for (SessionInfo sessionInfo : this.session.getStoredKnowledgeSessions()) {
                sessionInfo.update();
                this.storage.saveOrUpdate(sessionInfo);
            }
            for (WorkItemInfo workItemInfo : this.session.getStoredWorkItems()) {
                workItemInfo.update();
                this.storage.saveOrUpdate(workItemInfo);
            }
            try {
                this.transactionSynchronization.afterCompletion(0);
            }
            catch (RuntimeException re) {
                this.logger.warn("Unable to synchronize transaction after commit, see cause.", (Throwable)re);
            }
        }
        catch (RuntimeException re) {
            this.transactionSynchronization.afterCompletion(1);
        }
    }

    @Override
    public void rollback(boolean transactionOwner) {
    }

    @Override
    public void registerTransactionSynchronization(TransactionSynchronization ts) {
        this.transactionSynchronization = ts;
    }

    @Override
    public void putResource(Object key, Object resource) {
        transactionResources.get().put(key, resource);
    }

    @Override
    public Object getResource(Object key) {
        return transactionResources.get().get(key);
    }
}

