/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.http.client.IRequestBodyWriter;
import org.eclipse.webdav.http.client.Message;
import org.eclipse.webdav.http.client.RequestInputStream;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class Request
extends Message {
    private String method;
    private URL resourceUrl;
    private IRequestBodyWriter requestBodyWriter;

    public Request(String method, URL resourceUrl, IContext context) {
        super(context, new RequestInputStream(new byte[0]));
        Assert.isNotNull(method);
        Assert.isNotNull(resourceUrl);
        this.method = method;
        this.resourceUrl = resourceUrl;
    }

    public Request(String method, URL resourceUrl, IContext context, InputStream is) throws IOException {
        super(context, is == null ? new RequestInputStream(new byte[0]) : (is instanceof RequestInputStream ? is : (is instanceof ByteArrayInputStream ? new RequestInputStream((ByteArrayInputStream)is) : new RequestInputStream(is, -1L))));
        Assert.isNotNull(method);
        Assert.isNotNull(resourceUrl);
        this.method = method;
        this.resourceUrl = resourceUrl;
    }

    public Request(String method, URL resourceUrl, IContext context, IRequestBodyWriter requestBodyWriter) {
        super(context, new RequestInputStream(new byte[0]));
        Assert.isNotNull(method);
        Assert.isNotNull(resourceUrl);
        Assert.isNotNull(requestBodyWriter);
        this.method = method;
        this.resourceUrl = resourceUrl;
        this.requestBodyWriter = requestBodyWriter;
    }

    @Override
    public long getContentLength() {
        long contentLength = super.getContentLength();
        if (contentLength != -1L) {
            return contentLength;
        }
        if (this.requestBodyWriter == null) {
            return ((RequestInputStream)this.is).length();
        }
        return -1L;
    }

    public String getMethod() {
        return this.method;
    }

    public IRequestBodyWriter getRequestBodyWriter() {
        return this.requestBodyWriter;
    }

    public URL getResourceUrl() {
        return this.resourceUrl;
    }

    void setResourceUrl(URL resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.method);
        buffer.append(' ');
        buffer.append(this.resourceUrl);
        buffer.append('\n');
        buffer.append(super.toString());
        return buffer.toString();
    }

    @Override
    public void write(OutputStream os) throws IOException {
        if (this.requestBodyWriter == null) {
            if (this.inputRead) {
                this.is.reset();
                this.inputRead = false;
            }
            super.write(os);
        } else {
            this.requestBodyWriter.writeRequestBody(os);
        }
    }
}

