/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.eclipse.webdav.internal.kernel.EntityTag;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.StateToken;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public abstract class ConditionFactor {
    private boolean not = false;

    public static ConditionFactor create(StreamTokenizer tokenizer) throws WebDAVException {
        boolean not = false;
        ConditionFactor factor = null;
        try {
            int token = tokenizer.ttype;
            if (token == -3) {
                if (!tokenizer.sval.equalsIgnoreCase("Not")) {
                    throw new WebDAVException(400, Policy.bind("error.parseMissingNot"));
                }
                not = true;
                token = tokenizer.nextToken();
            }
            switch (token) {
                case 60: {
                    factor = StateToken.create(tokenizer);
                    break;
                }
                case 91: {
                    factor = EntityTag.create(tokenizer);
                    break;
                }
                default: {
                    throw new WebDAVException(400, Policy.bind("error.parseMissingOpen", String.valueOf(token)));
                }
            }
        }
        catch (IOException iOException) {}
        factor.setNot(not);
        return factor;
    }

    public boolean not() {
        return this.not;
    }

    public void setNot(boolean value) {
        this.not = value;
    }

    public abstract String toString();
}

