/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.flow.common.editor.editpart.ElementConnectionEditPart;
import org.drools.eclipse.flow.common.editor.editpart.ElementEditPart;
import org.drools.eclipse.flow.common.editor.editpart.ProcessEditPart;
import org.drools.eclipse.flow.common.editor.editpart.figure.ElementFigure;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class DirectedGraphLayoutVisitor {
    private Map<AbstractGraphicalEditPart, Object> partToNodesMap;
    private DirectedGraph graph;

    public void layoutDiagram(ProcessEditPart diagram) {
        this.partToNodesMap = new HashMap<AbstractGraphicalEditPart, Object>();
        this.graph = new DirectedGraph();
        this.addNodes(diagram);
        if (this.graph.nodes.size() > 0) {
            this.addEdges(diagram);
            new DirectedGraphLayout().visit(this.graph);
            this.applyResults(diagram);
        }
    }

    protected void addNodes(ProcessEditPart diagram) {
        int i = 0;
        while (i < diagram.getChildren().size()) {
            ElementEditPart elementEditPart = diagram.getChildren().get(i);
            this.addNodes(elementEditPart);
            ++i;
        }
    }

    protected void addNodes(ElementEditPart elementEditPart) {
        Node n = new Node((Object)elementEditPart);
        n.width = elementEditPart.getFigure().getPreferredSize((int)400, (int)300).width;
        n.height = elementEditPart.getFigure().getPreferredSize((int)400, (int)300).height;
        n.setPadding(new Insets(10, 8, 10, 12));
        this.partToNodesMap.put(elementEditPart, n);
        this.graph.nodes.add((Object)n);
    }

    protected void addEdges(ProcessEditPart diagram) {
        int i = 0;
        while (i < diagram.getChildren().size()) {
            ElementEditPart elementEditPart = diagram.getChildren().get(i);
            this.addEdges(elementEditPart);
            ++i;
        }
    }

    protected void addEdges(ElementEditPart elementEditPart) {
        List outgoing = elementEditPart.getSourceConnections();
        int i = 0;
        while (i < outgoing.size()) {
            ElementConnectionEditPart connectionPart = (ElementConnectionEditPart)outgoing.get(i);
            this.addEdges(connectionPart);
            ++i;
        }
    }

    protected void addEdges(ElementConnectionEditPart connectionPart) {
        Node source = (Node)this.partToNodesMap.get(connectionPart.getSource());
        Node target = (Node)this.partToNodesMap.get(connectionPart.getTarget());
        Edge e = new Edge((Object)connectionPart, source, target);
        e.weight = 2;
        this.graph.edges.add((Object)e);
        this.partToNodesMap.put((AbstractGraphicalEditPart)connectionPart, e);
    }

    protected void applyResults(ProcessEditPart diagram) {
        this.applyChildrenResults(diagram);
    }

    protected void applyChildrenResults(ProcessEditPart diagram) {
        int i = 0;
        while (i < diagram.getChildren().size()) {
            ElementEditPart elementEditPart = diagram.getChildren().get(i);
            this.applyResults(elementEditPart);
            ++i;
        }
    }

    protected void applyOwnResults(ProcessEditPart diagram) {
    }

    public void applyResults(ElementEditPart elementEditPart) {
        Node n = (Node)this.partToNodesMap.get(elementEditPart);
        ElementFigure elementFigure = (ElementFigure)elementEditPart.getFigure();
        Rectangle bounds = new Rectangle(n.x, n.y, elementFigure.getPreferredSize().width, elementFigure.getPreferredSize().height);
        elementFigure.setBounds(bounds);
        int i = 0;
        while (i < elementEditPart.getSourceConnections().size()) {
            ElementConnectionEditPart connectionPart = (ElementConnectionEditPart)elementEditPart.getSourceConnections().get(i);
            this.applyResults(connectionPart);
            ++i;
        }
    }

    protected void applyResults(ElementConnectionEditPart connectionPart) {
        Edge e = (Edge)this.partToNodesMap.get(connectionPart);
        NodeList nodes = e.vNodes;
        PolylineConnection conn = (PolylineConnection)connectionPart.getConnectionFigure();
        conn.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        if (nodes != null) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            int i = 0;
            while (i < nodes.size()) {
                Node vn = nodes.getNode(i);
                int x = vn.x;
                int y = vn.y;
                if (e.isFeedback()) {
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                    bends.add(new AbsoluteBendpoint(x, y));
                } else {
                    bends.add(new AbsoluteBendpoint(x, y));
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                }
                ++i;
            }
            conn.setRoutingConstraint(bends);
        } else {
            conn.setRoutingConstraint((Object)Collections.EMPTY_LIST);
        }
    }
}

