/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa.marshaller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Id;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.persistence.TransactionAware;
import org.drools.persistence.TransactionManager;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAPlaceholderResolverStrategy
implements ObjectMarshallingStrategy,
TransactionAware {
    private static Logger log = LoggerFactory.getLogger(JPAPlaceholderResolverStrategy.class);
    private EntityManagerFactory emf;
    private static final ThreadLocal<EntityManager> persister = new ThreadLocal();

    public JPAPlaceholderResolverStrategy(Environment env) {
        this.emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    public JPAPlaceholderResolverStrategy(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public boolean accept(Object object) {
        return JPAPlaceholderResolverStrategy.isEntity(object);
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        Serializable id = JPAPlaceholderResolverStrategy.getClassIdValue(object);
        EntityManager em = this.getEntityManager();
        if (id == null) {
            em.persist(object);
            id = JPAPlaceholderResolverStrategy.getClassIdValue(object);
        } else {
            em.merge(object);
            em.flush();
        }
        os.writeUTF(object.getClass().getCanonicalName());
        os.writeObject(id);
    }

    public Object read(ObjectInputStream is) throws IOException, ClassNotFoundException {
        String canonicalName = is.readUTF();
        Object id = is.readObject();
        EntityManager em = this.getEntityManager();
        return em.find(Class.forName(canonicalName), id);
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        Serializable id = JPAPlaceholderResolverStrategy.getClassIdValue(object);
        EntityManager em = this.getEntityManager();
        if (id == null) {
            em.persist(object);
            id = JPAPlaceholderResolverStrategy.getClassIdValue(object);
        } else {
            em.merge(object);
            em.flush();
        }
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buff);
        oos.writeUTF(object.getClass().getCanonicalName());
        oos.writeObject(id);
        oos.close();
        return buff.toByteArray();
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream ois, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        DroolsObjectInputStream is = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(object), classloader);
        String canonicalName = is.readUTF();
        Object id = is.readObject();
        EntityManager em = this.getEntityManager();
        return em.find(Class.forName(canonicalName, true, classloader == null ? this.getClass().getClassLoader() : classloader), id);
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }

    public static Serializable getClassIdValue(Object o) {
        Class<?> varClass = o.getClass();
        Serializable idValue = null;
        try {
            Id id;
            int i;
            do {
                Field[] fields = varClass.getDeclaredFields();
                for (i = 0; i < fields.length && idValue == null; ++i) {
                    Field field = fields[i];
                    id = field.getAnnotation(Id.class);
                    if (id == null) continue;
                    try {
                        idValue = JPAPlaceholderResolverStrategy.callIdMethod(o, "get" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1));
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        idValue = (Serializable)field.get(o);
                    }
                }
            } while ((varClass = varClass.getSuperclass()) != null && idValue == null);
            if (idValue == null) {
                varClass = o.getClass();
                do {
                    Method[] methods = varClass.getMethods();
                    for (i = 0; i < methods.length && idValue == null; ++i) {
                        Method method = methods[i];
                        id = method.getAnnotation(Id.class);
                        if (id == null) continue;
                        idValue = (Serializable)method.invoke(o, new Object[0]);
                    }
                } while ((varClass = varClass.getSuperclass()) != null && idValue == null);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
        return idValue;
    }

    private static Serializable callIdMethod(Object target, String methodName) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (Serializable)target.getClass().getMethod(methodName, null).invoke(target, new Object[0]);
    }

    private static boolean isEntity(Object o) {
        Id id;
        int i;
        Class<?> varClass = o.getClass();
        do {
            Field[] fields = varClass.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                id = field.getAnnotation(Id.class);
                if (id == null) continue;
                return true;
            }
        } while ((varClass = varClass.getSuperclass()) != null);
        varClass = o.getClass();
        do {
            Method[] methods = varClass.getMethods();
            for (i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                id = method.getAnnotation(Id.class);
                if (id == null) continue;
                return true;
            }
        } while ((varClass = varClass.getSuperclass()) != null);
        return false;
    }

    @Override
    public void onStart(TransactionManager txm) {
        if (persister.get() == null) {
            EntityManager em = this.emf.createEntityManager();
            persister.set(em);
        }
    }

    @Override
    public void onEnd(TransactionManager txm) {
        EntityManager em = persister.get();
        if (em != null) {
            em.close();
            persister.set(null);
        }
    }

    protected EntityManager getEntityManager() {
        EntityManager em = persister.get();
        if (em != null) {
            return em;
        }
        return this.emf.createEntityManager();
    }
}

