/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.handlers;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.runtime.core.model.AbstractRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;

public class DroolsHandler
extends AbstractRuntimeDetectorDelegate {
    private static final String DROOLS_PREFIX = "Drools ";
    private static final String DROOLS_PREFIX_HYPHEN = "Drools  - ";
    private static final String DROOLS = "DROOLS";
    private static final String SOA_P = "SOA-P";

    public void initializeRuntimes(List<RuntimeDefinition> serverDefinitions) {
        DroolsRuntime[] existingRuntimes = DroolsRuntimeManager.getDefault().getConfiguredRuntimes();
        ArrayList<DroolsRuntime> droolsRuntimes = new ArrayList<DroolsRuntime>();
        if (existingRuntimes != null) {
            DroolsRuntime[] droolsRuntimeArray = existingRuntimes;
            int n = existingRuntimes.length;
            int n2 = 0;
            while (n2 < n) {
                DroolsRuntime runtime = droolsRuntimeArray[n2];
                droolsRuntimes.add(runtime);
                ++n2;
            }
        }
        this.initializeInternal(serverDefinitions, droolsRuntimes);
        if (droolsRuntimes.size() > 0) {
            DroolsRuntime[] dra = droolsRuntimes.toArray(new DroolsRuntime[0]);
            DroolsRuntimeManager.getDefault().setDroolsRuntimes(dra);
        }
    }

    private void initializeInternal(List<RuntimeDefinition> serverDefinitions, List<DroolsRuntime> droolsRuntimes) {
        for (RuntimeDefinition serverDefinition : serverDefinitions) {
            File droolsRoot;
            String type = serverDefinition.getType();
            if (serverDefinition.isEnabled() && !DroolsHandler.droolsExists(serverDefinition) && DROOLS.equals(type) && (droolsRoot = serverDefinition.getLocation()).isDirectory()) {
                DroolsRuntime runtime = new DroolsRuntime();
                boolean startsWithDrools = serverDefinition.getName().startsWith(DROOLS_PREFIX);
                String newName = startsWithDrools ? serverDefinition.getName() : DROOLS_PREFIX + serverDefinition.getName();
                runtime.setName(newName);
                runtime.setPath(droolsRoot.getAbsolutePath());
                DroolsRuntimeManager.getDefault().recognizeJars(runtime);
                runtime.setDefault(true);
                droolsRuntimes.add(runtime);
            }
            this.initializeInternal(serverDefinition.getIncludedRuntimeDefinitions(), droolsRuntimes);
        }
    }

    private static boolean droolsExists(RuntimeDefinition serverDefinition) {
        return DroolsHandler.getRuntimeForLocation(serverDefinition.getLocation().getAbsolutePath()) != null;
    }

    private static DroolsRuntime getRuntimeForLocation(String loc) {
        DroolsRuntime[] droolsRuntimes;
        DroolsRuntime[] droolsRuntimeArray = droolsRuntimes = DroolsRuntimeManager.getDefault().getConfiguredRuntimes();
        int n = droolsRuntimes.length;
        int n2 = 0;
        while (n2 < n) {
            DroolsRuntime dr = droolsRuntimeArray[n2];
            String location = dr.getPath();
            if (location != null && location.equals(loc)) {
                return dr;
            }
            ++n2;
        }
        return null;
    }

    private boolean droolsRuntimeNameExists(String name) {
        DroolsRuntime[] droolsRuntimes = DroolsRuntimeManager.getDefault().getConfiguredRuntimes();
        int i = 0;
        while (i < droolsRuntimes.length) {
            if (droolsRuntimes[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getDroolsRuntimeName(String prefix) {
        if (!this.droolsRuntimeNameExists(prefix)) {
            return prefix;
        }
        int count = 1;
        while (this.droolsRuntimeNameExists(String.valueOf(prefix) + " (" + count + ")")) {
            ++count;
        }
        return String.valueOf(prefix) + " (" + count + ")";
    }

    public RuntimeDefinition getRuntimeDefinition(File root, IProgressMonitor monitor) {
        String version;
        if (monitor.isCanceled() || root == null) {
            return null;
        }
        String[] files = root.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("drools-api") && name.endsWith(".jar");
            }
        });
        if (files != null && files.length > 0 && (version = this.getImplementationVersion(root, files[0])) != null) {
            version = version.substring(0, 3);
            String name = this.getDroolsRuntimeName(DROOLS_PREFIX + version);
            DroolsRuntime found = DroolsHandler.getRuntimeForLocation(root.getAbsolutePath());
            if (found != null) {
                name = found.getName();
            }
            return new RuntimeDefinition(name, version, DROOLS, root.getAbsoluteFile());
        }
        return null;
    }

    public String getImplementationVersion(File dir, String file) {
        File jarFile = new File(dir, file);
        if (!jarFile.isFile()) {
            return null;
        }
        try {
            JarFile jar = new JarFile(jarFile);
            Attributes attributes = jar.getManifest().getMainAttributes();
            String version = attributes.getValue("Implementation-Version");
            return version;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean exists(RuntimeDefinition serverDefinition) {
        if (serverDefinition == null || serverDefinition.getLocation() == null) {
            return false;
        }
        return DroolsHandler.droolsExists(serverDefinition);
    }

    public void computeIncludedRuntimeDefinition(RuntimeDefinition serverDefinition) {
        if (serverDefinition == null || !SOA_P.equals(serverDefinition.getType())) {
            return;
        }
        File droolsRoot = serverDefinition.getLocation();
        if (droolsRoot.isDirectory()) {
            String name = DROOLS_PREFIX_HYPHEN + serverDefinition.getName();
            RuntimeDefinition sd = new RuntimeDefinition(name, serverDefinition.getVersion(), DROOLS, droolsRoot);
            sd.setParent(serverDefinition);
            serverDefinition.getIncludedRuntimeDefinitions().add(sd);
        }
    }

    public String getVersion(RuntimeDefinition runtimeDefinition) {
        return runtimeDefinition.getVersion();
    }
}

