/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import org.drools.eclipse.preferences.DroolsRuntimesBlock;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.drools.eclipse.util.IDroolsRuntimeManagerListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DroolsRuntimesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IDroolsRuntimeManagerListener {
    private DroolsRuntimesBlock droolsRuntimesBlock;

    public DroolsRuntimesPreferencePage() {
        super("Installed Drools Runtimes");
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        DroolsRuntimeManager.getDefault().removeListener(this);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setVisible(false);
        DroolsRuntimeManager.getDefault().addListener(this);
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        Label l = new Label(ancestor, 64);
        l.setFont(ancestor.getFont());
        l.setText("Add, remove or edit Drools Runtime definitions. By default, the checked Drools Runtime is added to the build path of newly created Drools projects.");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 300;
        l.setLayoutData((Object)gd);
        l = new Label(ancestor, 0);
        gd = new GridData(768);
        gd.heightHint = 1;
        l.setLayoutData((Object)gd);
        this.droolsRuntimesBlock = new DroolsRuntimesBlock();
        this.droolsRuntimesBlock.createControl(ancestor);
        DroolsRuntime[] runtimes = DroolsRuntimeManager.getDefault().getConfiguredRuntimes();
        this.droolsRuntimesBlock.setDroolsRuntimes(runtimes);
        if (this.droolsRuntimesBlock.getDefaultDroolsRuntime() == null) {
            this.setErrorMessage("Select a default Drools Runtime");
        }
        Control control = this.droolsRuntimesBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.widthHint = 450;
        control.setLayoutData((Object)data);
        this.droolsRuntimesBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DroolsRuntime runtime = DroolsRuntimesPreferencePage.this.droolsRuntimesBlock.getDefaultDroolsRuntime();
                if (runtime == null) {
                    if (DroolsRuntimesPreferencePage.this.droolsRuntimesBlock.getDroolsRuntimes().length == 0) {
                        DroolsRuntimesPreferencePage.this.setErrorMessage("Create a default Drools Runtime");
                    } else {
                        DroolsRuntimesPreferencePage.this.setErrorMessage("Select a default Drools Runtime");
                    }
                } else {
                    DroolsRuntimesPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    public boolean performOk() {
        if (DroolsRuntimeManager.getDefault().getDefaultRuntime() != null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Warning", (String)"You need to restart Eclipse to update the Drools Runtime of existing projects.");
        }
        DroolsRuntimeManager.getDefault().setDroolsRuntimes(this.droolsRuntimesBlock.getDroolsRuntimes());
        return super.performOk();
    }

    @Override
    public void runtimeAdded(DroolsRuntime rt) {
        this.droolsRuntimesBlock.setDroolsRuntimes(DroolsRuntimeManager.getDefault().getConfiguredRuntimes());
    }

    @Override
    public void runtimeRemoved(DroolsRuntime rt) {
        this.droolsRuntimesBlock.setDroolsRuntimes(DroolsRuntimeManager.getDefault().getConfiguredRuntimes());
    }

    @Override
    public void runtimesChanged(DroolsRuntime[] newList) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DroolsRuntimesPreferencePage.this.droolsRuntimesBlock.setDroolsRuntimes(DroolsRuntimeManager.getDefault().getConfiguredRuntimes());
            }
        });
    }
}

