/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.refactoring;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.refactoring.DRLProjectDetector;
import org.drools.eclipse.refactoring.RefactoringContent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveModifications;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.kie.eclipse.utils.FileUtils;

public class RuleIFileMoveParticipant
extends MoveParticipant {
    public static final String NAME = "Rule Move Refactoring";
    private static RefactoringContent refactoringContent = new RefactoringContent();
    private DRLProjectDetector drlProjectDetector = new DRLProjectDetector();
    private Matcher matcher;
    private IFile file;
    private RefactoringProcessor processor;
    private String newName;
    private String currentName;
    private String className;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.file == null || this.file.isReadOnly()) {
            status.addFatalError("File don't exists or is read only");
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange changes = new CompositeChange("Reorganize DRL " + this.currentName + "." + this.className + " imports ");
        for (IFile drlFile : this.drlProjectDetector.detect(this.file.getProject())) {
            String content = refactoringContent.getIFileContent(drlFile);
            if (content == null && (content = FileUtils.readFile(drlFile)) == null) continue;
            String toReplace = String.valueOf(this.currentName) + "." + this.className;
            String replaceWith = String.valueOf(this.newName) + "." + this.className;
            Pattern pattern = Pattern.compile(toReplace);
            this.matcher = pattern.matcher(content);
            if (!this.matcher.find()) continue;
            TextFileChange change = new TextFileChange(drlFile.getName(), drlFile);
            MultiTextEdit mte = new MultiTextEdit();
            change.setEdit((TextEdit)mte);
            ReplaceEdit replace = new ReplaceEdit(this.matcher.start(), toReplace.length(), replaceWith);
            mte.addChild((TextEdit)replace);
            changes.add((Change)change);
            refactoringContent.updateContent(drlFile, content.replace(toReplace, replaceWith));
        }
        return changes.getChildren().length > 0 ? changes : null;
    }

    public String getName() {
        return NAME;
    }

    protected boolean initialize(Object element) {
        IFile file;
        if (element instanceof IFile && (file = (IFile)element).getType() == 1 && file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("java")) {
            this.processor = this.getProcessor();
            this.file = file;
            this.className = file.getName().replace("." + file.getFileExtension(), "");
            if (this.processor.hashCode() != refactoringContent.getProcessorHashcode().intValue()) {
                refactoringContent.setProcessorHashcode(this.processor.hashCode());
                refactoringContent.clear();
            }
            if (this.processor instanceof JavaRenameProcessor) {
                this.newName = ((JavaRenameProcessor)this.processor).getNewElementName();
                this.currentName = ((JavaRenameProcessor)this.processor).getCurrentElementName();
                return true;
            }
            if (this.processor instanceof JavaMoveProcessor) {
                try {
                    MoveModifications moveModifications = this.getNewName();
                    this.getCurrentName(moveModifications);
                }
                catch (SecurityException securityException) {
                    return false;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return false;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private MoveModifications getNewName() throws NoSuchFieldException, IllegalAccessException {
        Field fMovePolicyPrivateField = this.processor.getClass().getDeclaredField("fMovePolicy");
        fMovePolicyPrivateField.setAccessible(true);
        Object movePolicy = fMovePolicyPrivateField.get(this.processor);
        Field fModificationsPrivateField = movePolicy.getClass().getDeclaredField("fModifications");
        fModificationsPrivateField.setAccessible(true);
        MoveModifications moveModifications = (MoveModifications)fModificationsPrivateField.get(movePolicy);
        Field fMoveArgumentsPrivateField = moveModifications.getClass().getDeclaredField("fMoveArguments");
        fMoveArgumentsPrivateField.setAccessible(true);
        ArrayList moveArguments = (ArrayList)fMoveArgumentsPrivateField.get(moveModifications);
        PackageFragment packageFragment = (PackageFragment)((MoveArguments)moveArguments.get(0)).getDestination();
        String[] names = packageFragment.names;
        String newPackageName = "";
        int i = 0;
        while (i < names.length) {
            newPackageName = newPackageName.concat(String.valueOf(names[i]) + ".");
            ++i;
        }
        if (newPackageName.length() > 0) {
            this.newName = newPackageName.substring(0, newPackageName.length() - 1);
        }
        return moveModifications;
    }

    private void getCurrentName(MoveModifications moveModifications) throws NoSuchFieldException, IllegalAccessException, JavaModelException {
        Field fMovesPrivateField = moveModifications.getClass().getDeclaredField("fMoves");
        fMovesPrivateField.setAccessible(true);
        ArrayList fmoves = (ArrayList)fMovesPrivateField.get(moveModifications);
        for (Object fmove : fmoves) {
            if (!(fmove instanceof CompilationUnit)) continue;
            CompilationUnit cu = (CompilationUnit)fmove;
            IPackageDeclaration[] packageDeclarations = cu.getPackageDeclarations();
            int i = 0;
            while (i < packageDeclarations.length) {
                this.currentName = packageDeclarations[i].getElementName();
                ++i;
            }
        }
    }
}

