/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.drools.eclipse.util.DefaultDroolsRuntimeInstaller;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class DroolsRuntimeInstallerBase {
    static Hashtable<String, DroolsRuntimeInstallerBase> installers;
    public static final String DROOLS_RUNTIME_INSTALLER = "org.drools.eclipse.runtimeInstaller";
    public static Factory FACTORY;
    protected String id;
    protected String name;
    protected String runtimeId;
    protected String url;
    protected String type;
    protected String source;
    protected String target;
    protected ArtifactList artifacts;

    static {
        FACTORY = new Factory();
    }

    abstract String install(String var1, IProject var2, IProgressMonitor var3);

    public static class Artifact {
        String type;
        String name;
        String source;
        String target;

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }
    }

    public static class ArtifactList
    extends ArrayList<Artifact>
    implements Comparable<ArtifactList> {
        String id;
        String name;
        List<Artifact> artifacts;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(ArtifactList o) {
            return 0;
        }
    }

    public static class Factory {
        protected Factory() {
        }

        public DroolsRuntimeInstallerBase getInstaller(String runtimeId) {
            DroolsRuntimeInstallerBase installer = null;
            if (DefaultDroolsRuntimeInstaller.installers == null) {
                DefaultDroolsRuntimeInstaller.installers = new Hashtable();
                try {
                    IConfigurationElement[] config;
                    IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(DroolsRuntimeInstallerBase.DROOLS_RUNTIME_INSTALLER);
                    int n = config.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o;
                        IConfigurationElement e = iConfigurationElementArray[n2];
                        if ("installer".equals(e.getName()) && (o = e.createExecutableExtension("class")) instanceof DroolsRuntimeInstallerBase) {
                            DroolsRuntimeInstallerBase inst = (DroolsRuntimeInstallerBase)o;
                            inst.id = e.getAttribute("id");
                            e.getAttribute("runtimeId");
                            e.getAttribute("name");
                            e.getAttribute("url");
                        }
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)ex.getMessage());
                }
            }
            return installer;
        }
    }
}

