/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DefaultDroolsRuntimeRecognizer;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeRecognizer;
import org.drools.eclipse.util.IDroolsRuntimeManagerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.osgi.framework.Bundle;

public class DroolsRuntimeManager
implements IRuntimeManager {
    private static final String DROOLS_RUNTIME_RECOGNIZER = "org.drools.eclipse.runtimeRecognizer";
    private static final String DROOLS_BUNDLE_RUNTIME_LOCATION = ".drools.runtime";
    private static DroolsRuntimeManager manager;
    private ArrayList<IDroolsRuntimeManagerListener> listeners = new ArrayList();

    public static DroolsRuntimeManager getDefault() {
        if (manager == null) {
            manager = new DroolsRuntimeManager();
        }
        return manager;
    }

    public void addListener(IDroolsRuntimeManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IDroolsRuntimeManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public String[] getAllRuntimeNames() {
        return DroolsRuntime.getAllNames();
    }

    @Override
    public String[] getAllRuntimeIds() {
        return DroolsRuntime.getAllIds();
    }

    @Override
    public boolean isMavenized(String runtimeId) {
        return "org.drools.runtime_6.x".equals(runtimeId);
    }

    public void addRuntime(DroolsRuntime rt) {
        ArrayList<DroolsRuntime> list = new ArrayList<DroolsRuntime>();
        list.addAll(Arrays.asList(this.getConfiguredRuntimes()));
        list.add(rt);
        this.setDroolsRuntimesInternal(list.toArray(new DroolsRuntime[list.size()]));
        this.fireRuntimeAdded(rt);
    }

    public void removeRuntime(DroolsRuntime rt) {
        ArrayList<DroolsRuntime> list = new ArrayList<DroolsRuntime>();
        list.addAll(Arrays.asList(this.getConfiguredRuntimes()));
        list.remove(rt);
        this.setDroolsRuntimesInternal(list.toArray(new DroolsRuntime[list.size()]));
        this.fireRuntimeRemoved(rt);
    }

    private void fireRuntimeAdded(DroolsRuntime rt) {
        Iterator<IDroolsRuntimeManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().runtimeAdded(rt);
        }
    }

    private void fireRuntimeRemoved(DroolsRuntime rt) {
        Iterator<IDroolsRuntimeManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().runtimeRemoved(rt);
        }
    }

    private void fireRuntimesChanged() {
        Iterator<IDroolsRuntimeManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().runtimesChanged(this.getConfiguredRuntimes());
        }
    }

    public String getBundleRuntimeVersion() {
        String version = Platform.getBundle((String)"org.drools.eclipse").getVersion().toString();
        String[] a = version.split("\\.");
        if (a.length > 3) {
            return String.valueOf(a[0]) + "." + a[1] + "." + a[2];
        }
        return version;
    }

    @Override
    public String getBundleRuntimeName() {
        return "Drools " + this.getBundleRuntimeVersion() + " Runtime";
    }

    public String getBundleRuntimeLocation() {
        return DROOLS_BUNDLE_RUNTIME_LOCATION;
    }

    public void createDefaultRuntime(String location) {
        this.createBundleRuntime(location);
    }

    public DroolsRuntime createBundleRuntime(String location) {
        ArrayList<String> jars = new ArrayList<String>();
        String s = this.getDroolsLocation();
        File file = new Path(s).toFile();
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory() && files[i].getName().equals("lib")) {
                File[] jarFiles = files[i].listFiles();
                int j = 0;
                while (j < jarFiles.length) {
                    if (jarFiles[j].getPath().endsWith(".jar")) {
                        jars.add(jarFiles[j].getAbsolutePath());
                    }
                    ++j;
                }
            }
            ++i;
        }
        try {
            jars.add(FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"org.eclipse.jdt.core")).getAbsolutePath());
        }
        catch (IOException ex) {
            DroolsEclipsePlugin.log(ex);
        }
        String separator = "";
        if (!location.endsWith(File.separator)) {
            separator = File.separator;
        }
        ArrayList<String> jarsCreated = new ArrayList<String>();
        for (String jar : jars) {
            try {
                File jarFile = new File(jar);
                FileChannel inChannel = new FileInputStream(jarFile).getChannel();
                String createdJar = String.valueOf(location) + separator + jarFile.getName();
                FileChannel outChannel = new FileOutputStream(new File(createdJar)).getChannel();
                try {
                    inChannel.transferTo(0L, inChannel.size(), outChannel);
                    jarsCreated.add(createdJar);
                }
                finally {
                    if (inChannel != null) {
                        inChannel.close();
                    }
                    if (outChannel != null) {
                        outChannel.close();
                    }
                }
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
            }
        }
        DroolsRuntime runtime = new DroolsRuntime();
        runtime.setPath(location);
        runtime.setName(this.getBundleRuntimeName());
        runtime.setJars(jarsCreated.toArray(new String[jarsCreated.size()]));
        return runtime;
    }

    @Override
    public IRuntime getEffectiveRuntime(IRuntime selectedRuntime, boolean useDefault) {
        IFolder lib;
        boolean rebuildBundleRuntimeProject = false;
        String bundleRuntimeLocation = this.getBundleRuntimeLocation();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (selectedRuntime.getPath() != null) {
            IPath rootPath;
            Path runtimeRootPath = new Path(selectedRuntime.getPath());
            if ("lib".equals(runtimeRootPath.lastSegment())) {
                runtimeRootPath = runtimeRootPath.removeLastSegments(1);
            }
            if (bundleRuntimeLocation.equals(runtimeRootPath.lastSegment())) {
                runtimeRootPath = runtimeRootPath.removeLastSegments(1);
            }
            if ((rootPath = workspace.getRoot().getLocation()).equals((Object)runtimeRootPath)) {
                IProject project = workspace.getRoot().getProject(bundleRuntimeLocation);
                if (!project.isOpen()) {
                    try {
                        project.open(128, null);
                    }
                    catch (CoreException ex) {
                        DroolsEclipsePlugin.log(ex);
                    }
                }
                if (!project.exists()) {
                    rebuildBundleRuntimeProject = true;
                } else {
                    int jarCount = 0;
                    lib = project.getFolder("lib");
                    if (!lib.exists()) {
                        try {
                            project.delete(true, null);
                            rebuildBundleRuntimeProject = true;
                        }
                        catch (CoreException ex) {
                            DroolsEclipsePlugin.log(ex);
                        }
                    } else {
                        try {
                            IResource[] iResourceArray = lib.members();
                            int n = iResourceArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResource f = iResourceArray[n2];
                                if ("jar".equals(f.getFileExtension())) {
                                    ++jarCount;
                                }
                                ++n2;
                            }
                        }
                        catch (CoreException ex) {
                            DroolsEclipsePlugin.log(ex);
                        }
                    }
                    if (jarCount == 0) {
                        rebuildBundleRuntimeProject = true;
                    }
                }
            }
        }
        ArrayList<IRuntime> droolsRuntimes = new ArrayList<IRuntime>();
        lib = this.getConfiguredRuntimes();
        int jarCount = ((DroolsRuntime[])lib).length;
        int project = 0;
        while (project < jarCount) {
            DroolsRuntime rt = lib[project];
            droolsRuntimes.add(rt);
            ++project;
        }
        if (selectedRuntime.getPath() == null || rebuildBundleRuntimeProject || droolsRuntimes.size() == 0) {
            droolsRuntimes.remove(selectedRuntime);
            IProject project2 = workspace.getRoot().getProject(bundleRuntimeLocation);
            IFolder lib2 = project2.getFolder("lib");
            if (!project2.exists() || !lib2.exists()) {
                IProjectDescription description = workspace.newProjectDescription(project2.getName());
                description.setLocation(null);
                try {
                    project2.create(description, null);
                    project2.open(128, null);
                    lib2.create(true, true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            String location = lib2.getLocation().removeTrailingSeparator().toString();
            selectedRuntime = this.createBundleRuntime(location);
            if (droolsRuntimes.size() == 0) {
                useDefault = true;
            }
            selectedRuntime.setDefault(useDefault);
            droolsRuntimes.add(selectedRuntime);
            this.setDroolsRuntimes(droolsRuntimes.toArray(new DroolsRuntime[droolsRuntimes.size()]));
        }
        if (useDefault) {
            return null;
        }
        return selectedRuntime;
    }

    private String getDroolsLocation() {
        try {
            return FileLocator.toFileURL((URL)Platform.getBundle((String)"org.drools.eclipse").getEntry("/")).getFile().toString();
        }
        catch (IOException e) {
            DroolsEclipsePlugin.log(e);
            return null;
        }
    }

    private String generateString(DroolsRuntime[] droolsRuntimes) {
        String result = "";
        DroolsRuntime[] droolsRuntimeArray = droolsRuntimes;
        int n = droolsRuntimes.length;
        int n2 = 0;
        while (n2 < n) {
            DroolsRuntime runtime = droolsRuntimeArray[n2];
            result = String.valueOf(result) + runtime.getName() + "#" + runtime.getPath() + "#" + runtime.isDefault() + "# ";
            result = String.valueOf(result) + runtime.getId() + "#";
            if (runtime.getJars() != null) {
                String[] stringArray = runtime.getJars();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String jar = stringArray[n4];
                    result = String.valueOf(result) + jar + ";";
                    ++n4;
                }
            }
            result = String.valueOf(result) + "###";
            ++n2;
        }
        return result;
    }

    private DroolsRuntime[] generateRuntimes(String s) {
        ArrayList<DroolsRuntime> result = new ArrayList<DroolsRuntime>();
        if (s != null && !"".equals(s)) {
            String[] runtimeStrings;
            String[] stringArray = runtimeStrings = s.split("###");
            int n = runtimeStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String runtimeString = stringArray[n2];
                String[] properties = runtimeString.split("#");
                DroolsRuntime runtime = new DroolsRuntime();
                runtime.setName(properties[0]);
                String location = properties[1];
                File file = new File(location);
                if (file.exists()) {
                    runtime.setPath(location);
                    runtime.setDefault("true".equals(properties[2]));
                    if (properties.length > 3) {
                        int index;
                        ArrayList<String> list = new ArrayList<String>();
                        String[] jars = properties[3].split(";");
                        if (!jars[index = 0].endsWith(".jar")) {
                            runtime.setId(jars[index++]);
                        }
                        while (index < jars.length) {
                            String jar = jars[index++];
                            if ((jar = jar.trim()).length() <= 0) continue;
                            list.add(jar);
                        }
                        runtime.setJars(list.toArray(new String[list.size()]));
                    }
                    result.add(runtime);
                }
                ++n2;
            }
        }
        return result.toArray(new DroolsRuntime[result.size()]);
    }

    public DroolsRuntime[] getConfiguredRuntimes() {
        String runtimesString = DroolsEclipsePlugin.getDefault().getPreferenceStore().getString("Drools.Runtimes");
        if (runtimesString != null) {
            return this.generateRuntimes(runtimesString);
        }
        return new DroolsRuntime[0];
    }

    public void setDroolsRuntimes(DroolsRuntime[] runtimes) {
        this.setDroolsRuntimesInternal(runtimes);
        DroolsRuntimeManager.getDefault().fireRuntimesChanged();
    }

    private void setDroolsRuntimesInternal(DroolsRuntime[] runtimes) {
        DroolsEclipsePlugin.getDefault().getPreferenceStore().setValue("Drools.Runtimes", this.generateString(runtimes));
    }

    public DroolsRuntime getDroolsRuntime(String name) {
        DroolsRuntime[] runtimes;
        DroolsRuntime[] droolsRuntimeArray = runtimes = this.getConfiguredRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            DroolsRuntime runtime = droolsRuntimeArray[n2];
            if (runtime.getName().equals(name)) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public DroolsRuntime getDefaultRuntime() {
        DroolsRuntime[] runtimes;
        DroolsRuntime[] droolsRuntimeArray = runtimes = this.getConfiguredRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            DroolsRuntime runtime = droolsRuntimeArray[n2];
            if (runtime.isDefault()) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setRuntime(IRuntime runtime, IProject project, IProgressMonitor monitor) throws CoreException {
        if (runtime != null) {
            IFile file = project.getFile(".settings/.drools.runtime");
            String runtimeString = "<runtime>" + runtime.getName() + "</runtime>";
            if (!file.exists()) {
                IFolder folder = project.getProject().getFolder(".settings");
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                file.create((InputStream)new ByteArrayInputStream(runtimeString.getBytes()), true, null);
            } else {
                file.setContents((InputStream)new ByteArrayInputStream(runtimeString.getBytes()), true, false, null);
            }
        }
    }

    @Override
    public IRuntime getRuntime(IProject project) {
        try {
            BufferedReader reader;
            String location;
            IFile file = project.getFile(".settings/.drools.runtime");
            if (file.exists() && (location = (reader = new BufferedReader(new InputStreamReader(file.getContents()))).readLine()).startsWith("<runtime>") && location.endsWith("</runtime>")) {
                String runtimeName = location.substring(9, location.length() - 10);
                return this.getDroolsRuntime(runtimeName);
            }
        }
        catch (Exception e) {
            DroolsEclipsePlugin.log(e);
        }
        return this.getDefaultRuntime();
    }

    public String[] getDroolsRuntimeJars(IProject project) {
        DroolsRuntime runtime = (DroolsRuntime)this.getRuntime(project);
        if (runtime == null) {
            return null;
        }
        if (runtime.getJars() == null || runtime.getJars().length == 0) {
            this.recognizeJars(runtime);
        }
        return runtime.getJars();
    }

    public void recognizeJars(DroolsRuntime runtime) {
        String path = runtime.getPath();
        if (path != null) {
            try {
                IConfigurationElement[] config;
                IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(DROOLS_RUNTIME_RECOGNIZER);
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] jars;
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof DroolsRuntimeRecognizer && (jars = ((DroolsRuntimeRecognizer)o).recognizeJars(path)) != null && jars.length > 0) {
                        runtime.setJars(jars);
                        return;
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
            runtime.setJars(new DefaultDroolsRuntimeRecognizer().recognizeJars(path));
        }
    }
}

