/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.wizard.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;

public abstract class AbstractKieProjectRuntimeWizardPage
extends WizardPage {
    private List<IRuntime> runtimes = new ArrayList<IRuntime>();
    private boolean isDefaultRuntime = true;
    private IRuntime selectedRuntime;
    private String runtimeId;
    private Button projectSpecificRuntime;
    private Combo runtimesCombo;
    private Combo versionsCombo;
    private Composite mavenPanel;
    private String groupId = "";
    private String artifactId = "";
    private String version = "";
    protected IRuntimeManager runtimeManager = this.getRuntimeManager();
    private String[] runtimeNames = this.runtimeManager.getAllRuntimeNames();
    private String[] runtimeIds = this.runtimeManager.getAllRuntimeIds();

    public AbstractKieProjectRuntimeWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Runtime");
        this.setDescription("Select a Runtime");
    }

    public abstract IRuntimeManager getRuntimeManager();

    protected abstract IRuntime createRuntime();

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        IRuntime defaultRuntime = this.runtimeManager.getDefaultRuntime();
        this.projectSpecificRuntime = this.createCheckBox(composite, "Use default Drools Runtime (currently " + (defaultRuntime == null ? "undefined)" : String.valueOf(defaultRuntime.getName()) + ")"));
        this.projectSpecificRuntime.setSelection(true);
        this.projectSpecificRuntime.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractKieProjectRuntimeWizardPage.this.isDefaultRuntime = ((Button)e.widget).getSelection();
                AbstractKieProjectRuntimeWizardPage.this.runtimesCombo.setEnabled(!AbstractKieProjectRuntimeWizardPage.this.isDefaultRuntime);
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.projectSpecificRuntime.setLayoutData((Object)gridData);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Drools Runtime:");
        this.runtimesCombo = new Combo(composite, 8);
        this.runtimesCombo.setEnabled(false);
        this.runtimesCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Integer key = AbstractKieProjectRuntimeWizardPage.this.runtimesCombo.getSelectionIndex();
                AbstractKieProjectRuntimeWizardPage.this.selectedRuntime = (IRuntime)AbstractKieProjectRuntimeWizardPage.this.runtimesCombo.getData(key.toString());
            }
        });
        this.fillRuntimesCombo();
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.runtimesCombo.setLayoutData((Object)gridData);
        Link changeWorkspaceSettingsLink = this.createLink(composite, "Configure Drools Runtimes...");
        changeWorkspaceSettingsLink.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Composite subPanel = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        subPanel.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        subPanel.setLayoutData((Object)gridData);
        Label versionsLabel = new Label(subPanel, 0);
        versionsLabel.setText("Generate code compatible with:");
        this.versionsCombo = new Combo(subPanel, 8);
        int i = 0;
        while (i < this.runtimeIds.length) {
            this.versionsCombo.add(this.runtimeNames[i]);
            this.versionsCombo.select(i);
            ++i;
        }
        this.versionsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractKieProjectRuntimeWizardPage.this.versionsCombo.getSelectionIndex();
                if (index >= 0 && index < AbstractKieProjectRuntimeWizardPage.this.runtimeIds.length) {
                    AbstractKieProjectRuntimeWizardPage.this.runtimeId = AbstractKieProjectRuntimeWizardPage.this.runtimeIds[index];
                    AbstractKieProjectRuntimeWizardPage.this.mavenPanel.setVisible(AbstractKieProjectRuntimeWizardPage.this.runtimeManager.isMavenized(AbstractKieProjectRuntimeWizardPage.this.runtimeId));
                    AbstractKieProjectRuntimeWizardPage.this.setComplete();
                }
            }
        });
        this.setPageComplete(false);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.versionsCombo.setLayoutData((Object)gridData);
        this.mavenPanel = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.mavenPanel.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.mavenPanel.setLayoutData((Object)gridData);
        Label groupLabel = new Label(this.mavenPanel, 0);
        groupLabel.setText("GroupId: ");
        final Text groupField = new Text(this.mavenPanel, 2048);
        groupField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AbstractKieProjectRuntimeWizardPage.this.groupId = groupField.getText();
                AbstractKieProjectRuntimeWizardPage.this.setComplete();
            }
        });
        Label artifactLabel = new Label(this.mavenPanel, 0);
        artifactLabel.setText("ArtifactId: ");
        final Text artifactField = new Text(this.mavenPanel, 2048);
        artifactField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AbstractKieProjectRuntimeWizardPage.this.artifactId = artifactField.getText();
                AbstractKieProjectRuntimeWizardPage.this.setComplete();
            }
        });
        Label versionLabel = new Label(this.mavenPanel, 0);
        versionLabel.setText("Version: ");
        final Text versionField = new Text(this.mavenPanel, 2048);
        versionField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AbstractKieProjectRuntimeWizardPage.this.version = versionField.getText();
                AbstractKieProjectRuntimeWizardPage.this.setComplete();
            }
        });
        this.setMessage(null);
        this.setPageComplete(this.runtimes.size() > 0 && this.isComplete());
        this.setControl((Control)composite);
    }

    private void fillRuntimesCombo() {
        IRuntime rt;
        this.runtimes.clear();
        IRuntime[] iRuntimeArray = this.runtimeManager.getConfiguredRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            rt = iRuntimeArray[n2];
            this.runtimes.add(rt);
            ++n2;
        }
        if (this.runtimeManager.getDefaultRuntime() == null) {
            this.isDefaultRuntime = false;
            this.projectSpecificRuntime.setSelection(false);
            this.projectSpecificRuntime.setEnabled(false);
        } else {
            this.projectSpecificRuntime.setEnabled(true);
        }
        if (this.runtimes.size() == 0) {
            rt = this.createRuntime();
            rt.setName(this.runtimeManager.getBundleRuntimeName());
            this.runtimes.add(rt);
            this.setControlVisible((Control)this.projectSpecificRuntime, false);
            this.setControlVisible((Control)this.runtimesCombo, true);
            this.runtimesCombo.setEnabled(true);
        } else {
            if (this.runtimes.size() == 1) {
                this.setControlVisible((Control)this.projectSpecificRuntime, false);
                this.runtimesCombo.setEnabled(true);
            } else {
                this.setControlVisible((Control)this.projectSpecificRuntime, true);
                this.runtimesCombo.setEnabled(!this.isDefaultRuntime);
            }
            this.setControlVisible((Control)this.runtimesCombo, true);
        }
        this.setErrorMessage(null);
        this.runtimesCombo.removeAll();
        Integer key = 0;
        for (IRuntime rt2 : this.runtimes) {
            String name = rt2.getName();
            if (rt2.getPath() == null) {
                name = String.valueOf(name) + " (will be created)";
            }
            this.runtimesCombo.add(name);
            this.runtimesCombo.setData(key.toString(), (Object)rt2);
            key = key + 1;
        }
        key = 0;
        this.runtimesCombo.select(key.intValue());
        this.selectedRuntime = (IRuntime)this.runtimesCombo.getData(key.toString());
        IRuntime defaultRuntime = this.runtimeManager.getDefaultRuntime();
        this.projectSpecificRuntime.setText("Use default Runtime (currently " + (defaultRuntime == null ? "undefined)" : String.valueOf(defaultRuntime.getName()) + ")"));
    }

    private void setControlVisible(Control control, boolean visible) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).exclude = !visible;
        }
        control.setVisible(visible);
        control.getParent().layout();
    }

    private void setComplete() {
        this.setPageComplete(this.isComplete());
    }

    protected abstract boolean isComplete();

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractKieProjectRuntimeWizardPage.this.openLink();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractKieProjectRuntimeWizardPage.this.openLink();
            }
        });
        return link;
    }

    public abstract int showRuntimePreferenceDialog();

    private void openLink() {
        if (this.showRuntimePreferenceDialog() == 0) {
            this.fillRuntimesCombo();
        }
    }

    public IRuntime getRuntime() {
        return this.runtimeManager.getEffectiveRuntime(this.selectedRuntime, this.isDefaultRuntime);
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public IWizardPage getPreviousPage() {
        return super.getPreviousPage();
    }
}

