/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.wizard.project;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.utils.FileUtils;
import org.kie.eclipse.wizard.project.AbstractKieProjectMainWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieProjectRuntimeWizardPage;

public abstract class AbstractKieProjectWizard
extends BasicNewResourceWizard {
    public static final String DROOLS_CLASSPATH_CONTAINER_PATH = "DROOLS/Drools";
    public static final String MAIN_PAGE = "extendedNewProjectPage";
    public static final String RUNTIME_PAGE = "extendedNewProjectRuntimePage";
    private AbstractKieProjectMainWizardPage mainPage;
    private AbstractKieProjectRuntimeWizardPage runtimePage;

    public void addPages() {
        super.addPages();
        this.mainPage = this.createMainPage(MAIN_PAGE);
        this.addPage((IWizardPage)this.mainPage);
        this.runtimePage = this.createRuntimePage(RUNTIME_PAGE);
        this.addPage((IWizardPage)this.runtimePage);
        this.setNeedsProgressMonitor(true);
    }

    protected abstract AbstractKieProjectMainWizardPage createMainPage(String var1);

    protected abstract AbstractKieProjectRuntimeWizardPage createRuntimePage(String var1);

    public boolean performFinish() {
        IProject newProjectHandle = null;
        for (IProjectDescription pd : this.mainPage.getNewProjectDescriptions()) {
            if (newProjectHandle == null) {
                newProjectHandle = this.createNewProject(pd);
            }
            this.initializeNewProject(newProjectHandle);
        }
        if (newProjectHandle == null) {
            return false;
        }
        this.selectAndReveal((IResource)newProjectHandle);
        return true;
    }

    protected IProject initializeNewProject(final IProject newProjectHandle) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    IJavaProject project = JavaCore.create((IProject)newProjectHandle);
                    AbstractKieProjectWizard.this.createRuntimeSettings(project, monitor);
                    AbstractKieProjectWizard.this.createOutputLocation(project, monitor);
                    AbstractKieProjectWizard.this.addBuilders(project, monitor);
                    AbstractKieProjectWizard.this.setClasspath(project, monitor);
                    AbstractKieProjectWizard.this.createInitialContent(project, monitor);
                    newProjectHandle.build(6, monitor);
                }
                catch (IOException iOException) {
                    ErrorDialog.openError((Shell)AbstractKieProjectWizard.this.getShell(), (String)"Problem creating new project", null, null);
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return newProjectHandle;
    }

    protected IProject createNewProject(final IProjectDescription description) {
        this.addNatures(description);
        final IProject newProjectHandle = FileUtils.getProjectHandle(description.getName());
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                AbstractKieProjectWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"NewProject.errorMessage", (String)("NewProject.caseVariantExistsError" + newProjectHandle.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"NewProject.errorMessage", null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                e.printStackTrace();
            }
            return null;
        }
        return newProjectHandle;
    }

    protected void addNatures(IProjectDescription projectDescription) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(projectDescription.getNatureIds()));
        list.add("org.eclipse.jdt.core.javanature");
        projectDescription.setNatureIds(list.toArray(new String[list.size()]));
    }

    protected void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    protected void createRuntimeSettings(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        IRuntime runtime = this.mainPage.getRuntime();
        if (runtime != null) {
            this.runtimePage.getRuntimeManager().setRuntime(runtime, javaProject.getProject(), monitor);
        }
    }

    protected abstract void createOutputLocation(IJavaProject var1, IProgressMonitor var2) throws JavaModelException, CoreException;

    protected void createOutputLocation(IJavaProject project, String folderName, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IFolder folder = this.createFolder(project, folderName, monitor);
        IPath path = folder.getFullPath();
        project.setOutputLocation(path, null);
    }

    protected void addBuilders(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        this.addJavaBuilder(project, monitor);
    }

    protected void addJavaBuilder(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand javaCommand = description.newCommand();
        javaCommand.setBuilderName("org.eclipse.jdt.core.javabuilder");
        newCommands[commands.length] = javaCommand;
        description.setBuildSpec(newCommands);
        project.getProject().setDescription(description, monitor);
    }

    protected void setClasspath(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        project.setRawClasspath(new IClasspathEntry[0], monitor);
        this.addSourceFolders(project, monitor);
        this.addJRELibraries(project, monitor);
        this.addRuntimeLibraries(project, monitor);
    }

    protected void addSourceFolders(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        if (this.mainPage.getInitialProjectContent() != 1) {
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            list.addAll(Arrays.asList(project.getRawClasspath()));
            this.addSourceFolder(project, list, "src/main/java", monitor);
            if (this.runtimePage.getRuntimeManager().isMavenized(this.runtimePage.getRuntimeId())) {
                this.addSourceFolder(project, list, "src/main/resources", monitor);
                this.createFolder(project, "src/main/resources/META-INF", monitor);
                this.createFolder(project, "src/main/resources/META-INF/maven", monitor);
            } else {
                this.addSourceFolder(project, list, "src/main/rules", monitor);
            }
            project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), null);
        }
    }

    protected void addFolderToClasspath(IJavaProject project, String folderName, IProgressMonitor monitor) throws JavaModelException, CoreException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        IFolder folder = project.getProject().getFolder(folderName);
        if (folder.exists()) {
            this.addSourceFolder(project, list, folderName, monitor);
            project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), null);
        }
    }

    protected void addJRELibraries(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        list.addAll(Arrays.asList(PreferenceConstants.getDefaultJRELibrary()));
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
    }

    protected abstract IClasspathContainer createClasspathContainer(IJavaProject var1);

    protected IClasspathContainer createRuntimeLibraryContainer(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        IClasspathContainer cp = this.createClasspathContainer(project);
        JavaCore.setClasspathContainer((IPath)cp.getPath(), (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{cp}, (IProgressMonitor)monitor);
        return cp;
    }

    protected void addRuntimeLibraries(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        IClasspathContainer cp = this.createRuntimeLibraryContainer(project, monitor);
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        list.add(JavaCore.newContainerEntry((IPath)cp.getPath()));
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
    }

    protected boolean createInitialContent(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException, JavaModelException, IOException {
        if (this.mainPage.getInitialProjectContent() == 1) {
            this.mainPage.downloadOnlineExampleProject(javaProject.getProject(), monitor);
            this.addFolderToClasspath(javaProject, "src/main/java", monitor);
            this.addFolderToClasspath(javaProject, "src/main/resources", monitor);
            this.addFolderToClasspath(javaProject, "src/test/java", monitor);
            this.addFolderToClasspath(javaProject, "src/test/resources", monitor);
            this.addFolderToClasspath(javaProject, "src/main/rules", monitor);
            return true;
        }
        return false;
    }

    protected void addSourceFolder(IJavaProject project, List<IClasspathEntry> list, String s, IProgressMonitor monitor) throws CoreException {
        IFolder folder = project.getProject().getFolder(s);
        this.createFolder(folder, monitor);
        IPackageFragmentRoot ipackagefragmentroot = project.getPackageFragmentRoot((IResource)folder);
        list.add(JavaCore.newSourceEntry((IPath)ipackagefragmentroot.getPath()));
    }

    protected IFolder createFolder(IJavaProject project, String s, IProgressMonitor monitor) throws CoreException {
        IFolder folder = project.getProject().getFolder(s);
        this.createFolder(folder, monitor);
        return folder;
    }

    protected void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IContainer container = folder.getParent();
        if (container != null && !container.exists() && container instanceof IFolder) {
            this.createFolder((IFolder)container, monitor);
        }
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
    }
}

