/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.VisitedAgendaGroup;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.conflict.PhreakConflictResolver;
import org.drools.core.conflict.SequentialConflictResolver;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BinaryHeapQueue;

public class AgendaGroupQueueImpl
implements InternalAgendaGroup,
InternalRuleFlowGroup {
    private static final long serialVersionUID = 510L;
    private final String name;
    private final BinaryHeapQueue priorityQueue;
    private volatile boolean active;
    private PropagationContext autoFocusActivator;
    private long activatedForRecency;
    private long clearedForRecency;
    private InternalWorkingMemory workingMemory;
    private boolean autoDeactivate = true;
    private Map<Long, String> nodeInstances = new ConcurrentHashMap<Long, String>();
    private volatile boolean hasRuleFlowLister;
    private Activation lastRemoved;
    private boolean sequential;
    private static final Activation visited = new VisitedAgendaGroup();

    public AgendaGroupQueueImpl(String name, InternalKnowledgeBase kBase) {
        this.name = name;
        this.priorityQueue = kBase.getConfiguration().isPhreakEnabled() ? new BinaryHeapQueue(new PhreakConflictResolver()) : (kBase.getConfiguration().isSequential() ? new BinaryHeapQueue(new SequentialConflictResolver()) : new BinaryHeapQueue(kBase.getConfiguration().getConflictResolver()));
        this.sequential = kBase.getConfiguration().isSequential();
        this.clearedForRecency = -1L;
    }

    @Override
    public void visited() {
        if (this.sequential) {
            this.lastRemoved = visited;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public void hasRuleFlowListener(boolean hasRuleFlowLister) {
        this.hasRuleFlowLister = hasRuleFlowLister;
    }

    @Override
    public boolean isRuleFlowListener() {
        return this.hasRuleFlowLister;
    }

    public void clear() {
        this.workingMemory.getAgenda().clearAndCancelAgendaGroup(this.name);
    }

    @Override
    public void reset() {
        this.priorityQueue.clear();
    }

    @Override
    public Activation[] getAndClear() {
        return this.priorityQueue.getAndClear();
    }

    @Override
    public int size() {
        return this.priorityQueue.size();
    }

    @Override
    public void add(Activation activation) {
        if (this.lastRemoved != null && (this.lastRemoved == activation || this.lastRemoved == visited || PhreakConflictResolver.doCompare(this.lastRemoved, activation) < 0)) {
            return;
        }
        this.priorityQueue.enqueue(activation);
    }

    @Override
    public Activation remove() {
        Activation match = this.priorityQueue.dequeue();
        if (this.sequential) {
            this.lastRemoved = match;
        }
        return match;
    }

    @Override
    public Activation peek() {
        return this.priorityQueue.peek();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void deactivateIfEmpty() {
    }

    @Override
    public boolean isAutoDeactivate() {
        return this.autoDeactivate;
    }

    @Override
    public void setAutoDeactivate(boolean autoDeactivate) {
        this.autoDeactivate = autoDeactivate;
    }

    @Override
    public void addNodeInstance(Long processInstanceId, String nodeInstanceId) {
        this.nodeInstances.put(processInstanceId, nodeInstanceId);
    }

    @Override
    public void removeNodeInstance(Long processInstanceId, String nodeInstanceId) {
        this.nodeInstances.put(processInstanceId, nodeInstanceId);
    }

    @Override
    public void setActive(boolean activate) {
        this.active = activate;
    }

    @Override
    public PropagationContext getAutoFocusActivator() {
        return this.autoFocusActivator;
    }

    @Override
    public void setAutoFocusActivator(PropagationContext autoFocusActivator) {
        this.autoFocusActivator = autoFocusActivator;
    }

    @Override
    public boolean isEmpty() {
        return this.priorityQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Activation[] getActivations() {
        BinaryHeapQueue binaryHeapQueue = this.priorityQueue;
        synchronized (binaryHeapQueue) {
            return (Activation[])this.priorityQueue.toArray(new AgendaItem[this.priorityQueue.size()]);
        }
    }

    @Override
    public Map<Long, String> getNodeInstances() {
        return this.nodeInstances;
    }

    public String toString() {
        return "AgendaGroup '" + this.name + "'";
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AgendaGroupQueueImpl)) {
            return false;
        }
        return ((AgendaGroupQueueImpl)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setFocus() {
        this.workingMemory.getAgenda().setFocus(this.name);
    }

    @Override
    public void remove(Activation activation) {
        this.priorityQueue.dequeue(activation);
    }

    @Override
    public long getActivatedForRecency() {
        return this.activatedForRecency;
    }

    @Override
    public void setActivatedForRecency(long recency) {
        this.activatedForRecency = recency;
    }

    @Override
    public long getClearedForRecency() {
        return this.clearedForRecency;
    }

    @Override
    public void setClearedForRecency(long recency) {
        this.clearedForRecency = recency;
    }

    @Override
    public boolean isSequential() {
        return this.sequential;
    }

    public static class DeactivateCallback
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private static final long serialVersionUID = 510L;
        private InternalRuleFlowGroup ruleFlowGroup;

        public DeactivateCallback(InternalRuleFlowGroup ruleFlowGroup) {
            this.ruleFlowGroup = ruleFlowGroup;
        }

        public DeactivateCallback(MarshallerReaderContext context) throws IOException {
            this.ruleFlowGroup = (InternalRuleFlowGroup)context.wm.getAgenda().getRuleFlowGroup(context.readUTF());
        }

        public DeactivateCallback(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            this.ruleFlowGroup = (InternalRuleFlowGroup)context.wm.getAgenda().getRuleFlowGroup(_action.getDeactivateCallback().getRuleflowGroup());
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.DEACTIVATE_CALLBACK).setDeactivateCallback(ProtobufMessages.ActionQueue.DeactivateCallback.newBuilder().setRuleflowGroup(this.ruleFlowGroup.getName()).build()).build();
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            if (this.ruleFlowGroup.isEmpty()) {
                this.ruleFlowGroup.setActive(false);
            }
        }
    }
}

