/*
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.eclipse.wizard.project;

import org.drools.eclipse.preferences.DroolsProjectPreferencePage;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.wizard.project.AbstractKieProjectRuntimeWizardPage;

public class NewDroolsProjectRuntimeWizardPage extends AbstractKieProjectRuntimeWizardPage {

    public NewDroolsProjectRuntimeWizardPage(String pageName) {
        super(pageName);
        setTitle("Drools Runtime");
        setDescription("Select a Drools Runtime");
    }

	@Override
	public IRuntimeManager getRuntimeManager() {
		return DroolsRuntimeManager.getDefault();
	}

	@Override
	protected IRuntime createRuntime() {
		return new DroolsRuntime();
	}

	@Override
	public int showRuntimePreferenceDialog() {
        return PreferencesUtil.createPreferenceDialogOn(getShell(),
                DroolsProjectPreferencePage.PREF_ID,
                new String[] { DroolsProjectPreferencePage.PROP_ID }, null).open();
	}
    
    protected boolean isComplete() {
    	return !DroolsRuntime.ID_DROOLS_6.equals(getRuntimeId()) || (getGroupId().length() > 0 && getArtifactId().length() > 0 && getVersion().length() > 0);
    }
}
