/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer.impl;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.core.timer.SchedulerServiceInterceptor;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.DelegateSchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.instance.timer.TimerManager;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.SimpleTrigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.JobStoreCMT;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzSchedulerService
implements GlobalSchedulerService {
    private static final Logger logger = LoggerFactory.getLogger(QuartzSchedulerService.class);
    private static final Integer START_DELAY = Integer.parseInt(System.getProperty("org.jbpm.timer.delay", "2"));
    private AtomicLong idCounter = new AtomicLong();
    private TimerService globalTimerService;
    private SchedulerServiceInterceptor interceptor = new DelegateSchedulerServiceInterceptor(this);
    private static Scheduler scheduler;
    private static AtomicInteger timerServiceCounter;

    public JobHandle scheduleJob(org.drools.core.time.Job job, JobContext ctx, Trigger trigger) {
        Long id = this.idCounter.getAndIncrement();
        String jobname = null;
        if (ctx instanceof TimerManager.ProcessJobContext) {
            TimerManager.ProcessJobContext processCtx = (TimerManager.ProcessJobContext)ctx;
            jobname = processCtx.getSessionId() + "-" + processCtx.getProcessInstanceId() + "-" + processCtx.getTimer().getId();
            if (processCtx instanceof TimerManager.StartProcessJobContext) {
                jobname = "StartProcess-" + ((TimerManager.StartProcessJobContext)processCtx).getProcessId() + "-" + processCtx.getTimer().getId();
            }
        } else {
            jobname = ctx instanceof NamedJobContext ? ((NamedJobContext)ctx).getJobName() : "Timer-" + ctx.getClass().getSimpleName() + "-" + id;
        }
        logger.debug("Scheduling timer with name " + jobname);
        try {
            JobDetail jobDetail = scheduler.getJobDetail(jobname, "jbpm");
            if (jobDetail != null) {
                TimerJobInstance timerJobInstance = (TimerJobInstance)jobDetail.getJobDataMap().get((Object)"timerJobInstance");
                return timerJobInstance.getJobHandle();
            }
        }
        catch (SchedulerException jobDetail) {
            // empty catch block
        }
        GlobalQuartzJobHandle quartzJobHandle = new GlobalQuartzJobHandle(id, jobname, "jbpm");
        TimerJobInstance jobInstance = this.globalTimerService.getTimerJobFactoryManager().createTimerJobInstance(job, ctx, trigger, (JobHandle)quartzJobHandle, (InternalSchedulerService)this.globalTimerService);
        quartzJobHandle.setTimerJobInstance(jobInstance);
        this.interceptor.internalSchedule(jobInstance);
        return quartzJobHandle;
    }

    public boolean removeJob(JobHandle jobHandle) {
        GlobalQuartzJobHandle quartzJobHandle = (GlobalQuartzJobHandle)jobHandle;
        try {
            boolean removed = scheduler.deleteJob(quartzJobHandle.getJobName(), quartzJobHandle.getJobGroup());
            return removed;
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Exception while removing job", e);
        }
        catch (RuntimeException e) {
            try {
                SchedulerMetaData metadata = scheduler.getMetaData();
                if (metadata.getJobStoreClass().isAssignableFrom(JobStoreCMT.class)) {
                    return true;
                }
            }
            catch (SchedulerException schedulerException) {
                // empty catch block
            }
            throw e;
        }
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        GlobalQuartzJobHandle quartzJobHandle = (GlobalQuartzJobHandle)timerJobInstance.getJobHandle();
        JobDetail jobq = new JobDetail(quartzJobHandle.getJobName(), quartzJobHandle.getJobGroup(), QuartzJob.class);
        jobq.setRequestsRecovery(true);
        jobq.getJobDataMap().put((Object)"timerJobInstance", (Object)timerJobInstance);
        SimpleTrigger triggerq = new SimpleTrigger(quartzJobHandle.getJobName() + "_trigger", quartzJobHandle.getJobGroup(), timerJobInstance.getTrigger().hasNextFireTime());
        try {
            if (scheduler.isShutdown()) {
                return;
            }
            this.globalTimerService.getTimerJobFactoryManager().addTimerJobInstance(timerJobInstance);
            JobDetail jobDetail = scheduler.getJobDetail(quartzJobHandle.getJobName(), quartzJobHandle.getJobGroup());
            if (jobDetail == null) {
                scheduler.scheduleJob(jobq, (org.quartz.Trigger)triggerq);
            } else {
                scheduler.addJob(jobq, true);
                triggerq.setJobName(quartzJobHandle.getJobName());
                triggerq.setJobGroup(quartzJobHandle.getJobGroup());
                scheduler.rescheduleJob(quartzJobHandle.getJobName() + "_trigger", quartzJobHandle.getJobGroup(), (org.quartz.Trigger)triggerq);
            }
        }
        catch (ObjectAlreadyExistsException e) {
            logger.warn("Job has already been scheduled, most likely running in cluster: {}", (Object)e.getMessage());
        }
        catch (JobPersistenceException e) {
            if (e.getCause() instanceof NotSerializableException) {
                this.internalSchedule(new InmemoryTimerJobInstanceDelegate(quartzJobHandle.getJobName(), ((GlobalTimerService)this.globalTimerService).getTimerServiceId()));
            }
            this.globalTimerService.getTimerJobFactoryManager().removeTimerJobInstance(timerJobInstance);
            throw new RuntimeException(e);
        }
        catch (SchedulerException e) {
            this.globalTimerService.getTimerJobFactoryManager().removeTimerJobInstance(timerJobInstance);
            throw new RuntimeException("Exception while scheduling job", e);
        }
    }

    @Override
    public synchronized void initScheduler(TimerService timerService) {
        this.globalTimerService = timerService;
        timerServiceCounter.incrementAndGet();
        if (scheduler == null) {
            try {
                scheduler = StdSchedulerFactory.getDefaultScheduler();
                scheduler.startDelayed(START_DELAY.intValue());
            }
            catch (SchedulerException e) {
                throw new RuntimeException("Exception when initializing QuartzSchedulerService", e);
            }
            if (this.isTransactional()) {
                System.setProperty("org.jbpm.rm.init.timer", "false");
            }
        }
    }

    @Override
    public void shutdown() {
        if (scheduler == null) {
            return;
        }
        int current = timerServiceCounter.decrementAndGet();
        if (scheduler != null && current == 0) {
            try {
                scheduler.shutdown();
            }
            catch (SchedulerException e) {
                logger.warn("Error encountered while shutting down the scheduler", (Throwable)e);
            }
            scheduler = null;
        }
    }

    public void forceShutdown() {
        if (scheduler != null) {
            try {
                scheduler.shutdown();
                timerServiceCounter.set(0);
            }
            catch (SchedulerException e) {
                logger.warn("Error encountered while shutting down (forced) the scheduler", (Throwable)e);
            }
            scheduler = null;
        }
    }

    @Override
    public JobHandle buildJobHandleForContext(NamedJobContext ctx) {
        return new GlobalQuartzJobHandle(-1L, ctx.getJobName(), "jbpm");
    }

    @Override
    public boolean isTransactional() {
        try {
            Class jobStoreClass = scheduler.getMetaData().getJobStoreClass();
            if (JobStoreSupport.class.isAssignableFrom(jobStoreClass)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.warn("Unable to determine if quartz is transactional due to problems when checking job store class", (Throwable)e);
        }
        return false;
    }

    @Override
    public void setInterceptor(SchedulerServiceInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Override
    public boolean retryEnabled() {
        return false;
    }

    @Override
    public boolean isValid(GlobalTimerService.GlobalJobHandle jobHandle) {
        if (scheduler == null && !this.isTransactional()) {
            return true;
        }
        JobDetail jobDetail = null;
        try {
            jobDetail = scheduler.getJobDetail(((GlobalQuartzJobHandle)jobHandle).getJobName(), ((GlobalQuartzJobHandle)jobHandle).getJobGroup());
        }
        catch (SchedulerException e) {
            logger.warn("Cannot fetch job detail for job handle {}", (Object)jobHandle);
        }
        return jobDetail != null;
    }

    static {
        timerServiceCounter = new AtomicInteger(0);
    }

    public static class InmemoryTimerJobInstanceDelegate
    implements TimerJobInstance,
    Serializable,
    Callable<Void> {
        private static final long serialVersionUID = 1L;
        private String jobname;
        private String timerServiceId;
        private transient TimerJobInstance delegate;

        public InmemoryTimerJobInstanceDelegate(String jobName, String timerServiceId) {
            this.jobname = jobName;
            this.timerServiceId = timerServiceId;
        }

        public JobHandle getJobHandle() {
            this.findDelegate();
            return this.delegate.getJobHandle();
        }

        public org.drools.core.time.Job getJob() {
            this.findDelegate();
            return this.delegate.getJob();
        }

        public Trigger getTrigger() {
            this.findDelegate();
            return this.delegate.getTrigger();
        }

        public JobContext getJobContext() {
            this.findDelegate();
            return this.delegate.getJobContext();
        }

        protected void findDelegate() {
            if (this.delegate == null) {
                Collection timers = TimerServiceRegistry.getInstance().get(this.timerServiceId).getTimerJobFactoryManager().getTimerJobInstances();
                for (TimerJobInstance instance : timers) {
                    if (!((GlobalQuartzJobHandle)instance.getJobHandle()).getJobName().equals(this.jobname)) continue;
                    this.delegate = instance;
                    break;
                }
            }
        }

        @Override
        public Void call() throws Exception {
            this.findDelegate();
            return (Void)((Callable)this.delegate).call();
        }
    }

    public static class QuartzJob
    implements Job {
        public void execute(JobExecutionContext quartzContext) throws JobExecutionException {
            TimerJobInstance timerJobInstance = (TimerJobInstance)quartzContext.getJobDetail().getJobDataMap().get((Object)"timerJobInstance");
            try {
                ((Callable)timerJobInstance).call();
            }
            catch (Exception e) {
                boolean reschedule = true;
                Integer failedCount = (Integer)quartzContext.getJobDetail().getJobDataMap().get((Object)"failedCount");
                if (failedCount == null) {
                    failedCount = new Integer(0);
                }
                Integer n = failedCount;
                Integer n2 = failedCount = Integer.valueOf(failedCount + 1);
                quartzContext.getJobDetail().getJobDataMap().put((Object)"failedCount", (Object)failedCount);
                if (failedCount > 5) {
                    logger.error("Timer execution failed 5 times in a roll, unscheduling ({})", (Object)quartzContext.getJobDetail().getFullName());
                    reschedule = false;
                }
                try {
                    Thread.sleep(failedCount * 1000);
                }
                catch (InterruptedException e1) {
                    logger.debug("Got interrupted", (Throwable)e1);
                }
                throw new JobExecutionException("Exception when executing scheduled job", (Throwable)e, reschedule);
            }
        }
    }

    public static class GlobalQuartzJobHandle
    extends GlobalTimerService.GlobalJobHandle {
        private static final long serialVersionUID = 510L;
        private String jobName;
        private String jobGroup;

        public GlobalQuartzJobHandle(long id, String name, String group) {
            super(id);
            this.jobName = name;
            this.jobGroup = group;
        }

        public String getJobName() {
            return this.jobName;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public String getJobGroup() {
            return this.jobGroup;
        }

        public void setJobGroup(String jobGroup) {
            this.jobGroup = jobGroup;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.jobGroup == null ? 0 : this.jobGroup.hashCode());
            result = 31 * result + (this.jobName == null ? 0 : this.jobName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            GlobalQuartzJobHandle other = (GlobalQuartzJobHandle)((Object)obj);
            if (this.jobGroup == null ? other.jobGroup != null : !this.jobGroup.equals(other.jobGroup)) {
                return false;
            }
            return !(this.jobName == null ? other.jobName != null : !this.jobName.equals(other.jobName));
        }

        public String toString() {
            return "GlobalQuartzJobHandle [jobName=" + this.jobName + ", jobGroup=" + this.jobGroup + "]";
        }
    }
}

