/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.query;

import java.sql.Timestamp;
import java.util.Date;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.command.AuditCommand;
import org.jbpm.query.jpa.builder.impl.AbstractDeleteBuilderImpl;
import org.jbpm.query.jpa.data.QueryWhere;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Context;
import org.kie.internal.query.ParametrizedUpdate;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.runtime.manager.audit.query.AuditDeleteBuilder;

public abstract class AbstractAuditDeleteBuilderImpl<T>
extends AbstractDeleteBuilderImpl<T>
implements AuditDeleteBuilder<T> {
    protected final CommandExecutor executor;
    protected final JPAAuditLogService jpaAuditService;
    private AuditCommand<JPAAuditLogService> getJpaAuditLogServiceCommand = new AuditCommand<JPAAuditLogService>(){
        private static final long serialVersionUID = 101L;

        public JPAAuditLogService execute(Context context) {
            this.setLogEnvironment(context);
            return (JPAAuditLogService)this.auditLogService;
        }
    };

    protected AbstractAuditDeleteBuilderImpl(JPAAuditLogService jpaService) {
        this.executor = null;
        this.jpaAuditService = jpaService;
    }

    protected AbstractAuditDeleteBuilderImpl(CommandExecutor cmdExecutor) {
        this.executor = cmdExecutor;
        this.jpaAuditService = null;
    }

    protected JPAAuditLogService getJpaAuditLogService() {
        JPAAuditLogService jpaAuditLogService = this.jpaAuditService;
        if (jpaAuditLogService == null) {
            jpaAuditLogService = (JPAAuditLogService)this.executor.execute(this.getJpaAuditLogServiceCommand);
        }
        return jpaAuditLogService;
    }

    public T date(Date ... date) {
        if (this.checkIfNull(date)) {
            return (T)((Object)this);
        }
        date = this.ensureDateNotTimestamp(date);
        this.addObjectParameter(QueryParameterIdentifiers.DATE_LIST, "date", date);
        return (T)((Object)this);
    }

    public T dateRangeStart(Date rangeStart) {
        if (this.checkIfNull(rangeStart)) {
            return (T)((Object)this);
        }
        rangeStart = this.ensureDateNotTimestamp(rangeStart)[0];
        this.addRangeParameter(QueryParameterIdentifiers.DATE_LIST, "date range start", rangeStart, true);
        return (T)((Object)this);
    }

    public T dateRangeEnd(Date rangeEnd) {
        if (this.checkIfNull(rangeEnd)) {
            return (T)((Object)this);
        }
        rangeEnd = this.ensureDateNotTimestamp(rangeEnd)[0];
        this.addRangeParameter(QueryParameterIdentifiers.DATE_LIST, "date range end", rangeEnd, false);
        return (T)((Object)this);
    }

    public T processInstanceId(long ... processInstanceId) {
        if (this.checkIfNull((T[])new long[][]{processInstanceId})) {
            return (T)((Object)this);
        }
        this.addLongParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id", processInstanceId);
        return (T)((Object)this);
    }

    public T processId(String ... processId) {
        if (this.checkIfNull(processId)) {
            return (T)((Object)this);
        }
        this.addObjectParameter(QueryParameterIdentifiers.PROCESS_ID_LIST, "process id", processId);
        return (T)((Object)this);
    }

    protected <T> boolean checkIfNull(T ... parameter) {
        if (parameter == null) {
            return true;
        }
        for (int i = 0; i < parameter.length; ++i) {
            if (parameter[i] != null) continue;
            return true;
        }
        return false;
    }

    protected Date[] ensureDateNotTimestamp(Date ... date) {
        Date[] validated = new Date[date.length];
        for (int i = 0; i < date.length; ++i) {
            validated[i] = date[i] instanceof Timestamp ? new Date(date[i].getTime()) : date[i];
        }
        return validated;
    }

    protected abstract Class getQueryType();

    protected abstract String getQueryBase();

    public ParametrizedUpdate build() {
        return new ParametrizedUpdate(){
            private QueryWhere queryWhere;
            {
                this.queryWhere = new QueryWhere(AbstractAuditDeleteBuilderImpl.this.getQueryWhere());
            }

            public int execute() {
                int result = AbstractAuditDeleteBuilderImpl.this.getJpaAuditLogService().doDelete(AbstractAuditDeleteBuilderImpl.this.getQueryBase(), this.queryWhere, AbstractAuditDeleteBuilderImpl.this.getQueryType());
                return result;
            }
        };
    }
}

